/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;

public class TimeDuration {
    private static final int TIME_FLAG = 8;
    private int mYear = 0;
    private int mMonth = 0;
    private int mDay = 0;
    private int mHour = 0;
    private int mMinute = 0;
    private int mSecond = 0;
    private int mMillisecond = 0;
    private int mMillidigits = 0;
    private boolean mIsNegative = false;

    public static TimeDuration parse(char[] str) {
        if (str == null || str.length == 0) {
            throw new MarshalException("TimeDuration value must not be null");
        }
        TimeDuration result = new TimeDuration();
        int idx = 0;
        if (str[idx] == '-') {
            result.setNegative();
            if (++idx >= str.length) {
                throw new MarshalException("'-' is placed wrong in the TimeDuration value");
            }
        }
        if (str[idx] != 'P') {
            throw new MarshalException("Missing 'P' delimiter");
        }
        ++idx;
        int number = 0;
        int milli = 0;
        int millidigits = 0;
        boolean hasNumber = false;
        boolean hasDot = false;
        int flags = 0;
        block8: while (idx < str.length) {
            char ch = str[idx++];
            switch (ch) {
                case 'Y': {
                    if (flags > 0) {
                        throw new MarshalException("Syntax error: 'Y' must precede all other delimiters");
                    }
                    flags = 64;
                    if (hasDot) {
                        throw new MarshalException("Number preceding 'Y' must not have a decimal point");
                    }
                    if (hasNumber) {
                        result.setYear(number);
                        hasNumber = false;
                        continue block8;
                    }
                    throw new MarshalException("Syntax error: missing number of years before 'Y'");
                }
                case 'M': {
                    if ((flags & 8) == 8) {
                        if ((flags & 3) > 0) {
                            throw new MarshalException("Syntax error");
                        }
                        flags |= 2;
                        if (hasDot) {
                            throw new MarshalException("Number preceding 'M' must not have a decimal point");
                        }
                        if (hasNumber) {
                            result.setMinute(number);
                            hasNumber = false;
                            continue block8;
                        }
                        throw new MarshalException("Syntax error: missing number of minutes before 'M'");
                    }
                    if ((flags & 0x3F) > 0) {
                        throw new MarshalException("Syntax error");
                    }
                    flags |= 0x20;
                    if (hasDot) {
                        throw new MarshalException("Number preceding 'M' must not have a decimal point");
                    }
                    if (hasNumber) {
                        result.setMonth(number);
                        hasNumber = false;
                        continue block8;
                    }
                    throw new MarshalException("Syntax error: missing number of months before 'M'");
                }
                case 'D': {
                    if ((flags & 0x1F) > 0) {
                        throw new MarshalException("Syntax error");
                    }
                    flags |= 0x10;
                    if (hasDot) {
                        throw new MarshalException("Number preceding 'D' must not have a decimal point");
                    }
                    if (hasNumber) {
                        result.setDay(number);
                        hasNumber = false;
                        continue block8;
                    }
                    throw new MarshalException("Syntax error: missing number of days before 'D'");
                }
                case 'T': {
                    if ((flags & 8) == 8) {
                        throw new MarshalException("Syntax error: 'T' may not exist more than once");
                    }
                    flags |= 8;
                    continue block8;
                }
                case 'H': {
                    if ((flags & 0xF) != 8) {
                        String err = null;
                        err = (flags & 8) != 8 ? "Syntax error: missing 'T' before 'H'" : "Syntax error: 'H' must appear for 'M' or 'S'";
                        throw new MarshalException(err);
                    }
                    flags |= 4;
                    if (hasDot) {
                        throw new MarshalException("Number preceding 'H' must not have a decimal point");
                    }
                    if (hasNumber) {
                        result.setHour(number);
                        hasNumber = false;
                        continue block8;
                    }
                    throw new MarshalException("Syntax error: missing number of hours before 'H'");
                }
                case 'S': {
                    if ((flags & 8) != 8) {
                        throw new MarshalException("Syntax error: missing 'T' before 'S'");
                    }
                    if ((flags & 1) == 1) {
                        throw new MarshalException("Syntax error: 'S' may not exist more than once");
                    }
                    flags |= 1;
                    if (hasNumber) {
                        result.setSeconds(number, milli, millidigits);
                        hasNumber = false;
                    } else if (!hasDot) {
                        throw new MarshalException("Syntax error: missing number of seconds before 'S'");
                    }
                    if (!hasDot) continue block8;
                    hasDot = false;
                    millidigits = 0;
                    continue block8;
                }
            }
            if (ch == '.') {
                hasDot = true;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                if (hasDot) {
                    milli = milli * 10 + (ch - 48);
                    ++millidigits;
                    continue;
                }
                if (hasNumber) {
                    number = number * 10 + (ch - 48);
                    continue;
                }
                hasNumber = true;
                number = ch - 48;
                continue;
            }
            throw new MarshalException("Syntax error: invalid character '" + ch + "'");
        }
        if ((flags & 0xF) == 8) {
            throw new MarshalException("Syntax error: T must be omitted");
        }
        if (hasNumber) {
            throw new MarshalException("Syntax error: expecting ending delimiter");
        }
        return result;
    }

    public int getDay() {
        return this.mDay;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMilliDigits() {
        return this.mMillidigits;
    }

    public int getMilliseconds() {
        return this.mMillisecond;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getSeconds() {
        return this.mSecond;
    }

    public int getYear() {
        return this.mYear;
    }

    public boolean isNegative() {
        return this.mIsNegative;
    }

    public void setDay(int day) {
        this.mDay = day;
    }

    public void setHour(int hour) {
        this.mHour = hour;
    }

    public void setMinute(int minute) {
        this.mMinute = minute;
    }

    public void setMonth(int month) {
        this.mMonth = month;
    }

    public void setNegative() {
        this.mIsNegative = true;
    }

    public void setSeconds(int second, int millisecond, int millidigits) {
        this.mSecond = second;
        this.mMillisecond = millisecond;
        this.mMillidigits = millidigits;
    }

    public void setValue(int year, int month, int day, int hour, int minute, int second, int millisecond, int millidigits) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSeconds(second, millisecond, millidigits);
    }

    public void setYear(int year) {
        this.mYear = year;
    }

    public String toString() {
        boolean isThereTime;
        String result = "P";
        if (this.mYear != 0) {
            result = result + String.valueOf(this.mYear) + "Y";
        }
        if (this.mMonth != 0) {
            result = result + String.valueOf(this.mMonth) + "M";
        }
        if (this.mDay != 0) {
            result = result + String.valueOf(this.mDay) + "D";
        }
        boolean bl = isThereTime = this.mHour != 0 || this.mMinute != 0 || this.mSecond != 0;
        if (isThereTime) {
            result = result + "T";
            if (this.mHour != 0) {
                result = result + String.valueOf(this.mHour) + "H";
            }
            if (this.mMinute != 0) {
                result = result + String.valueOf(this.mMinute) + "M";
            }
            if (this.mSecond != 0) {
                result = result + String.valueOf(this.mSecond);
            }
            if (this.mMillisecond != 0) {
                result = result + ".";
                String temp = String.valueOf(this.mMillisecond);
                if (temp.length() < this.mMillidigits) {
                    for (int i = 0; i < this.mMillidigits - temp.length(); ++i) {
                        result = result + "0";
                    }
                }
                result = result + temp;
            }
            if (this.mSecond != 0 || this.mMillisecond != 0) {
                result = result + "S";
            }
        }
        result = this.mIsNegative ? "-" + result : result;
        return result;
    }
}

