/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.xsd.datatype.TimePeriod;

public class Year
extends TimePeriod {
    protected static final char[] INIT_DURATION = new char[]{'P', '1', 'Y'};

    public Year() {
        super(INIT_DURATION);
    }

    public static Year parseYear(char[] value) {
        Year result = new Year();
        String str = new String(value);
        if (str.length() < 5) {
            throw new MarshalException("Year bad format");
        }
        if (str.charAt(0) == '-') {
            result.setNegative();
            str = str.substring(1);
        }
        if (str.length() < 4) {
            throw new MarshalException("Year bad format");
        }
        int i = Integer.parseInt(str.substring(0, str.length() - 2));
        result.setCentury(i);
        i = Integer.parseInt(str.substring(str.length() - 2));
        result.setYear(i);
        return result;
    }

    public String toString() {
        String result = this.mIsNegative ? "-" : "";
        String temp = String.valueOf(this.mCentury);
        result = result + temp;
        temp = String.valueOf(this.mYear);
        if (temp.length() < 2) {
            temp = "0" + temp;
        }
        result = result + temp;
        return result;
    }
}

