/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.fog.provider;

import com.stc.otd.fog.FogComposite;
import com.stc.otd.fog.FogNode;
import com.stc.otd.fog.FogOverlay;
import com.stc.otd.fog.FogPath;
import com.stc.otd.fog.FogPropType;
import com.stc.otd.fog.FogPropValue;
import com.stc.otd.fog.FogPropValueMap;
import com.stc.otd.fog.FpiOrder;
import com.stc.otd.fog.FpiPropValueMap;
import java.util.Iterator;

public class Node
implements FogNode {
    private final int mKey;
    private final FogOverlay mOverlay;
    private FogComposite mComposite = null;
    private FpiPropValueMap mFogPropValueMap = null;
    private boolean mUsedAttr = false;
    static /* synthetic */ Class class$java$lang$Boolean;

    public Node(int key, FogOverlay overlay) {
        if (overlay == null) {
            throw new NullPointerException("node requires overlay");
        }
        if (overlay.getType() != 4) {
            throw new IllegalArgumentException("node born in wrong overlay");
        }
        this.mKey = key;
        this.mOverlay = overlay;
        this.mFogPropValueMap = ((FpiOrder)this.mOverlay.getOrder()).createPropValueMap(this.getComposite());
    }

    private FogComposite getComposite() {
        if (this.mComposite == null) {
            this.mComposite = this.mOverlay.getOrder().getNode(this.mKey);
        }
        return this.mComposite;
    }

    private boolean isOther() {
        return this.getComposite().getNodeType() == 2;
    }

    private boolean isMain() {
        FogComposite node = this.getComposite();
        return node.getOrder().getMain() == node;
    }

    private boolean isTop() {
        FogComposite node = this.getComposite();
        FogPropValue value = node.getProp("top", null);
        return value != null && value.getType().getType() == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Node.class$("java.lang.Boolean")) : class$java$lang$Boolean) && (Boolean)value.getValue() != false;
    }

    private boolean isSimple() {
        return this.getComposite().isSimple();
    }

    private FogPropValue var(String name, FogPropType type, Object value) {
        return ((FpiOrder)this.getComposite().getOrder()).createPropValue(name, type, value, true, (FogNode)this);
    }

    public int getKey() {
        return this.mKey;
    }

    public void addPropValueMap(FpiPropValueMap map, FogPath path) {
        Iterator it = this.mFogPropValueMap.iterator();
        while (it.hasNext()) {
            FogPropValue propValue = (FogPropValue)it.next();
            map.add(propValue);
        }
    }

    public FogOverlay getOverlay() {
        return this.mOverlay;
    }

    public FogPropValueMap getPropValueMap(FogPath path) {
        if (this.mFogPropValueMap == null) {
            FogComposite node = this.getComposite();
            FpiPropValueMap fpiPropValueMap = ((FpiOrder)node.getOrder()).createPropValueMap(node);
        }
        return this.mFogPropValueMap;
    }

    public FogPropValue getPropValue(String name, FogPath path) {
        if (name == null) {
            throw new NullPointerException("null property name");
        }
        return this.mFogPropValueMap.get(name);
    }

    public FogPropValue getPropValue(String name) {
        return this.getPropValue(name, null);
    }

    public boolean setProp(String name, FogPropType type, Object value) {
        FogPropValue propValue = this.var(name, type, value);
        this.mFogPropValueMap.add(propValue);
        return true;
    }

    public boolean setProps(FpiOrder.PropMap attr) {
        this.mUsedAttr = false;
        Iterator it = attr.iterator();
        while (it.hasNext()) {
            FpiOrder.PropMap.PropMapEntry entry = (FpiOrder.PropMap.PropMapEntry)it.next();
            if (entry == null || entry.isUsed()) continue;
            this.setProp(entry.getName(), entry.getType(), entry.getValue());
            entry.use();
            this.mUsedAttr = true;
        }
        return this.mUsedAttr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

