/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.fog.provider;

import com.stc.otd.fog.FogChild;
import com.stc.otd.fog.FogChildList;
import com.stc.otd.fog.FogComposite;
import com.stc.otd.fog.FogNode;
import com.stc.otd.fog.FogOrder;
import com.stc.otd.fog.FogOverlay;
import com.stc.otd.fog.FogPath;
import com.stc.otd.fog.FogPropType;
import com.stc.otd.fog.FogPropValue;
import com.stc.otd.fog.FpiOrder;
import com.stc.otd.fog.FpiOverlay;
import com.stc.otd.fog.FpiPropValueMap;
import com.stc.otd.fog.FpiVerifyReport;
import com.stc.otd.fog.provider.FogActions;
import com.stc.otd.tools.util.IntMap;
import com.stc.otd.xsd.fog.provider.Node;
import java.util.HashSet;
import java.util.Iterator;

public class Overlay
implements FogOverlay,
FpiOverlay {
    private int mNextKey = 0;
    private IntMap mNodes = new IntMap();
    private final FpiOrder mOrder;
    private FogActions mFogActions;

    public Overlay(FpiOrder order) {
        this.mOrder = order;
        this.mFogActions = new FogActions((FogOrder)order);
    }

    private Node createMyNode(int key) {
        if (this.mNextKey <= key) {
            this.mNextKey = key + 1;
        }
        Node node = new Node(key, this);
        this.mNodes.put(key, (Object)node);
        return node;
    }

    public Node createNode() {
        return this.createMyNode(this.mOrder.makeKey());
    }

    public FogOrder getOrder() {
        return this.mOrder;
    }

    public byte getType() {
        return 4;
    }

    public Iterator iterator() {
        return this.mNodes.iterator();
    }

    private static boolean isGroupOrChoice(FogComposite fogComp) {
        byte nodeType = fogComp.getNodeType();
        return nodeType == 5 || nodeType == 6;
    }

    public void verify(FpiVerifyReport report) {
        FogComposite mainComp = this.mOrder.getMain();
        FogPath rootPath = this.mFogActions.createPath(null, -1, mainComp);
        HashSet visited = new HashSet();
        FogChildList tops = mainComp.getChildren();
        int i = tops.size();
        while (i-- > 0) {
            Boolean isTop;
            FogComposite node = mainComp.getChild(i).getNode();
            FogPropValue top = node.getProp("top", rootPath);
            if (top == null || (isTop = (Boolean)top.getValue()) == null || !isTop.booleanValue()) continue;
            FogPath childPath = this.mFogActions.createPath(rootPath, i, node);
            this.verifyRecursive(childPath, report, visited);
        }
    }

    private void verifyRecursive(FogPath fogPath, FpiVerifyReport report, HashSet visited) {
        FogComposite comp = fogPath.getComposite();
        if (visited.contains(comp)) {
            return;
        }
        visited.add(comp);
        if (comp != this.mOrder.getMain() && Overlay.isGroupOrChoice(comp) && comp.countChildren() == 0) {
            report.fail(this.fogPathToString(fogPath) + ": element must have children", new FogComposite[]{comp});
        }
        for (int i = 0; i < comp.countChildren(); ++i) {
            FogPath childPath = this.mFogActions.createPath(fogPath, i, comp.getChild(i).getNode());
            this.verifyRecursive(childPath, report, visited);
        }
    }

    private String fogPathToString(FogPath fogPath) {
        StringBuffer strBuf = new StringBuffer();
        FogComposite mainComp = this.mOrder.getMain();
        FogPath currPath = fogPath;
        boolean first = true;
        while (currPath.getComposite() != mainComp) {
            if (first) {
                first = false;
            } else {
                strBuf.insert(0, '/');
            }
            FogPath prevPath = currPath.getPrevious();
            FogChild child = prevPath.getComposite().getChild(currPath.getIndex());
            String childName = child.getName();
            strBuf.insert(0, childName);
            currPath = prevPath;
        }
        return strBuf.toString();
    }

    public int nextKey() {
        return this.mNextKey;
    }

    public FogNode createNode(int key) {
        return this.createMyNode(key);
    }

    public void removeNode(int key) {
        this.mNodes.remove(key);
    }

    public FogNode getNode(int key) {
        return (FogNode)this.mNodes.get(key);
    }

    public FogPropValue getPropValue(int key, String name, FogPath thru) {
        Node node = (Node)this.getNode(key);
        if (node == null) {
            return null;
        }
        return node.getPropValue(name, thru);
    }

    public void addPropValueMap(int key, FpiPropValueMap map, FogPath thru) {
        Node node = (Node)this.getNode(key);
        if (node != null) {
            node.addPropValueMap(map, thru);
        }
    }

    public boolean setProp(FogComposite compo, String name, FogPropType type, Object value) {
        int key = compo.getKey();
        FogNode node = this.getNode(key);
        if (node == null) {
            node = this.createNode(key);
        }
        return node.setProp(name, type, value);
    }

    public void setProps(int key, FpiOrder.PropMap attr) {
        FogNode node = this.getNode(key);
        if (node == null) {
            node = this.createNode(key);
        }
        node.setProps(attr);
    }

    public int bindCost() {
        return this.mNodes.size();
    }
}

