/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.jce;

import com.stc.model.common.ObjectTypeDefinition;
import com.stc.model.common.Project;
import com.stc.model.common.ProjectElement;
import com.stc.nbcookies.SOAPCallableCookie;
import com.stc.otd.forest.OtdContext;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdTree;
import com.stc.otd.forest.provider.OtdCommonModule;
import com.stc.otd.origininfo.OriginInfoUtil;
import com.stc.repository.Repository;
import com.stc.repository.persistence.client.PersistableSupport;
import com.stc.util.NestedException;
import java.io.BufferedReader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XSDSOAPCallableCookie
implements SOAPCallableCookie {
    private ProjectElement mProjectElement;
    private String mSchemaContent = null;
    private boolean mChanged = false;
    private boolean mTSRetrieved = false;
    private static final String TARGETNAMESPACE_ATTR = "targetNamespace";
    private String mNameSpace = null;
    private Attr mTargetNSAttr = null;
    private Document mDoc = null;

    public XSDSOAPCallableCookie(ProjectElement projElem) {
        this.mProjectElement = projElem;
    }

    public String getNS() {
        if (!this.mTSRetrieved) {
            this.mNameSpace = this.getDefaultNS() == null ? null : this.getDefaultNS().getValue();
            this.mTSRetrieved = true;
        }
        return this.mNameSpace;
    }

    public void setNS(String ns) {
        this.mNameSpace = ns;
    }

    public String getXSDContent() {
        if (this.mSchemaContent == null) {
            this.mSchemaContent = OriginInfoUtil.getRawXSDFileContent((ProjectElement)this.mProjectElement);
        }
        return this.mSchemaContent;
    }

    public SOAPCallableCookie.XSDElement getXSDRootElement(String elementName, String defaultTargetNamespace) {
        SOAPCallableCookie.XSDElement xsdelement = null;
        try {
            if (this.mProjectElement == null) {
                return null;
            }
            if (!(this.mProjectElement instanceof ObjectTypeDefinition)) {
                throw new IllegalArgumentException("Parameter pe must be an instance of ObjectTypeDefinition or its subclass");
            }
            OtdMetaContainer metaContainer = this.lookupOTD((ObjectTypeDefinition)this.mProjectElement, Thread.currentThread().getContextClassLoader());
            ObjectTypeDefinition otd = (ObjectTypeDefinition)this.mProjectElement;
            OtdGrove grove = metaContainer.getOtdGrove();
            OtdTree tree = (OtdTree)grove.getTopTree(String.valueOf(otd.getTopNodeId()));
            if (tree == null) {
                throw new NestedException("Top tree by name(" + elementName + ") does not exist.");
            }
            xsdelement = new SOAPCallableCookie.XSDElement();
            if (tree == null) {
                return null;
            }
            xsdelement.setName(tree.getName());
            xsdelement.setURI(this.getDefaultNS() == null ? null : this.getDefaultNS().getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xsdelement;
    }

    private Attr getDefaultNS() {
        if (this.mTargetNSAttr == null) {
            try {
                this.mSchemaContent = OriginInfoUtil.getRawXSDFileContent((ProjectElement)this.mProjectElement);
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = null;
                docBuilder = docBuilderFactory.newDocumentBuilder();
                InputSource source = new InputSource(new BufferedReader(new StringReader(this.mSchemaContent)));
                this.mDoc = docBuilder.parse(source);
                Element element = this.mDoc.getDocumentElement();
                this.mTargetNSAttr = element.getAttributeNode(TARGETNAMESPACE_ATTR);
            }
            catch (Exception e) {
                throw new NestedException((Throwable)e);
            }
        }
        return this.mTargetNSAttr;
    }

    private OtdMetaContainer lookupOTD(ObjectTypeDefinition otdDef, ClassLoader clsld) {
        try {
            PersistableSupport ps = otdDef.getPersistableSupport();
            if (ps == null || ps.getRepository() == null) {
                throw new NestedException("Unable to get PersistableSupport or Repository.");
            }
            OtdContext context = OtdCommonModule.getOtdContext((Repository)ps.getRepository(), (ClassLoader)clsld);
            String path = this.getPathFromProject(otdDef.getParentProject(), otdDef.getName(), "/");
            return context.lookUpOtd(path);
        }
        catch (Exception e) {
            throw new NestedException("Failed to look up OTD.", (Throwable)e);
        }
    }

    private String getPathFromProject(Project project, String otdName, String delim) {
        try {
            StringBuffer path = new StringBuffer(this.getFullProjectPath(project, delim));
            path.append(delim + otdName);
            return path.toString();
        }
        catch (Exception e) {
            throw new NestedException("Failed to get path from project.", (Throwable)e);
        }
    }

    public String getFullProjectPath(String delim) {
        String fullPath = null;
        try {
            fullPath = this.getFullProjectPath(this.mProjectElement.getParentProject(), delim);
        }
        catch (Exception e) {
            throw new NestedException("Failed to get path from project.", (Throwable)e);
        }
        return fullPath;
    }

    private String getFullProjectPath(Project project, String delim) {
        try {
            StringBuffer path = new StringBuffer(project.getName());
            for (Project parent = project.getParentProject(); parent != null; parent = parent.getParentProject()) {
                path.insert(0, parent.getName() + delim);
            }
            return path.toString();
        }
        catch (Exception e) {
            throw new NestedException("Failed to get path from project.", (Throwable)e);
        }
    }

    public Object getProjectElement() {
        return this.mProjectElement;
    }

    public boolean isChanged() {
        return this.mChanged;
    }

    public void setChanged(boolean changed) {
        this.mChanged = changed;
    }
}

