/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.repository.impl;

import com.stc.model.common.OTDLocalizedInfo;
import com.stc.model.common.ObjectTypeDefinition;
import com.stc.model.common.ObjectTypeDefinition51;
import com.stc.otd.xsd.repository.impl.OTDLocalizedInfoImpl;
import com.stc.otd.xsd.repository.impl.XSDProjectElementImpl;
import com.stc.repository.RepositoryException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public abstract class ObjectTypeDefinitionImpl
extends XSDProjectElementImpl
implements ObjectTypeDefinition51 {
    private String mJavaType;
    static final String RCS_ID = "$Id: ObjectTypeDefinitionImpl.java,v 1.21 2006/07/25 22:21:53 libourel Exp $";
    public static final String ACCESS = "access";
    public static final String DOCUMENTATION = "documentation";
    public static final String ORIGIN = "origin";
    public static final String STRUCTURE = "structure";
    public static final String OBJECT_TYPE_DEFINITION_TYPE = "objectTypeDefinitionType";
    private static final String EXTERNAL_OTDS = "externalOTDs";
    public static final String SERIAL = "serial";
    public static final String TOP_NODE_ID = "topNodeId";
    public static final String OTD_WIZARD = "otdWizard";
    public static final String OTD_LOCALIZED_INFOS = "otdLocalizedInfos";
    public static final String OTD_META_CONTAINER = "otdMetaContainer";
    public static final String OTD_META_CONTAINER_BLOB = "otdMetaContainerBLOB";
    public final String JAVANAME = "javaName";
    public final String HEAD = "head";
    public final String LEAD = "lead";

    public ObjectTypeDefinitionImpl() {
    }

    public ObjectTypeDefinitionImpl(String name) throws RepositoryException {
        super(name);
    }

    public void setAccess(String value) throws RepositoryException {
        this.setPartOfProperty(ACCESS, value);
    }

    public String getAccess() throws RepositoryException {
        return (String)this.getPartOfProperty(ACCESS);
    }

    public Collection getAllExternalObjectTypeDefinitions() throws RepositoryException {
        HashMap map = new HashMap();
        this.collectExternals(map);
        return Collections.unmodifiableCollection(map.values());
    }

    public void setDocumentation(String value) throws RepositoryException {
        this.setPartOfProperty(DOCUMENTATION, value);
    }

    public String getDocumentation() throws RepositoryException {
        return (String)this.getPartOfProperty(DOCUMENTATION);
    }

    public boolean isExternal(ObjectTypeDefinition entry) throws RepositoryException {
        boolean result = false;
        HashMap map = new HashMap();
        result = this.checkExternal(entry, map);
        return result;
    }

    public ObjectTypeDefinition getExternalObjectTypeDefinition(String name) throws RepositoryException {
        return (ObjectTypeDefinition)this.getReferenceValue(EXTERNAL_OTDS, name);
    }

    public Collection getExternalObjectTypeDefinitions() throws RepositoryException {
        return this.getReferenceCollection(EXTERNAL_OTDS);
    }

    public OTDLocalizedInfo getOTDLocalizedInfo(String language) throws RepositoryException {
        Collection infos = null;
        Iterator infoIter = null;
        OTDLocalizedInfo info = null;
        OTDLocalizedInfo ret = null;
        infos = this.getOTDLocalizedInfos();
        if (infos != null) {
            infoIter = infos.iterator();
            while (infoIter.hasNext()) {
                info = (OTDLocalizedInfo)infoIter.next();
                if (!info.getLanguage().equals(language)) continue;
                ret = info;
                break;
            }
        }
        return ret;
    }

    public Collection getOTDLocalizedInfos() throws RepositoryException {
        return this.getReferenceCollection(OTD_LOCALIZED_INFOS);
    }

    public void setOrigin(String value) throws RepositoryException {
        this.setPartOfProperty(ORIGIN, value);
    }

    public String getOrigin() throws RepositoryException {
        return (String)this.getPartOfProperty(ORIGIN);
    }

    public void setSerial(String value) throws RepositoryException {
        this.setPartOfProperty(SERIAL, value);
    }

    public String getSerial() throws RepositoryException {
        return (String)this.getPartOfProperty(SERIAL);
    }

    public void setStructure(String value) throws RepositoryException {
        this.setPartOfProperty(STRUCTURE, value);
    }

    public String getStructure() throws RepositoryException {
        return (String)this.getPartOfProperty(STRUCTURE);
    }

    public void setTopNodeId(int value) throws RepositoryException {
        this.setPartOfProperty(TOP_NODE_ID, new Integer(value));
    }

    public int getTopNodeId() throws RepositoryException {
        Object obj = this.getPartOfProperty(TOP_NODE_ID);
        return obj == null ? 0 : (Integer)obj;
    }

    public void addExternalObjectTypeDefinition(ObjectTypeDefinition entry) throws RepositoryException {
        if (this.getExternalObjectTypeDefinition(entry.getName()) != null) {
            throw new IllegalArgumentException("ExternalObjectTypeDefinition with same name (" + entry.getName() + ") is already exists.");
        }
        this.addReferenceValue(EXTERNAL_OTDS, entry);
    }

    public boolean checkExternal(ObjectTypeDefinition entry, HashMap map) throws RepositoryException {
        boolean result = false;
        Collection externals = null;
        Iterator externalIter = null;
        ObjectTypeDefinitionImpl external = null;
        String externalOID = null;
        String entryOID = null;
        externals = this.getExternalObjectTypeDefinitions();
        if (externals != null) {
            entryOID = entry.getOID();
            externalIter = externals.iterator();
            while (externalIter.hasNext()) {
                external = (ObjectTypeDefinitionImpl)externalIter.next();
                externalOID = external.getOID();
                if (externalOID.equals(entryOID)) {
                    result = true;
                    break;
                }
                if (map.get(externalOID) != null) continue;
                map.put(externalOID, external);
                result = external.checkExternal(entry, map);
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    public void collectExternals(HashMap map) throws RepositoryException {
        Collection externals = null;
        Iterator externalIter = null;
        ObjectTypeDefinitionImpl external = null;
        String externalOID = null;
        externals = this.getExternalObjectTypeDefinitions();
        if (externals != null) {
            externalIter = externals.iterator();
            while (externalIter.hasNext()) {
                external = (ObjectTypeDefinitionImpl)externalIter.next();
                externalOID = external.getOID();
                if (map.get(externalOID) != null) continue;
                map.put(externalOID, external);
                external.collectExternals(map);
            }
        }
    }

    public OTDLocalizedInfo createOTDLocalizedInfo(String language) throws RepositoryException {
        if (null != this.getOTDLocalizedInfo(language)) {
            throw new IllegalArgumentException("OTDLocalizedInfo with that name already exists.");
        }
        OTDLocalizedInfoImpl ret = new OTDLocalizedInfoImpl((ObjectTypeDefinition)this, language);
        return ret;
    }

    public OTDLocalizedInfo deleteOTDLocalizedInfo(OTDLocalizedInfo value) throws RepositoryException {
        return (OTDLocalizedInfo)this.deleteReferenceValue(OTD_LOCALIZED_INFOS, value);
    }

    public ObjectTypeDefinition removeExternalObjectTypeDefinition(ObjectTypeDefinition entry) throws RepositoryException {
        return (ObjectTypeDefinition)this.removeReferenceValue(EXTERNAL_OTDS, entry);
    }

    void addOTDLocalizedInfo(OTDLocalizedInfo entry) throws RepositoryException {
        if (this.getOTDLocalizedInfo(entry.getLanguage()) != null) {
            throw new IllegalArgumentException("OTDLocalizedInfo with same language (" + entry.getLanguage() + ") is already exists.");
        }
        this.addReferenceValue(OTD_LOCALIZED_INFOS, entry);
    }

    OTDLocalizedInfo removeOTDLocalizedInfo(OTDLocalizedInfo entry) throws RepositoryException {
        return (OTDLocalizedInfo)this.removeReferenceValue(OTD_LOCALIZED_INFOS, entry);
    }

    public boolean isVersionable() {
        return true;
    }

    public boolean isMessageable() throws RepositoryException {
        return true;
    }

    public String getOtdMetaContainer() throws RepositoryException {
        try {
            String ret = null;
            String orgContent = (String)this.getPartOfProperty(OTD_META_CONTAINER);
            ret = orgContent == null ? this.getPersistableSupport().getBlobPropertyAsString(OTD_META_CONTAINER_BLOB) : orgContent;
            return ret;
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void setOtdMetaContainer(String otdMetaContainer) throws RepositoryException {
        this.getPersistableSupport().setBlobPropertyUsingString(OTD_META_CONTAINER_BLOB, otdMetaContainer);
    }

    public String getHead() throws RepositoryException {
        return (String)this.getPartOfProperty("head");
    }

    public void setHead(String header) throws RepositoryException {
        this.setPartOfProperty("head", header);
    }

    public void setLead(String refOtd) throws RepositoryException {
        this.setPartOfProperty("lead", refOtd);
    }

    public String getLead() throws RepositoryException {
        return (String)this.getPartOfProperty("lead");
    }
}

