/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.repository.impl;

import com.stc.bpms.common.model.wsdl.WSDLDocument;
import com.stc.bpms.common.repository.WSDLRepositoryObject;
import com.stc.model.common.OTDLocalizedInfo;
import com.stc.model.common.ObjectTypeDefinition;
import com.stc.otd.forest.OtdContext;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdNameValueType;
import com.stc.otd.forest.OtdNameValueTypeMap;
import com.stc.otd.forest.OtdOrigin;
import com.stc.otd.forest.provider.OtdContextFactory;
import com.stc.otd.xsd.repository.XSDManager;
import com.stc.otd.xsd.repository.XSDObjectTypeDefinitionData;
import com.stc.otd.xsd.repository.impl.XSDObjectImpl;
import com.stc.otd.xsd.repository.impl.XSDObjectTypeDefinitionDataImpl;
import com.stc.otd.xsd.repository.impl.XSDObjectTypeDefinitionImpl;
import com.stc.repository.Repository;
import com.stc.repository.RepositoryException;
import com.stc.repository.packager.MigrationController;
import com.stc.repository.packager.MigrationHandler;
import com.stc.repository.persistence.client.MarshalableFactory;
import com.stc.repository.persistence.client.Persistable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class XSDManagerImpl
extends XSDObjectImpl
implements XSDManager,
MigrationHandler {
    static final String RCS_ID = "$Id: XSDManagerImpl.java,v 1.8 2006/08/30 23:42:29 ed Exp $";
    private static final String PROJECT_ELEMENTS = "projectElements";
    static /* synthetic */ Class class$com$stc$otd$xsd$repository$impl$XSDManagerImpl;

    public XSDManagerImpl() {
    }

    public XSDManagerImpl(Repository parent) throws RepositoryException {
        this.setOID("XSDManager/SBYNXSD110");
        this.setName("XSD Manager API");
        this.setOwnerOID(parent.getOID());
    }

    public MarshalableFactory.ClassNameMapper getClassNameMapper() {
        return ClassNameMapper.singleton;
    }

    public String getSystemID() {
        return (String)this.getReferenceID();
    }

    public void initialize(Repository rep) throws RepositoryException {
    }

    public void migrate(Persistable objectToMigrate, MigrationController controller) throws RepositoryException {
        if (objectToMigrate instanceof XSDObjectTypeDefinitionImpl) {
            this.migrateXSDObjectTypeDefinition((XSDObjectTypeDefinitionImpl)objectToMigrate, controller);
        }
    }

    private void migrateXSDObjectTypeDefinition(XSDObjectTypeDefinitionImpl xsdOtd, MigrationController controller) throws RepositoryException {
        if (xsdOtd.getParentProject() != null && xsdOtd.getParentProject().getProjectElement(xsdOtd.getName()) != xsdOtd) {
            int index = 1;
            String newName = xsdOtd.getName() + "_salvaged";
            while (xsdOtd.getParentProject().getProjectElement(newName + index) != null) {
                ++index;
            }
            xsdOtd.setName(newName + index);
            xsdOtd.getParentProject().getPersistableSupport().addReferenceValue(PROJECT_ELEMENTS, (Object)xsdOtd);
        }
        Object oldWSDLList = null;
        Map referenceMap = (Map)xsdOtd.getRelationshipMap().get("reference");
        WSDLRepositoryObject oldWSDL = null;
        XSDObjectTypeDefinitionData oldOTDData = null;
        if (referenceMap != null) {
            oldWSDL = (WSDLRepositoryObject)referenceMap.remove("WebServicesDefinitions");
            oldOTDData = (XSDObjectTypeDefinitionDataImpl)referenceMap.remove("delegate");
        }
        xsdOtd.setLead("SeeBeyond/eGate/OTDLead/XSD_0");
        if (oldOTDData != null) {
            Collection localList;
            Collection extOtdList;
            xsdOtd.setAccess(oldOTDData.getAccess());
            xsdOtd.setOrigin(oldOTDData.getOrigin());
            xsdOtd.setStructure(oldOTDData.getStructure());
            xsdOtd.setDocumentation(oldOTDData.getDocumentation());
            if (oldOTDData.getOtdMetaContainer() != null) {
                xsdOtd.setOtdMetaContainer(oldOTDData.getOtdMetaContainer());
            }
            if ((extOtdList = oldOTDData.getExternalObjectTypeDefinitions()) != null) {
                Iterator iter = extOtdList.iterator();
                while (iter.hasNext()) {
                    xsdOtd.addExternalObjectTypeDefinition((ObjectTypeDefinition)iter.next());
                }
            }
            if ((localList = oldOTDData.getOTDLocalizedInfos()) != null) {
                Iterator iter = localList.iterator();
                while (iter.hasNext()) {
                    xsdOtd.addOTDLocalizedInfo((OTDLocalizedInfo)iter.next());
                }
            }
        }
        this.markAs50XOTDMetaContainer(xsdOtd);
        if (oldWSDL != null) {
            WSDLDocument wsdlDoc = oldWSDL.getConcreteModel();
            StringWriter writer = new StringWriter();
            wsdlDoc.serialize((Writer)writer);
            try {
                xsdOtd.setWSDLString(((Object)writer).toString());
                ((Writer)writer).close();
            }
            catch (IOException ie) {
                throw new RepositoryException("can't close writer", (Throwable)ie);
            }
        }
        if (oldWSDL instanceof Persistable) {
            xsdOtd.setWSDLBuilderVersion("5.0.x");
            controller.removeFromImportList((Persistable)oldWSDL);
        }
        if (oldOTDData instanceof Persistable) {
            controller.removeFromImportList((Persistable)oldOTDData);
        }
    }

    private void markAs50XOTDMetaContainer(XSDObjectTypeDefinitionImpl xsdOtd) {
        try {
            if (xsdOtd.getOtdMetaContainer() != null) {
                OtdNameValueTypeMap otdNVMap;
                String otdMCStr = xsdOtd.getOtdMetaContainer();
                File tmpFile = File.createTempFile("OTDMC", ".otd");
                FileWriter fileWr = new FileWriter(tmpFile);
                fileWr.write(otdMCStr);
                fileWr.flush();
                fileWr.close();
                OtdContext otdCtxt = OtdContextFactory.getOtdNativeContext((File)tmpFile.getParentFile());
                String otdCtxtPath = tmpFile.getName().substring(0, tmpFile.getName().length() - ".otd".length());
                OtdMetaContainer otdMC = otdCtxt.lookUpOtd(otdCtxtPath);
                OtdOrigin otdOrig = otdMC.getOtdOrigin();
                if (otdOrig != null && (otdNVMap = otdOrig.getOtdSeedInfo(otdMC.getOtdGrove().getId())) != null && otdNVMap.values() != null && otdNVMap.get("isRelease50X") == null) {
                    OtdNameValueType otdNVT = otdOrig.createOtdNameValueType();
                    otdNVT.setName("isRelease50X");
                    otdNVT.setValue((Object)"true");
                    otdNVT.setType(6);
                    otdNVMap.put(otdNVT);
                    otdCtxt.bindOtd(otdMC, otdCtxtPath);
                    FileReader fileRdr = new FileReader(tmpFile);
                    StringBuffer strBuf = new StringBuffer();
                    char[] cbuf = new char[1024];
                    int rc = -1;
                    while ((rc = fileRdr.read(cbuf)) != -1) {
                        strBuf.append(cbuf, 0, rc);
                    }
                    fileRdr.close();
                    if (strBuf.length() > 0) {
                        xsdOtd.setOtdMetaContainer(strBuf.toString());
                    }
                }
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ClassNameMapper
    implements MarshalableFactory.ClassNameMapper {
        static final String RCS_ID = "$Id: XSDManagerImpl.java,v 1.8 2006/08/30 23:42:29 ed Exp $";
        static final String PREFIX = "com.stc.otd.xsd.repository.impl.";
        static final String SUFFIX = "Impl";
        private static ClassNameMapper singleton = new ClassNameMapper();

        public static ClassNameMapper getInstance() {
            return singleton;
        }

        public String getAlias(Class clazz) {
            if (null == clazz) {
                return null;
            }
            if ((class$com$stc$otd$xsd$repository$impl$XSDManagerImpl == null ? (class$com$stc$otd$xsd$repository$impl$XSDManagerImpl = XSDManagerImpl.class$("com.stc.otd.xsd.repository.impl.XSDManagerImpl")) : class$com$stc$otd$xsd$repository$impl$XSDManagerImpl) == clazz) {
                return clazz.getName();
            }
            String name = clazz.getName();
            if (!name.startsWith(PREFIX)) {
                return null;
            }
            name = name.substring(PREFIX.length());
            name = name.substring(0, name.length() - SUFFIX.length());
            return "XSDManager/" + name;
        }

        public String getClassName(String alias) {
            if (null == alias) {
                return null;
            }
            if (!alias.startsWith("XSDManager/")) {
                return null;
            }
            return PREFIX + alias.substring(alias.indexOf(47) + 1) + SUFFIX;
        }
    }
}

