/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.repository.impl;

import com.stc.otd.xsd.repository.impl.XSDManagerImpl;
import com.stc.repository.CUDTracker;
import com.stc.repository.IDGen;
import com.stc.repository.RepositoryException;
import com.stc.repository.RepositoryFactory;
import com.stc.repository.RepositoryObject;
import com.stc.repository.persistence.client.MarshalableSupport;
import com.stc.repository.persistence.client.Persistable;
import com.stc.repository.persistence.client.PersistableSupport;
import com.stc.repository.persistence.client.Resolver;
import com.stc.repository.versioncontrol.VersionInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public abstract class XSDObjectImpl
implements RepositoryObject {
    static final String RCS_ID = "$Id: ObjectImpl.serf,v 1.5 2005/07/22 20:31:32 cmbuild Exp $";
    private CUDTracker tracker = null;
    protected PersistableSupport persistable = RepositoryFactory.createPersistableSupport((Object)this);

    public XSDObjectImpl() {
    }

    public XSDObjectImpl(String id, String name) throws RepositoryException {
        this();
        if (null != name) {
            this.setName(name);
        }
        if (null == id || id.trim().length() == 0) {
            this.initializeOID();
        } else {
            this.setOID(id);
        }
    }

    public XSDObjectImpl(String name) throws RepositoryException {
        this((String)null, name);
    }

    public XSDObjectImpl(RepositoryObject owner, String id, String name) throws RepositoryException {
        this(id, name);
        this.setCUDTracker(owner.getCUDTracker());
        this.setOwnerOID(owner.getOID());
        this.tracker.objectCreated((RepositoryObject)this);
    }

    public XSDObjectImpl(RepositoryObject owner, String name) throws RepositoryException {
        this(owner, null, name);
    }

    protected void initializeOID() throws RepositoryException {
        this.setOID(this.getClassNameAlias() + '/' + IDGen.getNUID());
    }

    public Object getReferenceID() {
        return this.persistable.getReferenceID();
    }

    public void setReferenceID(Object value) throws RepositoryException {
        this.persistable.setReferenceID(value);
    }

    public String getClassNameAlias() {
        return XSDManagerImpl.ClassNameMapper.getInstance().getAlias(this.getClass());
    }

    public String getClassNameAlias(Class aClazz) {
        return XSDManagerImpl.ClassNameMapper.getInstance().getAlias(aClazz);
    }

    public Map getRelationshipMap() {
        return this.persistable.getRelationshipMap();
    }

    public Map getPropertyMap(String relation, boolean create) {
        return this.persistable.getPropertyMap(relation, create);
    }

    public void setPropertyMap(String relation, Map map) {
        this.persistable.setPropertyMap(relation, map);
    }

    public void onUnmarshalStarting() {
        this.persistable.onUnmarshalStarting();
    }

    public void onUnmarshalFinished() {
        this.persistable.onUnmarshalFinished();
    }

    public boolean isLocked() throws RepositoryException {
        if (this.getCUDTracker() != null) {
            return this.getCUDTracker().isLocked((Persistable)this);
        }
        return true;
    }

    public String getOID() throws RepositoryException {
        return this.persistable.getOID();
    }

    public void setOID(String value) throws RepositoryException {
        this.persistable.setOID(value);
    }

    public String getName() throws RepositoryException {
        return this.persistable.getName();
    }

    public void setName(String value) throws RepositoryException {
        this.persistable.setName(value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    public String getDescription() throws RepositoryException {
        return this.persistable.getDescription();
    }

    public void setDescription(String value) throws RepositoryException {
        this.persistable.setDescription(value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    public String getOwnerOID() throws RepositoryException {
        return this.persistable.getOwnerOID();
    }

    public void setOwnerOID(String value) throws RepositoryException {
        this.persistable.setOwnerOID(value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    public String getACLInfo() throws RepositoryException {
        return this.persistable.getACLInfo();
    }

    public void setACLInfo(String value) throws RepositoryException {
        this.persistable.setACLInfo(value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    public void setResolver(Resolver value) throws RepositoryException {
        this.persistable.setResolver(value);
    }

    public void setUnresolved() throws RepositoryException {
        this.persistable.setUnresolved();
    }

    public void resolve(boolean force) throws RepositoryException {
        this.persistable.resolve(force);
    }

    public VersionInfo getVersionInfo() throws RepositoryException {
        return this.persistable.getVersionInfo();
    }

    public void setVersionInfo(VersionInfo value) throws RepositoryException {
        this.persistable.setVersionInfo(value);
    }

    public void setHeaderResolved(boolean value) throws RepositoryException {
        this.persistable.setHeaderResolved(value);
    }

    public boolean isHeaderResolved() throws RepositoryException {
        return this.persistable.isHeaderResolved();
    }

    public void setCreatedBy(String userName) throws RepositoryException {
        this.persistable.setCreatedBy(userName);
    }

    public String getCreatedBy() throws RepositoryException {
        return this.persistable.getCreatedBy();
    }

    public void setLastUpdatedBy(String userName) throws RepositoryException {
        this.persistable.setLastUpdatedBy(userName);
    }

    public String getLastUpdatedBy() throws RepositoryException {
        return this.persistable.getLastUpdatedBy();
    }

    public void setLastUpdatedDate(Date date) throws RepositoryException {
        this.persistable.setLastUpdatedDate(date);
    }

    public Date getLastUpdatedDate() throws RepositoryException {
        return this.persistable.getLastUpdatedDate();
    }

    public void setCreationDate(Date date) throws RepositoryException {
        this.persistable.setCreationDate(date);
    }

    public Date getCreationDate() throws RepositoryException {
        return this.persistable.getCreationDate();
    }

    public boolean isVersionable() throws RepositoryException {
        return this.persistable.isVersionable();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.persistable.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.persistable.addPropertyChangeListener(name, listener);
    }

    public void addPropertyChangeListeners(Collection value) {
        this.persistable.addPropertyChangeListeners(value);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.persistable.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.persistable.removePropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListeners(Collection value) {
        this.persistable.removePropertyChangeListeners(value);
    }

    public CUDTracker getCUDTracker() {
        return this.tracker;
    }

    public void setCUDTracker(CUDTracker tracker) {
        this.tracker = tracker;
    }

    public void onDelete() throws RepositoryException {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.persistable.propertyChange(evt);
        if (null != this.getCUDTracker()) {
            try {
                this.getCUDTracker().objectUpdated((RepositoryObject)this);
            }
            catch (RepositoryException ex) {
                throw new RuntimeException("Unable to add to updated list: " + ex.getMessage());
            }
        }
    }

    protected Object getPartOfProperty(String name) throws RepositoryException {
        return this.persistable.getPartOfProperty(name);
    }

    protected void setPartOfProperty(String name, Object value) throws RepositoryException {
        this.persistable.setPartOfProperty(name, value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    protected Collection getPartOfCollection(String name) throws RepositoryException {
        return this.persistable.getPartOfCollection(name);
    }

    protected Object getPartOfValue(String name, String value) throws RepositoryException {
        return this.persistable.getPartOfValue(name, value);
    }

    protected void addPartOfValue(String name, Object value) throws RepositoryException {
        this.persistable.addPartOfValue(name, value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    protected Object removePartOfValue(String name, String value) throws RepositoryException {
        Object ret = this.persistable.removePartOfValue(name, value);
        if (null != ret && this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
        return ret;
    }

    protected Object removePartOfValue(String name, Object value) throws RepositoryException {
        Object ret = this.persistable.removePartOfValue(name, value);
        if (null != ret && this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
        return ret;
    }

    protected Object getReferenceProperty(String name) throws RepositoryException {
        Object ret = this.persistable.getReferenceProperty(name);
        if (null != ret && ret instanceof RepositoryObject) {
            ((RepositoryObject)ret).setCUDTracker(this.getCUDTracker());
        }
        return ret;
    }

    protected void setReferenceProperty(String name, Object value) throws RepositoryException {
        this.persistable.setReferenceProperty(name, value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    protected Collection getReferenceCollection(String name) throws RepositoryException {
        CUDTracker aTracker = this.getCUDTracker();
        Collection coll = this.persistable.getReferenceCollection(name);
        Iterator ii = coll.iterator();
        while (ii.hasNext()) {
            RepositoryObject obj = (RepositoryObject)ii.next();
            if (obj == null) continue;
            obj.setCUDTracker(aTracker);
        }
        return coll;
    }

    protected Object getReferenceValue(String name, String value) throws RepositoryException {
        Object ret = this.persistable.getReferenceValue(name, value);
        if (null != ret && ret instanceof RepositoryObject) {
            ((RepositoryObject)ret).setCUDTracker(this.getCUDTracker());
        }
        return ret;
    }

    protected void addReferenceValue(String name, Object value) throws RepositoryException {
        this.persistable.addReferenceValue(name, value);
        if (this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
    }

    protected Object removeReferenceValue(String name, String value) throws RepositoryException {
        Object ret = this.persistable.removeReferenceValue(name, value);
        if (null != ret && this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
        return ret;
    }

    protected Object removeReferenceValue(String name, Object value) throws RepositoryException {
        Object ret = this.persistable.removeReferenceValue(name, value);
        if (null != ret && this.getCUDTracker() != null) {
            this.getCUDTracker().objectUpdated((RepositoryObject)this);
        }
        return ret;
    }

    protected Object deleteReferenceValue(String name, String value) throws RepositoryException {
        RepositoryObject ret = (RepositoryObject)this.removeReferenceValue(name, value);
        if (ret != null && this.getCUDTracker() != null) {
            this.getCUDTracker().objectDeleted(ret);
        }
        return ret;
    }

    protected Object deleteReferenceValue(String name, Object value) throws RepositoryException {
        RepositoryObject ret = (RepositoryObject)this.removeReferenceValue(name, value);
        if (ret != null && this.getCUDTracker() != null) {
            this.getCUDTracker().objectDeleted(ret);
        }
        return ret;
    }

    protected void deleteReferenceCollection(String name) throws RepositoryException {
        try {
            Iterator ii = this.getReferenceCollection(name).iterator();
            while (ii.hasNext()) {
                RepositoryObject obj = (RepositoryObject)ii.next();
                this.deleteReferenceValue(name, obj);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RepositoryObject)) {
            return false;
        }
        RepositoryObject that = (RepositoryObject)obj;
        if (null == this.getReferenceID() || null == that.getReferenceID()) {
            try {
                if (null != this.getName()) {
                    return this.getName().equals(that.getName());
                }
            }
            catch (RepositoryException ex) {
                ex.printStackTrace();
            }
            return false;
        }
        return this.getReferenceID().equals(that.getReferenceID());
    }

    public String toString() {
        return this.persistable.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public PersistableSupport getPersistableSupport() throws RepositoryException {
        return this.persistable;
    }

    public MarshalableSupport getMarshalableSupport() throws RepositoryException {
        return this.persistable.getMarshalableSupport();
    }
}

