/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.repository.impl;

import com.stc.bpms.common.ServiceFailedException;
import com.stc.bpms.common.integration.mapper.MNodeFactory;
import com.stc.bpms.common.integration.mapper.MNodeFactoryRegistry;
import com.stc.bpms.common.integration.model.wsdlproducer.WSDLDocumentImm;
import com.stc.bpms.common.integration.model.wsdlproducer.WSDLProducer;
import com.stc.bpms.common.model.wsdl.WSDLDocument;
import com.stc.bpms.common.repository.EInsightManager;
import com.stc.model.common.ObjectTypeDefinition;
import com.stc.model.common.ProjectElement;
import com.stc.otd.bpi.WSDLBuilder;
import com.stc.otd.bpi.WSDLBuilderFactory;
import com.stc.otd.jinfo.JavaInfo;
import com.stc.otd.jinfo.JavaInfoException;
import com.stc.otd.jinfo.provider.JavaInfoFactory;
import com.stc.otd.xsd.bpi.OTDMNodeFactoryImpl;
import com.stc.otd.xsd.repository.IXSDCommitStatusChangeListener;
import com.stc.otd.xsd.repository.XSDObjectTypeDefinition;
import com.stc.otd.xsd.repository.impl.ObjectTypeDefinitionImpl;
import com.stc.otd.xsd.repository.impl.XSDObjectTypeDefinitionDataImpl;
import com.stc.repository.CUDTracker;
import com.stc.repository.Repository;
import com.stc.repository.RepositoryException;
import com.stc.repository.RepositoryObject;
import com.stc.repository.persistence.client.Persistable;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Logger;

public class XSDObjectTypeDefinitionImpl
extends ObjectTypeDefinitionImpl
implements XSDObjectTypeDefinition {
    static final String RCS_ID = "$Id: XSDObjectTypeDefinitionImpl.java,v 1.23 2006/07/25 22:22:04 libourel Exp $";
    ResourceBundle rb = ResourceBundle.getBundle("com.stc.otd.xsd.repository.impl.Bundle");
    public static final String OTD_WSDL_BLOB = "otdWSDLBLOB";
    public static final String WEB_SERVICES_DEFINITIONS = "WebServicesDefinitions";
    public static final String TARGET_NAMESPACE = "TargetNameSpace";
    public static final String SOURCE_XML_SCHEMA = "SourceXMLSchema";
    public static final String DELEGATE = "delegate";
    public static final String WSDL_BUILDER = "WSDLBuilderVersion";
    public static final String RELAUNCH_WIZARD_NAME = "RelaunchWizardName";
    private Logger mLogger = Logger.getLogger((String)this.getClass().getName());
    private XSDObjectTypeDefinitionDataImpl mDelegateObject = null;
    private static boolean mIsMNodeFactoryRegistered = false;
    private WSDLDocumentImm mWSDLDocumentImm = null;
    protected List mCommitStatusChangeListenerList = new Vector();

    public XSDObjectTypeDefinitionImpl() {
        this.registerMNodeFactory();
    }

    public XSDObjectTypeDefinitionImpl(String name) throws RepositoryException {
        super(name);
        this.registerMNodeFactory();
    }

    public String getProjectElementType() throws RepositoryException {
        return "otd.XSDObjectTypeDefinition";
    }

    void registerMNodeFactory() {
        if (mIsMNodeFactoryRegistered) {
            return;
        }
        String name = this.getClass().getName() + "-bpms-MNodeFactory";
        MNodeFactoryRegistry.put((String)name, (MNodeFactory)new OTDMNodeFactoryImpl());
        mIsMNodeFactoryRegistered = true;
    }

    public String getIconURL() throws RepositoryException {
        return "com/stc/otd/dtd/repository/impl/OTD.png";
    }

    public RepositoryObject getBusinessProcessDefinitions() throws RepositoryException {
        return (RepositoryObject)this.getReferenceProperty(WEB_SERVICES_DEFINITIONS);
    }

    public void setBusinessProcessDefinitions(RepositoryObject repObj) throws RepositoryException {
        this.setReferenceProperty(WEB_SERVICES_DEFINITIONS, repObj);
    }

    public String getTargetNameSpace() throws RepositoryException {
        return (String)this.getPartOfProperty(TARGET_NAMESPACE);
    }

    public void setTargetNameSpace(String namespace) throws RepositoryException {
        this.setPartOfProperty(TARGET_NAMESPACE, namespace);
    }

    public RepositoryObject getSourceRepositoryObject() throws RepositoryException {
        return (RepositoryObject)this.getReferenceProperty(SOURCE_XML_SCHEMA);
    }

    public void setSourceRepositoryObject(RepositoryObject repObj) throws RepositoryException {
        this.setReferenceProperty(SOURCE_XML_SCHEMA, repObj);
    }

    public void addCommitStatusChangeListener(IXSDCommitStatusChangeListener dtdCommitStatusChangeListener) {
        this.mCommitStatusChangeListenerList.add(dtdCommitStatusChangeListener);
    }

    public void fireCommitStatusChanged() {
        IXSDCommitStatusChangeListener listener = null;
        Iterator iter = this.mCommitStatusChangeListenerList.iterator();
        while (iter.hasNext()) {
            listener = (IXSDCommitStatusChangeListener)iter.next();
            listener.editModeChange();
        }
    }

    public boolean hasDefaultPartner() {
        return true;
    }

    public XSDObjectTypeDefinitionDataImpl getDelegate() throws RepositoryException {
        if (this.mDelegateObject != null) {
            return this.mDelegateObject;
        }
        this.mDelegateObject = (XSDObjectTypeDefinitionDataImpl)this.getReferenceProperty(DELEGATE);
        if (this.mDelegateObject == null) {
            this.mDelegateObject = new XSDObjectTypeDefinitionDataImpl();
            this.mDelegateObject.initializeOID();
            this.mDelegateObject.setOwnerOID(this.getOID());
            if (this.mDelegateObject.getCUDTracker() == null) {
                this.mDelegateObject.setCUDTracker(this.getCUDTracker());
            }
            if (this.mDelegateObject.getCUDTracker() != null) {
                this.mDelegateObject.getCUDTracker().objectCreated((RepositoryObject)this.mDelegateObject);
            }
            this.setReferenceProperty(DELEGATE, this.mDelegateObject);
            CUDTracker cudTracker = this.mDelegateObject.getCUDTracker();
            if (null != this.mDelegateObject.getCUDTracker()) {
                cudTracker.getVersionManager().saveToWorkspace((Persistable)this.mDelegateObject);
                cudTracker.getVersionManager().checkIn((Persistable)this.mDelegateObject, this.rb.getString("STR_ADD_XSDOTD"));
            }
        }
        return this.mDelegateObject;
    }

    public void setJavaName(String value) throws RepositoryException {
        this.setPartOfProperty("javaName", value);
    }

    public String getJavaName() throws RepositoryException {
        String javaType = (String)this.getPartOfProperty("javaName");
        if (javaType == null) {
            JavaInfo ji = JavaInfoFactory.getRepositoryJavaInfo();
            try {
                javaType = ji.getJavaType((ProjectElement)this, Thread.currentThread().getContextClassLoader());
            }
            catch (JavaInfoException je) {
                throw new RepositoryException("can't get JavaType of Otd: [" + this.getName() + "]");
            }
        }
        return javaType;
    }

    public WSDLDocumentImm getWSDLDocumentImm() throws ServiceFailedException {
        try {
            if (this.mWSDLDocumentImm == null) {
                WSDLDocument wsdlDoc;
                Repository rep = (Repository)this.getCUDTracker();
                EInsightManager eInsightManager = (EInsightManager)rep.getAPI("EInsightManager/SBYN200");
                if (this.getWSDLString() == null) {
                    String wsdlNS = this.getJavaName() == null ? null : this.getJavaName().replace('.', ':');
                    WSDLBuilder builder = WSDLBuilderFactory.getWSDLBuilder((ObjectTypeDefinition)this, (String)this.getWSDLBuilderVersion());
                    wsdlDoc = "5.0.x".equals(this.getWSDLBuilderVersion()) ? builder.createWSDL() : builder.createWSDL(wsdlNS, null, null, null);
                } else {
                    wsdlDoc = eInsightManager.createWSDLDocument();
                    wsdlDoc.load((Reader)new StringReader(this.getWSDLString()));
                    WSDLBuilder builder = WSDLBuilderFactory.getWSDLBuilder((ObjectTypeDefinition)this, (String)this.getWSDLBuilderVersion());
                    builder.migrate(wsdlDoc, "5.1.0");
                    builder.setDynamicComponents(wsdlDoc);
                }
                wsdlDoc.setWSDLProducer((WSDLProducer)this);
                this.mWSDLDocumentImm = eInsightManager.createImmutableDocument(wsdlDoc);
            }
        }
        catch (Exception e) {
            throw new ServiceFailedException("Can't generate WSDL document: ", (Throwable)e);
        }
        return this.mWSDLDocumentImm;
    }

    public void setWSDLDocumentImm(WSDLDocumentImm wsdlDocImm) {
        this.mWSDLDocumentImm = wsdlDocImm;
    }

    public String getWSDLString() throws RepositoryException {
        return this.getPersistableSupport().getBlobPropertyAsString(OTD_WSDL_BLOB);
    }

    public void setWSDLString(String wsdl) throws RepositoryException {
        this.getPersistableSupport().setBlobPropertyUsingString(OTD_WSDL_BLOB, wsdl);
    }

    public void refreshWSDL() {
        this.mWSDLDocumentImm = null;
    }

    public String getWSDLBuilderVersion() throws RepositoryException {
        String ver = (String)this.getPartOfProperty(WSDL_BUILDER);
        return ver == null ? "unDefine" : ver;
    }

    public void setWSDLBuilderVersion(String version) throws RepositoryException {
        this.setPartOfProperty(WSDL_BUILDER, version);
    }

    public String getRelaunchWizardName() throws RepositoryException {
        return (String)this.getPartOfProperty(RELAUNCH_WIZARD_NAME);
    }

    public void setRelaunchWizardName(String wizardName) throws RepositoryException {
        this.setPartOfProperty(RELAUNCH_WIZARD_NAME, wizardName);
    }
}

