/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.repository.impl;

import com.stc.model.common.Project;
import com.stc.model.common.ProjectElement;
import com.stc.otd.xsd.repository.impl.XSDObjectImpl;
import com.stc.repository.RepositoryException;
import com.stc.repository.RepositoryObject;

public abstract class XSDProjectElementImpl
extends XSDObjectImpl
implements ProjectElement {
    static final String RCS_ID = "$Id: XSDProjectElementImpl.java,v 1.5 2005/07/22 17:43:56 cmbuild Exp $";
    private static final String OWNER = "Owner";

    public XSDProjectElementImpl() {
    }

    public XSDProjectElementImpl(String name) throws RepositoryException {
        this.initializeOID();
        this.setName(name);
    }

    public abstract String getProjectElementType() throws RepositoryException;

    public Project getParentProject() throws RepositoryException {
        return (Project)this.getReferenceProperty(OWNER);
    }

    public void setParentProject(Project project) throws RepositoryException {
        this.changeOwner(project);
    }

    private void changeOwner(Project newOwner) throws RepositoryException {
        ProjectElement projectElement;
        if (newOwner == null) {
            throw new IllegalArgumentException("new owner cannot be null.");
        }
        Project oldOwner = this.getParentProject();
        if (newOwner == oldOwner) {
            return;
        }
        if (newOwner != null && (projectElement = newOwner.getProjectElement(this.getName())) != null && projectElement instanceof Project) {
            throw new IllegalArgumentException("Already a ProjectElement with that name " + this.getName() + " already exists in " + "the given parent project");
        }
        if (null != oldOwner && oldOwner instanceof Project) {
            oldOwner.removeProjectElement((ProjectElement)this);
        }
        if (this.getCUDTracker() == null) {
            this.setCUDTracker(newOwner.getCUDTracker());
            this.getCUDTracker().objectCreated((RepositoryObject)this);
        }
        this.setReferenceProperty(OWNER, newOwner);
        this.setOwnerOID(newOwner.getOID());
    }
}

