/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.runtime;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;

public abstract class XsdRule {
    private static int mSeqGen = 0;
    protected final int mSeqNo = mSeqGen++;
    public final byte mType;
    public final int mIndex;
    public final int mMinOccurs;
    public final int mMaxOccurs;

    public XsdRule(byte type, int childindex, int minoccurs, int maxoccurs) {
        this.mType = type;
        this.mIndex = childindex;
        this.mMinOccurs = minoccurs;
        this.mMaxOccurs = maxoccurs;
    }

    public boolean isParticle() {
        return this.mType != 6 && this.mType != 7;
    }

    public boolean isComplex() {
        return this.mType == 2 || this.mType == 4 || this.mType == 3;
    }

    public boolean isData() {
        return this.mType == 6;
    }

    public boolean isAttribute() {
        return this.mType == 7;
    }

    public boolean isWildcard() {
        return this.mType == 1;
    }

    public boolean isSTValidation() {
        return this.mType == 8;
    }

    public abstract Set getValidTokenSetNames(boolean var1);

    public void dump(PrintStream out, int level, Set seen) {
        for (int i = 0; i < level; ++i) {
            out.print("  ");
        }
        if (seen == null) {
            seen = new HashSet<XsdRule>();
        }
        if (seen.contains(this)) {
            out.println("[#" + this.mSeqNo + "]");
        } else {
            seen.add(this);
            out.println("[#" + this.mSeqNo + "] = " + Type.toString(this.mType));
        }
    }

    public static class Type {
        public static final byte ANYDATA = 1;
        public static final byte SEQUENCE = 2;
        public static final byte ANYORDER = 3;
        public static final byte CHOICE = 4;
        public static final byte SIMPLETYPE = 5;
        public static final byte DATA = 6;
        public static final byte ATTRIBUTE = 7;
        public static final byte STVALIDATION = 8;

        public static String toString(byte type) {
            switch (type) {
                case 1: {
                    return "ANYDATA";
                }
                case 3: {
                    return "ANYORDER";
                }
                case 4: {
                    return "CHOICE";
                }
                case 2: {
                    return "SEQUENCE";
                }
                case 5: {
                    return "SIMPLETYPE";
                }
                case 6: {
                    return "DATA";
                }
                case 7: {
                    return "ATTRIBUTE";
                }
                case 8: {
                    return "STVALIDATION";
                }
            }
            return "[type=" + type + "?]";
        }
    }
}

