/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.runtime.provider;

import com.stc.otd.tools.xml.EndTag;
import com.stc.otd.tools.xml.LexerException;
import com.stc.otd.tools.xml.StartTag;
import com.stc.otd.tools.xml.Tag;
import com.stc.otd.tools.xml.XmlLexer;
import com.stc.otd.tools.xml.XmlLexerImpl;
import com.stc.otd.xsd.runtime.XsdEnumerationSet;
import com.stc.util.NestedException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class XsdEnumerationSetImpl
implements XsdEnumerationSet {
    public static final int AND_SET = 1;
    public static final int OR_SET = 2;
    public static final int ENUMERATION = 3;
    private int mType;
    private Set mSet = new HashSet();

    public XsdEnumerationSetImpl() {
    }

    public XsdEnumerationSetImpl(int type) {
        this.mType = type;
    }

    public boolean isAndSet() {
        return this.mType == 1;
    }

    public boolean isOrSet() {
        return this.mType == 2;
    }

    public boolean isEnumeration() {
        return this.mType == 3;
    }

    public int getChildrenCount() {
        return this.mSet.size();
    }

    public Iterator getChildIterator() {
        return this.mSet.iterator();
    }

    public String serialize() {
        StringWriter sw = new StringWriter();
        if (this.isAndSet()) {
            sw.write("<and>");
        } else if (this.isOrSet()) {
            sw.write("<or>");
        } else if (this.isEnumeration()) {
            sw.write("<enum>");
        } else {
            throw new NestedException("type unknown: " + this.mType);
        }
        if (!this.mSet.isEmpty()) {
            Iterator it = this.mSet.iterator();
            if (this.isAndSet() || this.isOrSet()) {
                while (it.hasNext()) {
                    XsdEnumerationSetImpl child = (XsdEnumerationSetImpl)it.next();
                    sw.write(child.serialize());
                }
            } else if (this.isEnumeration()) {
                while (it.hasNext()) {
                    String child = (String)it.next();
                    sw.write("<e>");
                    sw.write(child);
                    sw.write("</e>");
                }
            }
        }
        if (this.isAndSet()) {
            sw.write("</and>");
        } else if (this.isOrSet()) {
            sw.write("</or>");
        } else if (this.isEnumeration()) {
            sw.write("</enum>");
        }
        return sw.toString();
    }

    void deserializeInternal(XmlLexer lexer, Tag currentTag) {
        try {
            if (lexer.isEOF()) {
                return;
            }
            Tag tag = currentTag != null ? currentTag : lexer.nextTag();
            if (!(tag instanceof StartTag)) {
                return;
            }
            String tagName = tag.getLocalName();
            if (tagName.equals("and")) {
                this.mType = 1;
            } else if (tagName.equals("or")) {
                this.mType = 2;
            } else if (tagName.equals("enum")) {
                this.mType = 3;
            } else {
                throw new NestedException("unexpected tag: " + tagName);
            }
            while (!lexer.isEOF()) {
                tag = lexer.nextTag();
                if (tag instanceof StartTag) {
                    if (this.isAndSet() || this.isOrSet()) {
                        XsdEnumerationSetImpl child = new XsdEnumerationSetImpl();
                        child.deserializeInternal(lexer, tag);
                        this.mSet.add(child);
                        continue;
                    }
                    if (!this.isEnumeration()) continue;
                    tag = lexer.nextTag();
                    this.mSet.add(((EndTag)tag).getData());
                    continue;
                }
                if (tag instanceof EndTag) break;
                throw new NestedException("unexpected tag: " + tag.toString());
            }
            if (!(tag instanceof EndTag) || tagName != tag.getLocalName()) {
                throw new NestedException("end tag for '" + tagName + "' required.");
            }
        }
        catch (IOException ioe) {
            throw new NestedException("IOExcepiton during parsing.", (Throwable)ioe);
        }
        catch (LexerException le) {
            throw new NestedException("LexerExcepiton during parsing.", (Throwable)le);
        }
    }

    public void deserialize(String data) {
        XmlLexerImpl lexer;
        if (data == null || data.length() <= 0) {
            return;
        }
        try {
            lexer = new XmlLexerImpl((Reader)new StringReader(data));
            lexer.init();
        }
        catch (IOException ioe) {
            throw new NestedException("IOExcepiton during initializing lexer.", (Throwable)ioe);
        }
        catch (LexerException le) {
            throw new NestedException("LexerException during initializing lexer.", (Throwable)le);
        }
        this.reset();
        this.deserializeInternal((XmlLexer)lexer, null);
    }

    private void reset() {
        this.mSet = new HashSet();
    }

    public void addChild(XsdEnumerationSet child) {
        if (!this.isAndSet() && !this.isOrSet()) {
            throw new NestedException("Invalid type. Must be a set type to perform this operation.");
        }
        if (child != null) {
            this.mSet.add(child);
        }
    }

    public void addChild(String child) {
        if (!this.isEnumeration()) {
            throw new NestedException("Invalid type. Must be an enumeration type to perform this operation.");
        }
        if (child == null || child.trim().length() <= 0) {
            throw new NestedException("Invalid enumeration value. Must not be empty.");
        }
        this.mSet.add(child.trim());
    }

    public boolean hasValue(String value) {
        if (this.mType == 3) {
            return this.mSet.contains(value);
        }
        if (this.mType == 1) {
            if (this.mSet.size() > 0) {
                Iterator it = this.mSet.iterator();
                while (it.hasNext()) {
                    if (((XsdEnumerationSet)it.next()).hasValue(value)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.mType == 2) {
            if (this.mSet.size() > 0) {
                Iterator it = this.mSet.iterator();
                boolean passed = false;
                while (it.hasNext()) {
                    if (!((XsdEnumerationSet)it.next()).hasValue(value)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        throw new NestedException("Invalid type: " + this.mType);
    }
}

