/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.runtime.provider;

import com.stc.otd.runtime.OtdLocation;
import com.stc.otd.runtime.OtdMeta;
import com.stc.otd.runtime.OtdMeta2;
import com.stc.otd.runtime.UnmarshalException;
import com.stc.otd.tools.xml.NamespaceMap;
import com.stc.otd.tools.xml.NamespaceMaps;
import com.stc.otd.tools.xml.NoSyncStack;
import com.stc.otd.tools.xml.ParseEvent;
import com.stc.otd.tools.xml.SAXLexer;
import com.stc.otd.tools.xml.StartElement;
import com.stc.otd.tools.xml.XXLLexerAdapter;
import com.stc.otd.xsd.codegen.SchemaRuntime;
import com.stc.otd.xsd.datatype.Date2001;
import com.stc.otd.xsd.datatype.DateTime;
import com.stc.otd.xsd.datatype.Duration;
import com.stc.otd.xsd.datatype.GDay;
import com.stc.otd.xsd.datatype.GMonth;
import com.stc.otd.xsd.datatype.GMonthDay;
import com.stc.otd.xsd.datatype.GYear;
import com.stc.otd.xsd.datatype.GYearMonth;
import com.stc.otd.xsd.datatype.Time2001;
import com.stc.otd.xsd.runtime.STValidationException;
import com.stc.otd.xsd.runtime.Token;
import com.stc.otd.xsd.runtime.TokenStream;
import com.stc.otd.xsd.runtime.XsdFacets;
import com.stc.otd.xsd.runtime.XsdNode;
import com.stc.otd.xsd.runtime.XsdRule;
import com.stc.otd.xsd.runtime.XsdSTValidator;
import com.stc.otd.xsd.runtime.provider.AnyOrderRule;
import com.stc.otd.xsd.runtime.provider.ChoiceRule;
import com.stc.otd.xsd.runtime.provider.ComplexRule;
import com.stc.otd.xsd.runtime.provider.DataRule;
import com.stc.otd.xsd.runtime.provider.ParticleRule;
import com.stc.otd.xsd.runtime.provider.Rule;
import com.stc.otd.xsd.runtime.provider.RuleExtension;
import com.stc.otd.xsd.runtime.provider.SequenceRule;
import com.stc.otd.xsd.runtime.provider.SimpleRule;
import com.stc.otd.xsd.runtime.provider.WildcardRule;
import com.stc.otd.xsd.runtime.provider.XmlToken;
import com.stc.otd.xsd.runtime.provider.XmlTokenStream;
import com.stc.otd.xsd.runtime.provider.XsdFake;
import com.stc.otd.xsd.runtime.provider.XsdLocation;
import com.stc.otd.xsd.runtime.provider.XsdSTValidatorImpl;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class XsdParse {
    private TokenStream mTokenStream;
    private XmlToken[] mTokenWindow = new XmlToken[2];
    private boolean mStrictValidation = false;
    private XsdSTValidator mSTValidator = null;
    private PrintStream mDebugOut = null;
    private NamespaceMaps mNSMaps = new NamespaceMaps();
    private NamespaceMap mNSMap = new NamespaceMap();
    private static final NamespaceMap EMPTY_NS_MAP = new NamespaceMap();

    public XsdParse(TokenStream tokenstream) {
        this.mTokenStream = tokenstream;
        this.mTokenWindow[0] = (XmlToken)this.mTokenStream.nextToken();
        this.mTokenWindow[1] = (XmlToken)this.mTokenStream.nextToken();
    }

    public XmlToken peek() {
        return this.mTokenWindow[0];
    }

    public XmlToken peekNext() {
        return this.mTokenWindow[1];
    }

    public void moveNext() {
        this.mTokenWindow[0] = this.mTokenWindow[1];
        this.mTokenWindow[1] = (XmlToken)this.mTokenStream.nextToken();
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Move to next token.");
            if (this.mTokenWindow[0] != null) {
                this.mDebugOut.println("Next token in window=" + this.mTokenWindow[0].getName());
            }
        }
    }

    private void parseData(XsdRule rule, XsdNode parent, int repindex) {
        XmlToken token = this.peek();
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parseData(). rule=" + rule.mIndex + ", parentClass='" + parent.getClass().getName() + "', repindex=" + repindex);
            this.mDebugOut.println("Next token in window='" + token.getName());
        }
        if (!token.equals(Token.PCDATA_TOKEN)) {
            if (rule.mMinOccurs > 0) {
                parent.xsdSet(rule.mIndex, repindex, "");
            }
            if (this.mDebugOut != null) {
                this.mDebugOut.println("No PCDATA, exiting parseData().");
            }
            return;
        }
        XsdFacets facets = null;
        if (this.mStrictValidation) {
            facets = ((DataRule)rule).getValidationFacets();
        }
        parent.xsdSet(rule.mIndex, repindex, this.unmarshalData(facets, ((DataRule)rule).getByteFormJType(), ((DataRule)rule).mJavaType, this.peek(), false, ((DataRule)rule).getBuiltInXsdTypeId()));
        this.moveNext();
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parseData().");
        }
    }

    private int parseWildcard(XsdRule rule, XsdNode parent, int repindex) {
        XmlToken token = this.peek();
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parseWildcard(). rule=" + rule.mIndex + ", parentClass='" + parent.getClass().getName() + "', repindex=" + repindex);
            this.mDebugOut.println("Next token in window='" + token.getName());
        }
        if (token.getParseEvent().getType() == 5) {
            parent.xsdSet(rule.mIndex, repindex, token.getText());
            this.moveNext();
            if (this.mDebugOut != null) {
                this.mDebugOut.println("Got PCDATA, exiting parseWildcard().");
            }
            return repindex--;
        }
        if (token.getParseEvent().getType() == 4) {
            if (rule.mMinOccurs > 0) {
                parent.xsdSet(rule.mIndex, repindex, "");
            }
            if (this.mDebugOut != null) {
                this.mDebugOut.println("Seeing end tag, exiting parseWildcard().");
            }
            return repindex--;
        }
        if (token.getParseEvent().getType() != 3) {
            throw new UnmarshalException((OtdLocation)new XsdLocation(token), "expecting start element, found: " + token.getName());
        }
        this.mNSMaps.clear();
        StringBuffer anydata = new StringBuffer();
        NoSyncStack stack = new NoSyncStack();
        while (true) {
            if (token.getParseEvent().getType() == 3) {
                this.mNSMap.clear();
                anydata.append(((StartElement)token.getParseEvent()).toXML(this.mNSMaps, this.mNSMap));
                if (!this.mNSMap.isEmpty()) {
                    this.mNSMaps.push(this.mNSMap);
                    this.mNSMap = new NamespaceMap();
                } else {
                    this.mNSMaps.push(EMPTY_NS_MAP);
                }
                stack.push((Object)token.getName());
                this.moveNext();
            } else if (token.getParseEvent().getType() == 4) {
                anydata.append(token.getParseEvent().toXML());
                stack.pop();
                this.mNSMaps.pop();
                this.moveNext();
                if (stack.isEmpty()) {
                    break;
                }
            } else if (token.getParseEvent().getType() == 5) {
                String charbuff = token.getParseEvent().toXML();
                boolean empty = true;
                for (int i = 0; i < charbuff.length(); ++i) {
                    char c = charbuff.charAt(i);
                    if (c == '\r' || c == '\n' || c == '\t' || c == '\f' || c == ' ') continue;
                    empty = false;
                    break;
                }
                if (!empty) {
                    anydata.append(charbuff);
                }
                this.moveNext();
            } else {
                throw new UnmarshalException((OtdLocation)new XsdLocation(token), "Unexpected token: " + token.getName());
            }
            token = this.peek();
        }
        if (anydata.length() > 0) {
            parent.xsdSet(rule.mIndex, repindex, anydata.toString());
        }
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parseWildcard().");
        }
        return repindex;
    }

    private void parseSimpleType(XsdRule rule, XsdNode parent, int repindex) {
        XmlToken token;
        String data;
        Attributes attrs;
        String nil;
        ParseEvent pe = this.peek().getParseEvent();
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parseSimpleType(). rule=" + rule.mIndex + ", parentClass='" + parent.getClass().getName() + "', repindex=" + repindex);
            this.mDebugOut.println("Expecting token='" + ((SimpleRule)rule).mStartToken.getName());
        }
        XmlToken start = this.peek();
        this.match(((SimpleRule)rule).mStartToken);
        StartElement se = (StartElement)start.getParseEvent();
        boolean isNil = false;
        if (((SimpleRule)rule).isNillable()) {
            if (this.mDebugOut != null) {
                this.mDebugOut.println("element is nillable.");
            }
            if ((nil = (attrs = se.attributes).getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) != null && nil.equals("true")) {
                isNil = true;
            }
        }
        if (!(((SimpleRule)rule).getByteFormJType() == 10 || !(pe instanceof StartElement) || (nil = (attrs = ((StartElement)pe).attributes).getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) != null && nil.equals("true") || (data = (token = this.peek()).equals(Token.PCDATA_TOKEN) ? token.getText() : "") != null && data.length() > 0)) {
            throw new UnmarshalException("Element " + pe + " is not allowed to have a nil value.");
        }
        XsdFacets facets = null;
        if (this.mStrictValidation) {
            facets = ((SimpleRule)rule).getValidationFacets();
        }
        parent.xsdSet(rule.mIndex, repindex, this.unmarshalData(facets, ((SimpleRule)rule).getByteFormJType(), ((SimpleRule)rule).mJavaType, this.peek(), isNil, ((SimpleRule)rule).getBuiltInXsdTypeId()));
        if (this.peek().equals(Token.PCDATA_TOKEN)) {
            this.moveNext();
        }
        this.match(((SimpleRule)rule).mEndToken);
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parseSimpleType().");
        }
    }

    private Object unmarshalData(XsdFacets facets, byte jtype, String javaType, XmlToken token, boolean isNil, int builtInXsdTypeId) {
        char[] data;
        String sdata;
        if (token.equals(Token.PCDATA_TOKEN)) {
            sdata = token.getText();
            data = sdata.toCharArray();
        } else {
            sdata = "";
            data = new char[]{};
        }
        if (isNil) {
            if (data.length > 0) {
                XsdLocation location = new XsdLocation(token);
                throw new UnmarshalException((OtdLocation)location, location.text() + "Must be nil");
            }
            return null;
        }
        if (this.mStrictValidation) {
            Object obj = null;
            if (facets != null) {
                try {
                    obj = this.mSTValidator.validate(facets, sdata);
                }
                catch (STValidationException ex) {
                    XsdLocation location = new XsdLocation(token);
                    throw new UnmarshalException((OtdLocation)location, location.text() + " " + ex.getMessage());
                }
            }
            switch (jtype) {
                case 0: {
                    if (obj instanceof Boolean) {
                        return obj;
                    }
                    return new Boolean(SchemaRuntime.unmarshalBoolean(data));
                }
                case 1: {
                    if (obj instanceof Byte) {
                        return obj;
                    }
                    return new Byte(SchemaRuntime.unmarshalByte(data));
                }
                case 2: {
                    return new Short(SchemaRuntime.unmarshalShort(data));
                }
                case 3: {
                    if (obj instanceof Integer) {
                        return obj;
                    }
                    return new Integer(SchemaRuntime.unmarshalInt(data));
                }
                case 4: {
                    if (obj instanceof Long) {
                        return obj;
                    }
                    return new Long(SchemaRuntime.unmarshalLong(data));
                }
                case 5: {
                    if (obj instanceof Float) {
                        return obj;
                    }
                    return new Float(SchemaRuntime.unmarshalFloat(data));
                }
                case 6: {
                    if (obj instanceof Double) {
                        return obj;
                    }
                    return new Double(SchemaRuntime.unmarshalDouble(data));
                }
                case 19: {
                    if (obj instanceof BigInteger) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalBigInteger(data);
                }
                case 7: {
                    if (obj instanceof BigDecimal) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalBigDecimal(data);
                }
                case 8: {
                    if (obj instanceof DateTime) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalDateTime(data);
                }
                case 9: {
                    if (obj instanceof Date2001) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalDate2001(data);
                }
                case 10: {
                    if (obj instanceof String) {
                        return obj;
                    }
                    return sdata;
                }
                case 11: {
                    if (obj instanceof byte[]) {
                        return obj;
                    }
                    if (builtInXsdTypeId == 17) {
                        return SchemaRuntime.unmarshalBinary16(data);
                    }
                    return SchemaRuntime.unmarshalBase64Binary(data);
                }
                case 12: {
                    if (obj instanceof Duration) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalDuration(data);
                }
                case 13: {
                    if (obj instanceof Time2001) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalTime2001(data);
                }
                case 14: {
                    if (obj instanceof GYearMonth) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalGYearMonth(data);
                }
                case 15: {
                    if (obj instanceof GYear) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalGYear(data);
                }
                case 16: {
                    if (obj instanceof GMonth) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalGMonth(data);
                }
                case 17: {
                    if (obj instanceof GMonthDay) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalGMonthDay(data);
                }
                case 18: {
                    if (obj instanceof GDay) {
                        return obj;
                    }
                    return SchemaRuntime.unmarshalGDay(data);
                }
            }
            XsdLocation location = new XsdLocation(token);
            throw new UnmarshalException((OtdLocation)location, location.text() + "Unknown data type: " + javaType);
        }
        switch (jtype) {
            case 0: {
                return new Boolean(SchemaRuntime.unmarshalBoolean(data));
            }
            case 1: {
                return new Byte(SchemaRuntime.unmarshalByte(data));
            }
            case 2: {
                return new Short(SchemaRuntime.unmarshalShort(data));
            }
            case 3: {
                return new Integer(SchemaRuntime.unmarshalInt(data));
            }
            case 4: {
                return new Long(SchemaRuntime.unmarshalLong(data));
            }
            case 5: {
                return new Float(SchemaRuntime.unmarshalFloat(data));
            }
            case 6: {
                return new Double(SchemaRuntime.unmarshalDouble(data));
            }
            case 19: {
                return SchemaRuntime.unmarshalBigInteger(data);
            }
            case 7: {
                return SchemaRuntime.unmarshalBigDecimal(data);
            }
            case 8: {
                return SchemaRuntime.unmarshalDateTime(data);
            }
            case 9: {
                return SchemaRuntime.unmarshalDate2001(data);
            }
            case 10: {
                return sdata;
            }
            case 11: {
                if (builtInXsdTypeId == 17) {
                    return SchemaRuntime.unmarshalBinary16(data);
                }
                return SchemaRuntime.unmarshalBase64Binary(data);
            }
            case 12: {
                return SchemaRuntime.unmarshalDuration(data);
            }
            case 13: {
                return SchemaRuntime.unmarshalTime2001(data);
            }
            case 14: {
                return SchemaRuntime.unmarshalGYearMonth(data);
            }
            case 15: {
                return SchemaRuntime.unmarshalGYear(data);
            }
            case 16: {
                return SchemaRuntime.unmarshalGMonth(data);
            }
            case 17: {
                return SchemaRuntime.unmarshalGMonthDay(data);
            }
            case 18: {
                return SchemaRuntime.unmarshalGDay(data);
            }
        }
        XsdLocation location = new XsdLocation(token);
        throw new UnmarshalException((OtdLocation)location, location.text() + "Unknown data type: " + javaType);
    }

    private void parseSequence(XsdRule rule, XsdNode node, int min, int max, boolean noskip) {
        if (rule == null) {
            throw new NullPointerException("no rule");
        }
        if (rule.mType != 2) {
            throw new IllegalArgumentException("rule must be sequence, not " + XsdRule.Type.toString(rule.mType));
        }
        SequenceRule sqRule = (SequenceRule)rule;
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parseSequence(). rule=" + rule.mIndex + ", nodeClass='" + node.getClass().getName() + "', min=" + min + ", max = " + max + ", noskip=" + noskip);
            if (sqRule.mChildRules != null) {
                this.mDebugOut.println("Number of child rules=" + sqRule.mChildRules.length);
            }
        }
        for (int i = 0; sqRule.mChildRules != null && i < sqRule.mChildRules.length; ++i) {
            XsdNode derivedNode;
            XsdNode subNode;
            int repidx;
            XsdRule subRule = sqRule.mChildRules[i];
            if (subRule.isAttribute()) continue;
            int cmin = !noskip ? (sqRule.mMinOccurs * min > 0 ? sqRule.mMinOccurs : 0) : (sqRule.mMinOccurs > 1 ? sqRule.mMinOccurs : 1);
            int cmax = sqRule.mMaxOccurs;
            boolean optional = cmin == 0 || subRule.mMinOccurs == 0;
            boolean rep = subRule.mMaxOccurs == -1 || subRule.mMaxOccurs > 1;
            int repindex = -1;
            int wcChildIndex = -1;
            XmlToken token = this.peek();
            if (!optional || this.test(subRule, token, cmin, cmax, false)) {
                if (subRule.isComplex()) {
                    repidx = rep ? ++repindex : -1;
                    subNode = node.xsdMake(subRule.mIndex, repidx, token.getOffset());
                    derivedNode = this.parseComplex(subRule, subNode, 1, cmax);
                    if (derivedNode != null) {
                        node.xsdSet(subRule.mIndex, repidx, derivedNode);
                    }
                } else if (subRule.isData()) {
                    this.parseData(subRule, node, rep ? ++repindex : -1);
                } else if (subRule.isWildcard()) {
                    repindex = this.parseWildcard(subRule, node, rep ? ++wcChildIndex : -1);
                } else {
                    this.parseSimpleType(subRule, node, rep ? ++repindex : -1);
                }
                noskip = true;
            }
            if (!rep) continue;
            token = this.peek();
            while (this.test(subRule, token, cmin, cmax, false, repindex + 1)) {
                if (subRule.isComplex()) {
                    repidx = rep ? ++repindex : -1;
                    subNode = node.xsdMake(subRule.mIndex, repidx, token.getOffset());
                    derivedNode = this.parseComplex(subRule, subNode, 1, cmax);
                    if (derivedNode != null) {
                        node.xsdSet(subRule.mIndex, repidx, derivedNode);
                    }
                } else if (subRule.isData()) {
                    this.parseData(subRule, node, rep ? ++repindex : -1);
                } else if (subRule.isWildcard()) {
                    repindex = this.parseWildcard(subRule, node, rep ? ++wcChildIndex : -1);
                } else {
                    this.parseSimpleType(subRule, node, rep ? ++repindex : -1);
                }
                token = this.peek();
            }
        }
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parseSequence().");
        }
    }

    private void parseChoice(XsdRule rule, XsdNode node, int min, int max, boolean noskip) {
        int cmin;
        if (rule == null) {
            throw new NullPointerException("no rule");
        }
        if (rule.mType != 4) {
            throw new IllegalArgumentException("rule must be choice, not " + XsdRule.Type.toString(rule.mType));
        }
        ChoiceRule chRule = (ChoiceRule)rule;
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parseChoice(). rule=" + rule.mIndex + ", nodeClass='" + node.getClass().getName() + "', min=" + min + ", max = " + max + ", noskip=" + noskip);
            if (chRule.mChildRules != null) {
                this.mDebugOut.println("Number of child rules=" + chRule.mChildRules.length);
            }
        }
        int n = cmin = chRule.mMinOccurs * min > 0 ? chRule.mMinOccurs : 0;
        if (noskip) {
            cmin = chRule.mMinOccurs > 1 ? chRule.mMinOccurs : 1;
        }
        int cmax = chRule.mMaxOccurs;
        boolean matched = false;
        int totalmin = Integer.MAX_VALUE;
        boolean bAtleastOneParticle = false;
        for (int i = 0; chRule.mChildRules != null && i < chRule.mChildRules.length; ++i) {
            XsdRule subRule = chRule.mChildRules[i];
            if (!subRule.isParticle()) continue;
            bAtleastOneParticle = true;
            if (((ParticleRule)subRule).getEffTotalMin() < totalmin) {
                totalmin = ((ParticleRule)subRule).getEffTotalMin();
            }
            boolean rep = subRule.mMaxOccurs == -1 || subRule.mMaxOccurs > 1;
            int repindex = -1;
            int wcChildIndex = -1;
            XmlToken token = this.peek();
            if (this.test(subRule, token, 0, cmax, true)) {
                XsdNode derivedNode;
                XsdNode subNode;
                int repidx;
                matched = true;
                if (subRule.isComplex()) {
                    repidx = rep ? ++repindex : -1;
                    subNode = node.xsdMake(subRule.mIndex, repidx, token.getOffset());
                    derivedNode = this.parseComplex(subRule, subNode, 1, cmax);
                    if (derivedNode != null) {
                        node.xsdSet(subRule.mIndex, repidx, derivedNode);
                    }
                } else if (subRule.isData()) {
                    this.parseData(subRule, node, rep ? ++repindex : -1);
                } else if (subRule.isWildcard()) {
                    repindex = this.parseWildcard(subRule, node, rep ? ++wcChildIndex : -1);
                } else {
                    this.parseSimpleType(subRule, node, rep ? ++repindex : -1);
                }
                if (rep) {
                    token = this.peek();
                    while (this.test(subRule, token, 1, cmax, false, repindex + 1)) {
                        if (subRule.isComplex()) {
                            repidx = rep ? ++repindex : -1;
                            subNode = node.xsdMake(subRule.mIndex, repidx, token.getOffset());
                            derivedNode = this.parseComplex(subRule, subNode, 1, cmax);
                            if (derivedNode != null) {
                                node.xsdSet(subRule.mIndex, repidx, derivedNode);
                            }
                        } else if (subRule.isData()) {
                            this.parseData(subRule, node, rep ? ++repindex : -1);
                        } else if (subRule.isWildcard()) {
                            repindex = this.parseWildcard(subRule, node, rep ? ++wcChildIndex : -1);
                        } else {
                            this.parseSimpleType(subRule, node, rep ? ++repindex : -1);
                        }
                        token = this.peek();
                    }
                }
            }
            if (matched) break;
        }
        if (cmin > 0 && bAtleastOneParticle && totalmin > 0 && !matched) {
            XsdLocation location = new XsdLocation(this.peek());
            throw new UnmarshalException((OtdLocation)location, location.text() + " expecting one of following possible elements: " + chRule.getValidTokenSetNames(false).toString() + ", found: " + this.peek().getName());
        }
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parseChoice().");
        }
    }

    private void parseAnyOrder(XsdRule rule, XsdNode node, int min, int max, boolean noskip) {
        XsdRule subRule;
        int i;
        byte[] filled;
        byte[] minarray;
        if (rule == null) {
            throw new NullPointerException("no rule");
        }
        if (rule.mType != 3) {
            throw new IllegalArgumentException("rule must be any order (xsd;all), not " + XsdRule.Type.toString(rule.mType));
        }
        AnyOrderRule allRule = (AnyOrderRule)rule;
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parseAnyOrder(). rule=" + rule.mIndex + ", nodeClass='" + node.getClass().getName() + "', min=" + min + ", max = " + max + ", noskip=" + noskip);
            if (allRule.mChildRules != null) {
                this.mDebugOut.println("Number of child rules=" + allRule.mChildRules.length);
            }
        }
        int cmin = !noskip ? (allRule.mMinOccurs * min > 0 ? allRule.mMinOccurs : 0) : (allRule.mMinOccurs > 1 ? allRule.mMinOccurs : 1);
        int cmax = allRule.mMaxOccurs;
        if (allRule.mChildRules != null) {
            minarray = new byte[allRule.mChildRules.length];
            filled = new byte[allRule.mChildRules.length];
            for (i = 0; i < allRule.mChildRules.length; ++i) {
                minarray[i] = 0;
                filled[i] = 0;
            }
        } else {
            if (this.mDebugOut != null) {
                this.mDebugOut.println("mChildRules is null. Exiting parseAnyOrder().");
            }
            return;
        }
        block1: for (i = 0; i < allRule.mChildRules.length; ++i) {
            subRule = allRule.mChildRules[i];
            if (subRule.isAttribute()) continue;
            cmin = !noskip ? (allRule.mMinOccurs * min > 0 ? allRule.mMinOccurs : 0) : (allRule.mMinOccurs > 1 ? allRule.mMinOccurs : 1);
            cmax = allRule.mMaxOccurs;
            if (subRule.isComplex()) {
                if (!((ComplexRule)subRule).isAnonymous() && cmin > 0 && subRule.mMinOccurs > 0) {
                    minarray[i] = 1;
                }
            } else if (cmin > 0 && subRule.mMinOccurs > 0) {
                minarray[i] = 1;
            }
            for (int j = 0; j < allRule.mChildRules.length; ++j) {
                XmlToken token;
                XsdRule subRule2 = allRule.mChildRules[j];
                if (subRule2.isAttribute() || filled[j] > 0 || !this.test(subRule2, token = this.peek(), 0, cmax, false)) continue;
                if (subRule2.isComplex()) {
                    XsdNode subNode = node.xsdMake(subRule2.mIndex, -1, token.getOffset());
                    XsdNode derivedNode = this.parseComplex(subRule2, subNode, 1, cmax);
                    if (derivedNode != null) {
                        node.xsdSet(subRule.mIndex, -1, derivedNode);
                    }
                } else if (subRule2.isData()) {
                    this.parseData(subRule2, node, -1);
                } else if (subRule2.isWildcard()) {
                    this.parseWildcard(subRule2, node, -1);
                } else {
                    this.parseSimpleType(subRule2, node, -1);
                }
                filled[j] = 1;
                noskip = true;
                continue block1;
            }
        }
        if (noskip) {
            for (i = 0; i < allRule.mChildRules.length; ++i) {
                if (allRule.mChildRules[i].isAttribute() || minarray[i] != 1 || filled[i] != 0) continue;
                subRule = allRule.mChildRules[i];
                throw new UnmarshalException((OtdLocation)new XsdLocation(this.peek()), "One of following required elements: " + subRule.getValidTokenSetNames(true).toString() + "not found. current token: " + this.peek().getName());
            }
        }
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parseAnyOrder().");
        }
    }

    public XsdNode parseComplex(XsdRule rule, XsdNode node, int min, int max) {
        if (rule == null) {
            throw new NullPointerException("no rule");
        }
        if (!rule.isComplex()) {
            throw new RuntimeException("Must be a complex rule");
        }
        ComplexRule cpRule = (ComplexRule)rule;
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parseComplex(). rule=" + rule.mIndex + ", nodeClass='" + node.getClass().getName() + "'");
        }
        XmlToken start = this.peek();
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Next token in window={" + start.getName() + "}");
        }
        boolean derived = false;
        if (cpRule.mRuleExts != null) {
            for (int i = 0; i < cpRule.mRuleExts.length; ++i) {
                RuleExtension re = cpRule.mRuleExts[i];
                if (!((StartElement)start.getParseEvent()).isXsiType(re.getNamespaceUri(), re.getTypeName())) continue;
                node = node.xsdMakeTopNode(re.getClassName());
                cpRule = (ComplexRule)re.getRule();
                if (this.mDebugOut != null) {
                    this.mDebugOut.println("Switched to the extension rule. rule=" + cpRule.mIndex + ", nodeClass='" + re.getClassName() + "'");
                }
                derived = true;
                break;
            }
        }
        if (!((ComplexRule)rule).isAnonymous()) {
            this.match(((ComplexRule)rule).mStartToken);
            StartElement se = (StartElement)start.getParseEvent();
            node.xsdUnmarshalAttributes(cpRule, se.attributes, !se.qName.equals(se.localName), se.namespaceURI);
            if (((ComplexRule)rule).isNillable()) {
                Attributes attrs;
                String nil;
                if (this.mDebugOut != null) {
                    this.mDebugOut.println("element is nillable.");
                }
                if ((nil = (attrs = se.attributes).getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) != null && nil.equals("true")) {
                    this.match(((ComplexRule)rule).mEndToken);
                    node.xsdSetNil(true);
                    if (derived) {
                        return node;
                    }
                    return null;
                }
            }
        }
        switch (cpRule.mType) {
            case 2: {
                this.parseSequence(cpRule, node, min, max, !((ComplexRule)rule).isAnonymous());
                break;
            }
            case 4: {
                this.parseChoice(cpRule, node, min, max, !((ComplexRule)rule).isAnonymous());
                break;
            }
            case 3: {
                this.parseAnyOrder(cpRule, node, min, max, !((ComplexRule)rule).isAnonymous());
                break;
            }
            default: {
                throw new RuntimeException("Invalid complex rule: " + cpRule.mType);
            }
        }
        if (!((ComplexRule)rule).isAnonymous()) {
            XmlToken token = this.peek();
            if (token.equals(Token.PCDATA_TOKEN) && XsdParse.isBlank(token.getText())) {
                this.moveNext();
            }
            this.match(((ComplexRule)rule).mEndToken);
        }
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parseComplex().");
        }
        if (derived) {
            return node;
        }
        return null;
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void match(Token token) {
        if (this.peek().equals(token)) {
            if (this.mDebugOut != null) {
                this.mDebugOut.println("Token matched='" + token.getName() + "'");
            }
            this.moveNext();
            return;
        }
        XsdLocation location = new XsdLocation(this.peek());
        throw new UnmarshalException((OtdLocation)location, location.text() + " expecting: " + token.getName() + ", found: " + this.peek().getName());
    }

    private boolean testMaxOccurs(XsdRule rule, XmlToken token, int index) {
        int count;
        if (rule.isWildcard() && token.getParseEvent() != null && token.getParseEvent().getType() == 5) {
            return true;
        }
        int maxOccurs = rule.mMaxOccurs;
        return maxOccurs <= 0 || (count = index + 1) <= maxOccurs;
    }

    protected boolean test(XsdRule rule, XmlToken token, int parentMin, int parentMax, boolean throwException, int index) {
        boolean matched = this.test(rule, token, parentMin, parentMax, throwException);
        if (matched) {
            return this.testMaxOccurs(rule, token, index);
        }
        return matched;
    }

    protected boolean test(XsdRule rule, XmlToken token, int parentMin, int parentMax, boolean throwException) {
        switch (rule.mType) {
            case 1: {
                WildcardRule wildcardRule = (WildcardRule)rule;
                if (wildcardRule.mNamespace.equals("##any")) {
                    return token.getParseEvent() != null && (token.getParseEvent().getType() == 3 || token.getParseEvent().getType() == 5);
                }
                if (wildcardRule.mNamespace.equals("##other")) {
                    return token.equals(Token.UNKNOWN_STARTTAG_TOKEN);
                }
            }
            case 3: {
                AnyOrderRule anyOrderRule = (AnyOrderRule)rule;
                if (!anyOrderRule.isAnonymous()) {
                    if (anyOrderRule.mStartToken.getId() == token.getId()) {
                        return true;
                    }
                    if (anyOrderRule.mMinOccurs == 0 || parentMin == 0 || !throwException) {
                        return false;
                    }
                    XsdLocation location = new XsdLocation(token);
                    throw new UnmarshalException((OtdLocation)location, location.text() + " expecting: " + anyOrderRule.mStartToken.getName() + ", found: " + token.getName());
                }
                int effMin = anyOrderRule.mMinOccurs * parentMin > 0 ? anyOrderRule.mMinOccurs : 0;
                int effMax = anyOrderRule.mMaxOccurs;
                for (int i = 0; anyOrderRule.mChildRules != null && i < anyOrderRule.mChildRules.length; ++i) {
                    if (anyOrderRule.mChildRules[i].isAttribute() || !this.test(anyOrderRule.mChildRules[i], token, effMin, effMax, throwException)) continue;
                    return true;
                }
                if (effMin == 0 || !throwException) {
                    return false;
                }
                XsdLocation location = new XsdLocation(token);
                throw new UnmarshalException((OtdLocation)location, location.text() + " expecting following possible elements (unordered): " + anyOrderRule.getValidTokenSetNames(true).toString() + ", found: " + token.getName());
            }
            case 4: {
                ChoiceRule choiceRule = (ChoiceRule)rule;
                if (!choiceRule.isAnonymous()) {
                    if (choiceRule.mStartToken.getId() == token.getId()) {
                        return true;
                    }
                    if (choiceRule.mMinOccurs == 0 || parentMin == 0 || !throwException) {
                        return false;
                    }
                    XsdLocation location = new XsdLocation(token);
                    throw new UnmarshalException((OtdLocation)location, location.text() + " expecting: " + choiceRule.mStartToken.getName() + ", found: " + token.getName());
                }
                int effMin = choiceRule.mMinOccurs * parentMin > 0 ? choiceRule.mMinOccurs : 0;
                int effMax = choiceRule.mMaxOccurs;
                for (int i = 0; choiceRule.mChildRules != null && i < choiceRule.mChildRules.length; ++i) {
                    if (choiceRule.mChildRules[i].isAttribute() || !this.test(choiceRule.mChildRules[i], token, effMin, effMax, throwException)) continue;
                    return true;
                }
                if (effMin == 0 || !throwException) {
                    return false;
                }
                XsdLocation location = new XsdLocation(token);
                throw new UnmarshalException((OtdLocation)location, location.text() + " expecting a choice of following possible elements: " + choiceRule.getValidTokenSetNames(true).toString() + ", found: " + token.getName());
            }
            case 2: {
                SequenceRule sequenceRule = (SequenceRule)rule;
                if (!sequenceRule.isAnonymous()) {
                    if (sequenceRule.mStartToken.getId() == token.getId()) {
                        return true;
                    }
                    if (sequenceRule.mMinOccurs == 0 || parentMin == 0 || !throwException) {
                        return false;
                    }
                    XsdLocation location = new XsdLocation(token);
                    throw new UnmarshalException((OtdLocation)location, location.text() + " expecting: " + sequenceRule.mStartToken.getName() + ", found: " + token.getName());
                }
                int effMin = sequenceRule.mMinOccurs * parentMin > 0 ? sequenceRule.mMinOccurs : 0;
                int effMax = sequenceRule.mMaxOccurs;
                for (int i = 0; sequenceRule.mChildRules != null && i < sequenceRule.mChildRules.length; ++i) {
                    if (sequenceRule.mChildRules[i].isAttribute()) continue;
                    if (this.test(sequenceRule.mChildRules[i], token, effMin, effMax, throwException)) {
                        return true;
                    }
                    if (sequenceRule.mChildRules[i].isParticle()) {
                        ParticleRule particleRule = (ParticleRule)sequenceRule.mChildRules[i];
                        if (particleRule.mMinOccurs <= 0) continue;
                        if (effMin > 0) {
                            if (throwException) {
                                XsdLocation location = new XsdLocation(token);
                                throw new UnmarshalException((OtdLocation)location, location.text() + " expecting following possible elements: " + particleRule.getValidTokenSetNames(true).toString() + ", found: " + token.getName());
                            }
                            return false;
                        }
                        return false;
                    }
                    if (!sequenceRule.mChildRules[i].isData() || sequenceRule.mChildRules[i].mMinOccurs <= 0) continue;
                    if (effMin > 0) {
                        if (throwException) {
                            XsdLocation location = new XsdLocation(token);
                            throw new UnmarshalException((OtdLocation)location, location.text() + " expecting: " + ((DataRule)sequenceRule.mChildRules[i]).mToken.getName() + ", found: " + token.getName());
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            case 6: {
                if (((DataRule)rule).mToken.getId() == token.getId()) {
                    return true;
                }
                if (rule.mMinOccurs == 0 || parentMin == 0) {
                    return false;
                }
                if (throwException) {
                    XsdLocation location = new XsdLocation(token);
                    throw new UnmarshalException((OtdLocation)location, location.text() + " expecting: " + ((DataRule)rule).mToken.getName() + ", found: " + token.getName());
                }
                return false;
            }
            case 5: {
                if (((SimpleRule)rule).mStartToken.getId() == token.getId()) {
                    return true;
                }
                if (rule.mMinOccurs == 0 || parentMin == 0) {
                    return false;
                }
                if (throwException) {
                    XsdLocation location = new XsdLocation(token);
                    throw new UnmarshalException((OtdLocation)location, location.text() + " expecting: " + ((SimpleRule)rule).mStartToken.getName() + ", found: " + token.getName());
                }
                return false;
            }
        }
        throw new UnmarshalException((OtdLocation)new XsdLocation(token), "Invalid rule: " + rule.toString());
    }

    public void setDebugStream(PrintStream debugOut) {
        this.mDebugOut = debugOut;
    }

    public PrintStream getDebugStream() {
        return this.mDebugOut;
    }

    public void parse(XsdRule rule, XsdNode node) {
        this.parse(rule, node, false);
    }

    public void parse(XsdRule rule, XsdNode node, boolean strictValidation) {
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Entering parse(). rule=" + rule.mIndex + ", nodeClass='" + node.getClass().getName() + "', validation=" + (strictValidation ? "true" : "false"));
        }
        this.mStrictValidation = strictValidation;
        if (this.mStrictValidation) {
            this.mSTValidator = new XsdSTValidatorImpl();
        }
        this.parseComplex(rule, node, 1, 1);
        if (this.mDebugOut != null) {
            this.mDebugOut.println("Exiting parse().");
        }
    }

    public static void main(String[] args) {
        try {
            XsdMeta meta0 = new XsdMeta(11, "root", "XsdFake", 0, false, false, null, 68);
            XsdMeta meta1 = new XsdMeta(11, "node1", "XsdFake", 0, false, false, null, 68);
            XsdMeta.access$002(meta0, new OtdMeta[]{meta1});
            XsdMeta meta2 = new XsdMeta(12, "attr1", "Attr1", 0, false, false, null, 68);
            XsdMeta meta3 = new XsdMeta(12, "attr2", "Attr2", 1, false, false, null, 68);
            XsdMeta meta4 = new XsdMeta(12, "elem1", "Elem1", 2, false, false, null, 68);
            XsdMeta meta5 = new XsdMeta(12, "elem2", "Elem2", 3, false, false, null, 68);
            XsdMeta.access$002(meta1, new OtdMeta[]{meta2, meta3, meta4, meta5});
            XsdFake root = new XsdFake(meta0, null);
            XXLLexerAdapter lexer = new XXLLexerAdapter();
            InputSource in = new InputSource(new InputStreamReader(new FileInputStream("C:\\Research\\test.xml")));
            lexer.setInputSource(in, "http://www.w3.org/2001/XMLSchema-instance");
            XmlTokenStream ts = new XmlTokenStream((SAXLexer)lexer);
            XsdParse parser = new XsdParse(ts);
            parser.parseComplex(Rule.rule[0], root, 1, 1);
            System.out.println("Parsing finished successfully");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static class XsdMeta
    implements OtdMeta2 {
        private OtdMeta[] mKids;
        private final Class mClass;
        private final String mName;
        private final String mJavaName;
        private final boolean mRepeat;
        private final boolean mChoice;
        private final byte mType;
        private final int mAccess;
        private final int mIndex;

        public XsdMeta(byte type, String name, String java, int index, boolean repeated, boolean choice, Class clazz, int access) {
            this.mType = type;
            this.mName = name;
            this.mJavaName = java;
            this.mIndex = index;
            this.mRepeat = repeated;
            this.mChoice = choice;
            this.mClass = clazz;
            this.mAccess = access;
        }

        public boolean isLeaf() {
            return this.mType != 11;
        }

        public boolean isChoice() {
            return this.mChoice;
        }

        public int getChildCount() {
            return this.mKids == null ? 0 : this.mKids.length;
        }

        public OtdMeta getChild(int index) throws IndexOutOfBoundsException {
            if (this.mKids == null) {
                throw new IndexOutOfBoundsException("no children");
            }
            return this.mKids[index];
        }

        public OtdMeta getReference() {
            return null;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public String getName() {
            return this.mName;
        }

        public String getJavaName() {
            return this.mJavaName;
        }

        public int getAccess() {
            return this.mAccess;
        }

        public byte getType() {
            return this.mType;
        }

        public boolean indexed() {
            return this.mRepeat;
        }

        public boolean isFakeTree() {
            return false;
        }

        public Class getNodeClass() {
            return this.mClass;
        }

        public Object getProperty(String name) {
            return null;
        }

        static /* synthetic */ OtdMeta[] access$002(XsdMeta x0, OtdMeta[] x1) {
            x0.mKids = x1;
            return x1;
        }
    }
}

