/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.runtime.provider;

import com.stc.otd.runtime.UnmarshalException;
import com.stc.otd.xsd.codegen.SchemaRuntime;
import com.stc.otd.xsd.datatype.Date2001;
import com.stc.otd.xsd.datatype.DateTime;
import com.stc.otd.xsd.datatype.Duration;
import com.stc.otd.xsd.datatype.GDay;
import com.stc.otd.xsd.datatype.GMonth;
import com.stc.otd.xsd.datatype.GMonthDay;
import com.stc.otd.xsd.datatype.GYear;
import com.stc.otd.xsd.datatype.GYearMonth;
import com.stc.otd.xsd.datatype.Time2001;
import com.stc.otd.xsd.runtime.STValidationException;
import com.stc.otd.xsd.runtime.XsdEnumerationSet;
import com.stc.otd.xsd.runtime.XsdFacets;
import com.stc.otd.xsd.runtime.XsdPatternSet;
import com.stc.otd.xsd.runtime.XsdSTValidator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.xerces.util.XMLChar;

public class XsdSTValidatorImpl
implements XsdSTValidator {
    private static final BigInteger MAX_XSD_LONG = new BigInteger("9223372036854775807");
    private static final BigInteger MIN_XSD_LONG = new BigInteger("-9223372036854775808");
    private static final BigInteger MAX_XSD_UNSIGNEDLONG = new BigInteger("18446744073709551615");
    private static final Long MAX_XSD_INT = new Long("2147483647");
    private static final Long MIN_XSD_INT = new Long("-2147483648");
    private static final BigInteger MAX_XSD_UNSIGNEDINT = new BigInteger("4294967295");
    private static final Integer MAX_XSD_SHORT = new Integer("32767");
    private static final Integer MIN_XSD_SHORT = new Integer("-32768");
    private static final Long MAX_XSD_UNSIGNEDSHORT = new Long("65535");
    private static final Short MAX_XSD_BYTE = new Short("127");
    private static final Short MIN_XSD_BYTE = new Short("-128");
    private static final Integer MAX_XSD_UNSIGNEDBYTE = new Integer("255");
    private String mLastValidatedData;

    public String getLastValidatedValue() {
        return this.mLastValidatedData;
    }

    public Object validate(XsdFacets facets, String data) throws STValidationException {
        if (data == null) {
            data = "";
        }
        Object obj = null;
        if (facets.isUnion()) {
            if (facets.countUnionMembers() > 0) {
                Iterator it = facets.getMemberFacetsIterator();
                boolean passed = false;
                while (it.hasNext()) {
                    try {
                        obj = this.validate((XsdFacets)it.next(), data);
                        passed = true;
                        break;
                    }
                    catch (STValidationException stve) {
                    }
                }
                if (!passed) {
                    throw new STValidationException("None of the union members passed validation.");
                }
            }
            this.validateLocalFacets(facets, data);
        } else {
            obj = facets.isListType() ? this.validateList(facets, data) : this.validateLocalFacets(facets, data);
        }
        return obj;
    }

    private Object validateLocalFacets(XsdFacets facets, String data) throws STValidationException {
        Object obj = null;
        switch (facets.getBuiltInTypeId()) {
            case 0: {
                obj = this.validateAnyType(facets, data);
                break;
            }
            case 1: {
                obj = this.validateString(facets, data);
                break;
            }
            case 2: {
                obj = this.validateBoolean(facets, data);
                break;
            }
            case 3: {
                obj = this.validateDecimal(facets, data);
                break;
            }
            case 4: {
                obj = this.validateFloat(facets, data);
                break;
            }
            case 5: {
                obj = this.validateDouble(facets, data);
                break;
            }
            case 6: {
                obj = this.validateDuration(facets, data);
                break;
            }
            case 7: {
                obj = this.validateDatetime(facets, data);
                break;
            }
            case 8: {
                obj = this.validateTime(facets, data);
                break;
            }
            case 9: {
                obj = this.validateDate(facets, data);
                break;
            }
            case 10: {
                obj = this.validateGYearMonth(facets, data);
                break;
            }
            case 11: {
                obj = this.validateGYear(facets, data);
                break;
            }
            case 12: {
                obj = this.validateGMonthDay(facets, data);
                break;
            }
            case 13: {
                obj = this.validateGDay(facets, data);
                break;
            }
            case 14: {
                obj = this.validateGMonth(facets, data);
                break;
            }
            case 15: {
                obj = this.validateHexBinary(facets, data);
                break;
            }
            case 16: {
                obj = this.validateBase64Binary(facets, data);
                break;
            }
            case 17: {
                obj = this.validateAnyURL(facets, data);
                break;
            }
            case 18: {
                obj = this.validateQName(facets, data);
                break;
            }
            case 19: {
                obj = this.validateNotation(facets, data);
                break;
            }
            case 20: {
                obj = this.validateNormalizedString(facets, data);
                break;
            }
            case 21: {
                obj = this.validateToken(facets, data);
                break;
            }
            case 22: {
                obj = this.validateLanguage(facets, data);
                break;
            }
            case 23: {
                obj = this.validateNMToken(facets, data);
                break;
            }
            case 24: {
                obj = this.validateNMTokens(facets, data);
                break;
            }
            case 25: {
                obj = this.validateName(facets, data);
                break;
            }
            case 26: {
                obj = this.validateNCName(facets, data);
                break;
            }
            case 27: {
                obj = this.validateId(facets, data);
                break;
            }
            case 28: {
                obj = this.validateIdRef(facets, data);
                break;
            }
            case 29: {
                obj = this.validateIdRefs(facets, data);
                break;
            }
            case 30: {
                obj = this.validateEntity(facets, data);
                break;
            }
            case 31: {
                obj = this.validateEntities(facets, data);
                break;
            }
            case 32: {
                obj = this.validateInteger(facets, data);
                break;
            }
            case 33: {
                obj = this.validateNonPositiveInteger(facets, data);
                break;
            }
            case 34: {
                obj = this.validateNegativeInteger(facets, data);
                break;
            }
            case 35: {
                obj = this.validateLong(facets, data);
                break;
            }
            case 36: {
                obj = this.validateInt(facets, data);
                break;
            }
            case 37: {
                obj = this.validateShort(facets, data);
                break;
            }
            case 38: {
                obj = this.validateByte(facets, data);
                break;
            }
            case 39: {
                obj = this.validateNonNegativeInteger(facets, data);
                break;
            }
            case 40: {
                obj = this.validateUnsignedLong(facets, data);
                break;
            }
            case 41: {
                obj = this.validateUnsignedInt(facets, data);
                break;
            }
            case 42: {
                obj = this.validateUnsignedShort(facets, data);
                break;
            }
            case 43: {
                obj = this.validateUnsignedByte(facets, data);
                break;
            }
            case 44: {
                obj = this.validatePositiveInteger(facets, data);
            }
        }
        return obj;
    }

    private BigInteger validatePositiveInteger(XsdFacets facets, String data) throws STValidationException {
        BigInteger value = this.validateInteger(facets, data);
        if (value.signum() <= 0) {
            throw new STValidationException("Integer must be positive");
        }
        return value;
    }

    private Short validateUnsignedByte(XsdFacets facets, String data) throws STValidationException {
        Integer value = this.validateUnsignedShort(facets, data);
        if (value.compareTo(MAX_XSD_UNSIGNEDBYTE) > 0) {
            throw new STValidationException("Invalid unsigned byte, too big");
        }
        return new Short(value.shortValue());
    }

    private Integer validateUnsignedShort(XsdFacets facets, String data) throws STValidationException {
        Long value = this.validateUnsignedInt(facets, data);
        if (value.compareTo(MAX_XSD_UNSIGNEDSHORT) > 0) {
            throw new STValidationException("Invalid unsigned short, too big");
        }
        return new Integer(value.intValue());
    }

    private Long validateUnsignedInt(XsdFacets facets, String data) throws STValidationException {
        BigInteger value = this.validateUnsignedLong(facets, data);
        if (value.compareTo(MAX_XSD_UNSIGNEDINT) > 0) {
            throw new STValidationException("Invalid unsigned int, too big");
        }
        return new Long(value.longValue());
    }

    private BigInteger validateUnsignedLong(XsdFacets facets, String data) throws STValidationException {
        BigInteger value = this.validateNonNegativeInteger(facets, data);
        if (value.compareTo(MAX_XSD_UNSIGNEDLONG) > 0) {
            throw new STValidationException("Invalid unsigned long, too big");
        }
        return value;
    }

    private BigInteger validateNonNegativeInteger(XsdFacets facets, String data) throws STValidationException {
        BigInteger value = this.validateInteger(facets, data);
        if (value.signum() < 0) {
            throw new STValidationException("Integer cannot be negative");
        }
        return value;
    }

    private Byte validateByte(XsdFacets facets, String data) throws STValidationException {
        Short value = this.validateShort(facets, data);
        if (value.compareTo(MAX_XSD_BYTE) > 0) {
            throw new STValidationException("Invalid byte, too big");
        }
        if (value.compareTo(MIN_XSD_BYTE) < 0) {
            throw new STValidationException("Invalid byte, too small");
        }
        return new Byte(value.byteValue());
    }

    private Short validateShort(XsdFacets facets, String data) throws STValidationException {
        Integer value = this.validateInt(facets, data);
        if (value.compareTo(MAX_XSD_SHORT) > 0) {
            throw new STValidationException("Invalid short, too big");
        }
        if (value.compareTo(MIN_XSD_SHORT) < 0) {
            throw new STValidationException("Invalid short, too small");
        }
        return new Short(value.shortValue());
    }

    private Integer validateInt(XsdFacets facets, String data) throws STValidationException {
        Long value = this.validateLong(facets, data);
        if (value.compareTo(MAX_XSD_INT) > 0) {
            throw new STValidationException("Invalid int, too big");
        }
        if (value.compareTo(MIN_XSD_INT) < 0) {
            throw new STValidationException("Invalid int, too small");
        }
        return new Integer(value.intValue());
    }

    private Long validateLong(XsdFacets facets, String data) throws STValidationException {
        BigInteger value = this.validateInteger(facets, data);
        if (value.compareTo(MAX_XSD_LONG) > 0) {
            throw new STValidationException("Invalid long, too big");
        }
        if (value.compareTo(MIN_XSD_LONG) < 0) {
            throw new STValidationException("Invalid long, too small");
        }
        return new Long(value.longValue());
    }

    private BigInteger validateNegativeInteger(XsdFacets facets, String data) throws STValidationException {
        BigInteger value = this.validateInteger(facets, data);
        if (value.signum() >= 0) {
            throw new STValidationException("Integer must be negative");
        }
        return value;
    }

    private BigInteger validateInteger(XsdFacets facets, String data) throws STValidationException {
        BigDecimal value = this.validateDecimal(facets, data);
        if (value.scale() > 0) {
            throw new STValidationException("Integer cannot have fraction digits");
        }
        return value.unscaledValue();
    }

    private BigInteger validateNonPositiveInteger(XsdFacets facets, String data) throws STValidationException {
        BigInteger value = this.validateInteger(facets, data);
        if (value.signum() > 0) {
            throw new STValidationException("Integer cannot be positive");
        }
        return value;
    }

    private String validateEntities(XsdFacets facets, String data) throws STValidationException {
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        String[] value = new String[]{};
        StringTokenizer st = new StringTokenizer(data);
        int num = st.countTokens();
        value = new String[num];
        int i = 0;
        while (st.hasMoreTokens()) {
            String entity = st.nextToken();
            if (!XMLChar.isValidNCName((String)entity)) {
                throw new STValidationException("Invalid ENTITY: " + entity);
            }
            value[i++] = entity;
        }
        if (facets.getLength() != null && data.length() != facets.getLength().intValue()) {
            throw new STValidationException("ENTITIES must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && data.length() > facets.getMaxLength()) {
            throw new STValidationException("ENTITIES must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && data.length() < facets.getMinLength()) {
            throw new STValidationException("ENTITIES String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return data;
    }

    private String validateEntity(XsdFacets facets, String data) throws STValidationException {
        return this.validateNCName(facets, data);
    }

    private String validateIdRefs(XsdFacets facets, String data) throws STValidationException {
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        String value = "";
        StringTokenizer st = new StringTokenizer(data);
        int num = st.countTokens();
        boolean i = false;
        while (st.hasMoreTokens()) {
            String idref = st.nextToken();
            if (!XMLChar.isValidNCName((String)idref)) {
                throw new STValidationException("Invalid ENTITY: " + idref);
            }
            value = value + idref;
            if (!st.hasMoreTokens()) continue;
            value = value + " ";
        }
        if (facets.getLength() != null && value.length() != facets.getLength().intValue()) {
            throw new STValidationException("IDREFS must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && value.length() > facets.getMaxLength()) {
            throw new STValidationException("IDREFS must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && value.length() < facets.getMinLength()) {
            throw new STValidationException("IDREFS String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), value);
        }
        this.mLastValidatedData = value;
        return value;
    }

    private String validateIdRef(XsdFacets facets, String data) throws STValidationException {
        return this.validateNCName(facets, data);
    }

    private String validateId(XsdFacets facets, String data) throws STValidationException {
        return this.validateNCName(facets, data);
    }

    private String validateNCName(XsdFacets facets, String data) throws STValidationException {
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        if (!XMLChar.isValidNCName((String)(data = data.trim()))) {
            throw new STValidationException("Invalid NCName: " + data);
        }
        if (facets.getLength() != null && data.length() != facets.getLength().intValue()) {
            throw new STValidationException("NCName must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && data.length() > facets.getMaxLength()) {
            throw new STValidationException("NCName must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && data.length() < facets.getMinLength()) {
            throw new STValidationException("NCName String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return data;
    }

    private String validateName(XsdFacets facets, String data) throws STValidationException {
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        if (!XMLChar.isValidName((String)(data = data.trim()))) {
            throw new STValidationException("Invalid Name: " + data);
        }
        if (facets.getLength() != null && data.length() != facets.getLength().intValue()) {
            throw new STValidationException("Name must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && data.length() > facets.getMaxLength()) {
            throw new STValidationException("Name must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && data.length() < facets.getMinLength()) {
            throw new STValidationException("Name String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return data;
    }

    private String validateNMTokens(XsdFacets facets, String data) throws STValidationException {
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            String[] value = SchemaRuntime.unmarshalNMTOKENS(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Normalized String: ", ue);
        }
        if (facets.getLength() != null && data.length() != facets.getLength().intValue()) {
            throw new STValidationException("NMTokens String must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && data.length() > facets.getMaxLength()) {
            throw new STValidationException("NMTokens must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && data.length() < facets.getMinLength()) {
            throw new STValidationException("Normalized String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return data;
    }

    private String validateNMToken(XsdFacets facets, String data) throws STValidationException {
        String value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalNMTOKEN(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid NMToken: ", ue);
        }
        if (facets.getLength() != null && value.length() != facets.getLength().intValue()) {
            throw new STValidationException("NMToken must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && value.length() > facets.getMaxLength()) {
            throw new STValidationException("NMToken must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && value.length() < facets.getMinLength()) {
            throw new STValidationException("NMToken String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), value);
        }
        this.mLastValidatedData = value;
        return value;
    }

    private String validateLanguage(XsdFacets facets, String data) throws STValidationException {
        String value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalLanguage(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Language: ", ue);
        }
        if (facets.getLength() != null && value.length() != facets.getLength().intValue()) {
            throw new STValidationException("Language must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && value.length() > facets.getMaxLength()) {
            throw new STValidationException("Language must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && value.length() < facets.getMinLength()) {
            throw new STValidationException("Language must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), value);
        }
        this.mLastValidatedData = value;
        return value;
    }

    private String validateToken(XsdFacets facets, String data) throws STValidationException {
        String value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalToken(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Token: ", ue);
        }
        if (facets.getLength() != null && value.length() != facets.getLength().intValue()) {
            throw new STValidationException("Token must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && value.length() > facets.getMaxLength()) {
            throw new STValidationException("Token must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && value.length() < facets.getMinLength()) {
            throw new STValidationException("Token must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), value);
        }
        this.mLastValidatedData = value;
        return value;
    }

    private String validateNormalizedString(XsdFacets facets, String data) throws STValidationException {
        String value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalNormalizedString(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Normalized String: ", ue);
        }
        if (facets.getLength() != null && value.length() != facets.getLength().intValue()) {
            throw new STValidationException("Normalized String must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && value.length() > facets.getMaxLength()) {
            throw new STValidationException("Normalized String must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && value.length() < facets.getMinLength()) {
            throw new STValidationException("Normalized String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), value);
        }
        this.mLastValidatedData = value;
        return value;
    }

    private String validateNotation(XsdFacets facets, String data) throws STValidationException {
        String value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalNOTATION(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Notation: ", ue);
        }
        if (facets.getLength() != null && value.length() != facets.getLength().intValue()) {
            throw new STValidationException("Notation must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && value.length() > facets.getMaxLength()) {
            throw new STValidationException("notation must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && value.length() < facets.getMinLength()) {
            throw new STValidationException("Notation must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), value);
        }
        this.mLastValidatedData = value;
        return value;
    }

    private String validateQName(XsdFacets facets, String data) throws STValidationException {
        String NCName;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        if (!XMLChar.isValidNCName((String)(NCName = (data = data.trim()).indexOf(58) >= 0 ? data.substring(data.indexOf(58) + 1) : data))) {
            throw new STValidationException("Invalid QName: " + data);
        }
        if (facets.getLength() != null && data.length() != facets.getLength().intValue()) {
            throw new STValidationException("QName must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && data.length() > facets.getMaxLength()) {
            throw new STValidationException("QName must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && data.length() < facets.getMinLength()) {
            throw new STValidationException("QName must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return data;
    }

    private String validateAnyURL(XsdFacets facets, String data) throws STValidationException {
        URI value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = new URI(data);
        }
        catch (NullPointerException npe) {
            throw new STValidationException("Invalid URI: ", npe);
        }
        catch (URISyntaxException use) {
            throw new STValidationException("Invalid URI: ", use);
        }
        if (facets.getLength() != null && value.toASCIIString().length() != facets.getLength().intValue()) {
            throw new STValidationException("Encoded URI must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && value.toASCIIString().length() > facets.getMaxLength()) {
            throw new STValidationException("Encoded URI must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && value.toASCIIString().length() < facets.getMinLength()) {
            throw new STValidationException("Encoded URI must have at least " + facets.getMinLength() + " characters.");
        }
        URI normalized = value.normalize();
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), normalized.toASCIIString());
        }
        this.mLastValidatedData = normalized.toASCIIString();
        return this.mLastValidatedData;
    }

    private byte[] validateBase64Binary(XsdFacets facets, String data) throws STValidationException {
        byte[] value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalBase64Binary(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid base64 binary: ", ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid base64 binary: ", re);
        }
        if (facets.getLength() != null && value.length != facets.getLength()) {
            throw new STValidationException("Base64 binary must have exactly " + facets.getLength() + " bytes.");
        }
        if (facets.getMaxLength() != null && value.length > facets.getMaxLength()) {
            throw new STValidationException("Base64 binary must have no more than " + facets.getMaxLength() + " bytes.");
        }
        if (facets.getMinLength() != null && value.length < facets.getMinLength()) {
            throw new STValidationException("Base64 binary must have at least " + facets.getMinLength() + " bytes.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return value;
    }

    private byte[] validateHexBinary(XsdFacets facets, String data) throws STValidationException {
        byte[] value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalBinary16(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid hex binary: ", ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid hex binary: ", re);
        }
        if (facets.getLength() != null && value.length != facets.getLength()) {
            throw new STValidationException("Hex binary must have exactly " + facets.getLength() + " bytes.");
        }
        if (facets.getMaxLength() != null && value.length > facets.getMaxLength()) {
            throw new STValidationException("Hex binary must have no more than " + facets.getMaxLength() + " bytes.");
        }
        if (facets.getMinLength() != null && value.length < facets.getMinLength()) {
            throw new STValidationException("Hex binary must have at least " + facets.getMinLength() + " bytes.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return value;
    }

    private GMonth validateGMonth(XsdFacets facets, String data) throws STValidationException {
        GMonth value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalGMonth(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid GMonth: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid GMonth: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveGMonth() != null && ((compare = value.compareTo(facets.getMaxExclusiveGMonth())) >= 0 || compare == -2)) {
            throw new STValidationException("GMonth must be less than: " + facets.getMaxExclusiveGMonth());
        }
        if (facets.getMaxInclusiveGMonth() != null && ((compare = value.compareTo(facets.getMaxInclusiveGMonth())) > 0 || compare == -2)) {
            throw new STValidationException("GMonth must be less than or equal to: " + facets.getMaxInclusiveGMonth());
        }
        if (facets.getMinExclusiveGMonth() != null && ((compare = value.compareTo(facets.getMinExclusiveGMonth())) <= 0 || compare == -2)) {
            throw new STValidationException("GMonth must be greater than: " + facets.getMinExclusiveGMonth());
        }
        if (facets.getMinInclusiveGMonth() != null && ((compare = value.compareTo(facets.getMinInclusiveGMonth())) < 0 || compare == -2)) {
            throw new STValidationException("GMonth must be greater than or equal to: " + facets.getMinInclusiveGMonth());
        }
        return value;
    }

    private GDay validateGDay(XsdFacets facets, String data) throws STValidationException {
        GDay value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalGDay(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid GDay: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid GDay: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveGDay() != null && ((compare = value.compareTo(facets.getMaxExclusiveGDay())) >= 0 || compare == -2)) {
            throw new STValidationException("GDay must be less than: " + facets.getMaxExclusiveGDay());
        }
        if (facets.getMaxInclusiveGDay() != null && ((compare = value.compareTo(facets.getMaxInclusiveGDay())) > 0 || compare == -2)) {
            throw new STValidationException("GDay must be less than or equal to: " + facets.getMaxInclusiveGDay());
        }
        if (facets.getMinExclusiveGDay() != null && ((compare = value.compareTo(facets.getMinExclusiveGDay())) <= 0 || compare == -2)) {
            throw new STValidationException("GDay must be greater than: " + facets.getMinExclusiveGDay());
        }
        if (facets.getMinInclusiveGDay() != null && ((compare = value.compareTo(facets.getMinInclusiveGDay())) < 0 || compare == -2)) {
            throw new STValidationException("GDay must be greater than or equal to: " + facets.getMinInclusiveGDay());
        }
        return value;
    }

    private GMonthDay validateGMonthDay(XsdFacets facets, String data) throws STValidationException {
        GMonthDay value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalGMonthDay(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid GMonthDay: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid GMonthDay: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveGMonthDay() != null && ((compare = value.compareTo(facets.getMaxExclusiveGMonthDay())) >= 0 || compare == -2)) {
            throw new STValidationException("GMonthDay must be less than: " + facets.getMaxExclusiveGMonthDay());
        }
        if (facets.getMaxInclusiveGMonthDay() != null && ((compare = value.compareTo(facets.getMaxInclusiveGMonthDay())) > 0 || compare == -2)) {
            throw new STValidationException("GMonthDay must be less than or equal to: " + facets.getMaxInclusiveGMonthDay());
        }
        if (facets.getMinExclusiveGMonthDay() != null && ((compare = value.compareTo(facets.getMinExclusiveGMonthDay())) <= 0 || compare == -2)) {
            throw new STValidationException("GMonthDay must be greater than: " + facets.getMinExclusiveGMonthDay());
        }
        if (facets.getMinInclusiveGMonthDay() != null && ((compare = value.compareTo(facets.getMinInclusiveGMonthDay())) < 0 || compare == -2)) {
            throw new STValidationException("GMonthDay must be greater than or equal to: " + facets.getMinInclusiveGMonthDay());
        }
        return value;
    }

    private GYear validateGYear(XsdFacets facets, String data) throws STValidationException {
        GYear value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalGYear(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid GYear: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid GYear: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveGYear() != null && ((compare = value.compareTo(facets.getMaxExclusiveGYear())) >= 0 || compare == -2)) {
            throw new STValidationException("GYear must be less than: " + facets.getMaxExclusiveGYear());
        }
        if (facets.getMaxInclusiveGYear() != null && ((compare = value.compareTo(facets.getMaxInclusiveGYear())) > 0 || compare == -2)) {
            throw new STValidationException("GYear must be less than or equal to: " + facets.getMaxInclusiveGYear());
        }
        if (facets.getMinExclusiveGYear() != null && ((compare = value.compareTo(facets.getMinExclusiveGYear())) <= 0 || compare == -2)) {
            throw new STValidationException("GYear must be greater than: " + facets.getMinExclusiveGYear());
        }
        if (facets.getMinInclusiveGYear() != null && ((compare = value.compareTo(facets.getMinInclusiveGYear())) < 0 || compare == -2)) {
            throw new STValidationException("GYear must be greater than or equal to: " + facets.getMinInclusiveGYear());
        }
        return value;
    }

    private GYearMonth validateGYearMonth(XsdFacets facets, String data) throws STValidationException {
        GYearMonth value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalGYearMonth(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid GYearMonth: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid GYearMonth: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveGYearMonth() != null && ((compare = value.compareTo(facets.getMaxExclusiveGYearMonth())) >= 0 || compare == -2)) {
            throw new STValidationException("GYearMonth must be less than: " + facets.getMaxExclusiveGYearMonth());
        }
        if (facets.getMaxInclusiveGYearMonth() != null && ((compare = value.compareTo(facets.getMaxInclusiveGYearMonth())) > 0 || compare == -2)) {
            throw new STValidationException("GYearMonth must be less than or equal to: " + facets.getMaxInclusiveGYearMonth());
        }
        if (facets.getMinExclusiveGYearMonth() != null && ((compare = value.compareTo(facets.getMinExclusiveGYearMonth())) <= 0 || compare == -2)) {
            throw new STValidationException("GYearMonth must be greater than: " + facets.getMinExclusiveGYearMonth());
        }
        if (facets.getMinInclusiveGYearMonth() != null && ((compare = value.compareTo(facets.getMinInclusiveGYearMonth())) < 0 || compare == -2)) {
            throw new STValidationException("GYearMonth must be greater than or equal to: " + facets.getMinInclusiveGYearMonth());
        }
        return value;
    }

    private Date2001 validateDate(XsdFacets facets, String data) throws STValidationException {
        Date2001 value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = Date2001.parse(data);
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Date: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid Date: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveDate() != null && ((compare = value.compareTo(facets.getMaxExclusiveDate())) >= 0 || compare == -2)) {
            throw new STValidationException("Date must be less than: " + facets.getMaxExclusiveDate());
        }
        if (facets.getMaxInclusiveDate() != null && ((compare = value.compareTo(facets.getMaxInclusiveDate())) > 0 || compare == -2)) {
            throw new STValidationException("Date must be less than or equal to: " + facets.getMaxInclusiveDate());
        }
        if (facets.getMinExclusiveDate() != null && ((compare = value.compareTo(facets.getMinExclusiveDate())) <= 0 || compare == -2)) {
            throw new STValidationException("Date must be greater than: " + facets.getMinExclusiveDate());
        }
        if (facets.getMinInclusiveDate() != null && ((compare = value.compareTo(facets.getMinInclusiveDate())) < 0 || compare == -2)) {
            throw new STValidationException("Date must be greater than or equal to: " + facets.getMinInclusiveDate());
        }
        return value;
    }

    private Time2001 validateTime(XsdFacets facets, String data) throws STValidationException {
        Time2001 value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalTime2001(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Time: " + data, ue);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveTime() != null && ((compare = value.compareTo(facets.getMaxExclusiveTime())) >= 0 || compare == -2)) {
            throw new STValidationException("Time must be less than: " + facets.getMaxExclusiveTime());
        }
        if (facets.getMaxInclusiveTime() != null && ((compare = value.compareTo(facets.getMaxInclusiveTime())) > 0 || compare == -2)) {
            throw new STValidationException("Time must be less than or equal to: " + facets.getMaxInclusiveTime());
        }
        if (facets.getMinExclusiveTime() != null && ((compare = value.compareTo(facets.getMinExclusiveTime())) <= 0 || compare == -2)) {
            throw new STValidationException("Time must be greater than: " + facets.getMinExclusiveTime());
        }
        if (facets.getMinInclusiveTime() != null && ((compare = value.compareTo(facets.getMinInclusiveTime())) < 0 || compare == -2)) {
            throw new STValidationException("Time must be greater than or equal to: " + facets.getMinInclusiveTime());
        }
        return value;
    }

    private DateTime validateDatetime(XsdFacets facets, String data) throws STValidationException {
        DateTime value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalDateTime(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid DateTime: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid DateTime: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveDateTime() != null && ((compare = value.compareTo(facets.getMaxExclusiveDateTime())) >= 0 || compare == -2)) {
            throw new STValidationException("DateTime must be less than: " + facets.getMaxExclusiveDateTime());
        }
        if (facets.getMaxInclusiveDateTime() != null && ((compare = value.compareTo(facets.getMaxInclusiveDateTime())) > 0 || compare == -2)) {
            throw new STValidationException("DateTime must be less than or equal to: " + facets.getMaxInclusiveDateTime());
        }
        if (facets.getMinExclusiveDateTime() != null && ((compare = value.compareTo(facets.getMinExclusiveDateTime())) <= 0 || compare == -2)) {
            throw new STValidationException("DateTime must be greater than: " + facets.getMinExclusiveDateTime());
        }
        if (facets.getMinInclusiveDateTime() != null && ((compare = value.compareTo(facets.getMinInclusiveDateTime())) < 0 || compare == -2)) {
            throw new STValidationException("DateTime must be greater than or equal to: " + facets.getMinInclusiveDateTime());
        }
        return value;
    }

    private Duration validateDuration(XsdFacets facets, String data) throws STValidationException {
        Duration value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalDuration(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid Duration: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid Duration: " + data, re);
        }
        this.mLastValidatedData = data;
        int compare = -2;
        if (facets.getMaxExclusiveDuration() != null && ((compare = value.compareTo(facets.getMaxExclusiveDuration())) >= 0 || compare == -2)) {
            throw new STValidationException("Duration must be less than: " + facets.getMaxExclusiveDuration());
        }
        if (facets.getMaxInclusiveDuration() != null && ((compare = value.compareTo(facets.getMaxInclusiveDuration())) > 0 || compare == -2)) {
            throw new STValidationException("Duration must be less than or equal to: " + facets.getMaxInclusiveDuration());
        }
        if (facets.getMinExclusiveDuration() != null && ((compare = value.compareTo(facets.getMinExclusiveDuration())) <= 0 || compare == -2)) {
            throw new STValidationException("Duration must be greater than: " + facets.getMinExclusiveDuration());
        }
        if (facets.getMinInclusiveDuration() != null && ((compare = value.compareTo(facets.getMinInclusiveDuration())) < 0 || compare == -2)) {
            throw new STValidationException("Duration must be greater than or equal to: " + facets.getMinInclusiveDuration());
        }
        return value;
    }

    private Double validateDouble(XsdFacets facets, String data) throws STValidationException {
        double value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalDouble(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid double: " + data, ue);
        }
        if (facets.getMaxExclusiveNumber() != null && value >= facets.getMaxExclusiveNumber().doubleValue()) {
            throw new STValidationException("Double must be less than: " + facets.getMaxExclusiveNumber());
        }
        if (facets.getMaxInclusiveNumber() != null && value > facets.getMaxInclusiveNumber().doubleValue()) {
            throw new STValidationException("Double must be less than or equal to: " + facets.getMaxInclusiveNumber());
        }
        if (facets.getMinExclusiveNumber() != null && value <= facets.getMinExclusiveNumber().doubleValue()) {
            throw new STValidationException("Double must be greater than: " + facets.getMinExclusiveNumber());
        }
        if (facets.getMinInclusiveNumber() != null && value < facets.getMinInclusiveNumber().doubleValue()) {
            throw new STValidationException("Double must be greater than or equal to: " + facets.getMinInclusiveNumber());
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return new Double(value);
    }

    private Float validateFloat(XsdFacets facets, String data) throws STValidationException {
        float value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalFloat(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid float: " + data, ue);
        }
        if (facets.getMaxExclusiveNumber() != null && value >= facets.getMaxExclusiveNumber().floatValue()) {
            throw new STValidationException("Float must be less than: " + facets.getMaxExclusiveNumber());
        }
        if (facets.getMaxInclusiveNumber() != null && value > facets.getMaxInclusiveNumber().floatValue()) {
            throw new STValidationException("Float must be less than or equal to: " + facets.getMaxInclusiveNumber());
        }
        if (facets.getMinExclusiveNumber() != null && value <= facets.getMinExclusiveNumber().floatValue()) {
            throw new STValidationException("Float must be greater than: " + facets.getMinExclusiveNumber());
        }
        if (facets.getMinInclusiveNumber() != null && value < facets.getMinInclusiveNumber().floatValue()) {
            throw new STValidationException("Float must be greater than or equal to: " + facets.getMinInclusiveNumber());
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return new Float(value);
    }

    private BigDecimal validateDecimal(XsdFacets facets, String data) throws STValidationException {
        BigDecimal value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalBigDecimal(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid decimal: " + data, ue);
        }
        if (facets.getFractionDigits() != null && value.scale() > facets.getFractionDigits()) {
            if (facets.getBuiltInTypeId() == 3) {
                throw new STValidationException("Total number of digits must be less than (or equal to) " + facets.getTotalDigits());
            }
            throw new STValidationException("Integer value required");
        }
        if (facets.getTotalDigits() != null) {
            int digits = value.scale() > 0 ? (data.charAt(0) != '+' && data.charAt(0) != '-' ? data.length() - 1 : data.length() - 2) : (data.charAt(0) != '+' && data.charAt(0) != '-' ? data.length() : data.length() - 1);
            if (digits > facets.getTotalDigits()) {
                throw new STValidationException("Total number of digits must be less than (or equal to) " + facets.getTotalDigits());
            }
        }
        if (facets.getMaxExclusiveNumber() != null && value.compareTo(facets.getMaxExclusiveNumber()) >= 0) {
            throw new STValidationException("Decimal/Integer/Byte must be less than: " + facets.getMaxExclusiveNumber());
        }
        if (facets.getMaxInclusiveNumber() != null && value.compareTo(facets.getMaxInclusiveNumber()) > 0) {
            throw new STValidationException("Decimal/Integer/Byte must be less than or equal to: " + facets.getMaxInclusiveNumber());
        }
        if (facets.getMinExclusiveNumber() != null && value.compareTo(facets.getMinExclusiveNumber()) <= 0) {
            throw new STValidationException("Decimal/Integer/Byte must be greater than: " + facets.getMinExclusiveNumber());
        }
        if (facets.getMinInclusiveNumber() != null && value.compareTo(facets.getMinInclusiveNumber()) < 0) {
            throw new STValidationException("Decimal/Integer/Byte must be greater than or equal to: " + facets.getMinInclusiveNumber());
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        this.mLastValidatedData = data;
        return value;
    }

    private Boolean validateBoolean(XsdFacets facets, String data) throws STValidationException {
        boolean value;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        data = data.trim();
        try {
            value = SchemaRuntime.unmarshalBoolean(data.toCharArray());
        }
        catch (UnmarshalException ue) {
            throw new STValidationException("Invalid boolean: " + data, ue);
        }
        catch (RuntimeException re) {
            throw new STValidationException("Invalid boolean: " + data, re);
        }
        this.mLastValidatedData = data;
        return value;
    }

    private String validateString(XsdFacets facets, String data) throws STValidationException {
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getLength() != null && data.length() != facets.getLength().intValue()) {
            throw new STValidationException("String must have exactly " + facets.getLength() + " characters.");
        }
        if (facets.getMaxLength() != null && data.length() > facets.getMaxLength()) {
            throw new STValidationException("String must have no more than " + facets.getMaxLength() + " characters.");
        }
        if (facets.getMinLength() != null && data.length() < facets.getMinLength()) {
            throw new STValidationException("String must have at least " + facets.getMinLength() + " characters.");
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        this.mLastValidatedData = data;
        return data;
    }

    private String validateAnyType(XsdFacets facets, String data) throws STValidationException {
        return this.validateString(facets, data);
    }

    private String validateList(XsdFacets facets, String data) throws STValidationException {
        String item;
        int idx;
        if (facets.getWhitespace() != null) {
            data = this.processWhitespace(facets.getWhitespace(), data);
        }
        if (facets.getEnumeration() != null) {
            this.validateEnumeration(facets.getEnumeration(), data);
        }
        if (facets.getPattern() != null) {
            this.validatePattern(facets.getPattern(), data);
        }
        int fromIdx = 0;
        int count = 0;
        while ((idx = data.indexOf(32, fromIdx)) >= 0) {
            ++count;
            item = data.substring(fromIdx, idx);
            this.validate(facets.getBaseItemFacets(), item);
            fromIdx = idx + 1;
        }
        if (fromIdx < data.length()) {
            ++count;
            item = data.substring(fromIdx);
            this.validate(facets.getBaseItemFacets(), item);
        }
        if (facets.getLength() != null && count != facets.getLength()) {
            throw new STValidationException("List must have exactly " + facets.getLength() + " items.");
        }
        if (facets.getMaxLength() != null && count > facets.getMaxLength()) {
            throw new STValidationException("List must have no more than " + facets.getMaxLength() + " items.");
        }
        if (facets.getMinLength() != null && count < facets.getMinLength()) {
            throw new STValidationException("List must have at least " + facets.getMinLength() + " items.");
        }
        return data;
    }

    private void validateEnumeration(XsdEnumerationSet enumSet, String data) throws STValidationException {
        if (!enumSet.hasValue(data)) {
            throw new STValidationException("The data does not match the enumeration values: '" + data + "'");
        }
    }

    private void validatePattern(XsdPatternSet patternSet, String data) throws STValidationException {
        if (!patternSet.matchValue(data)) {
            throw new STValidationException("The data does not match the pattern values: '" + data + "'");
        }
    }

    private String processWhitespace(String mode, String data) {
        if (mode.equals("preserve")) {
            return data;
        }
        if (mode.equals("replace")) {
            return data.replace('\t', ' ').replace('\r', ' ').replace('\n', ' ');
        }
        if (mode.equals("collapse")) {
            String s = data.replace('\t', ' ').replace('\r', ' ').replace('\n', ' ');
            s = s.trim();
            StringTokenizer st = new StringTokenizer(s, " ");
            StringBuffer sBuf = new StringBuffer();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token == null || token.length() <= 0) continue;
                if (sBuf.length() > 0) {
                    sBuf.append(' ');
                }
                sBuf.append(token);
            }
            return sBuf.toString();
        }
        return data;
    }
}

