package antlr;

/* ANTLR Translator Generator
 * Project led by Terence Parr at http://www.jGuru.com
 * Software rights: http://www.antlr.org/RIGHTS.html
 *
 * $Id: ErrorExit.java,v 1.1 2003/04/24 22:18:43 hlin Exp $
 */

/**
 * Interface for handling error reporting and tool exit.
 * The system is expected to exit through quit() or done().
 * Added by SeeBeyond.
 */
public interface ErrorExit
{
    /**
     * Reports a line to the error output.
     *
     * @param text  the error message
     */
    void report (String text);

    /**
     * Quits ANTLR after error.
     */
    void quit ();

    /**
     * Leaves ANTLR after successful completion.
     */
    public void done ();
}
