package antlr;

/* ANTLR Translator Generator
 * Project led by Terence Parr at http://www.jGuru.com
 * Software rights: http://www.antlr.org/RIGHTS.html
 *
 * $Id: ErrorExitEmbed.java,v 1.1 2003/04/24 22:18:43 hlin Exp $
 */

/**
 * Class to implenent error reporting and tool exit for embedded applications:
 * output to System.err, quit through System.exit().
 * Added by SeeBeyond.
 */
public class ErrorExitEmbed implements ErrorExit
{
    public StringBuffer err = null;

    /**
     * Separate class to throw an exception to leave the tool.
     * The text will be composed of all the error messages printed
     * through report().
     */
    public static class AntlrFinalException extends RuntimeException
    {
        public AntlrFinalException (String text)
	{
	    super(text);
	}
    }

    /**
     * Reports a line to the error output.
     *
     * @param text  the error message
     */
    public void report (String text)
    {
	if (err == null)
	    err = new StringBuffer();
	else
	    err.append(System.getProperty("line.separator"));
        err.append(text);
    }

    /**
     * Quits ANTLR.
     */
    public void quit ()
    {
        throw new AntlrFinalException(err == null ? null : err.toString());
    }

    /**
     * Leaves ANTLR after successful completion.
     */
    public void done ()
    {
    }
}
