package antlr;

/* ANTLR Translator Generator
 * Project led by Terence Parr at http://www.jGuru.com
 * Software rights: http://www.antlr.org/RIGHTS.html
 *
 * $Id: ErrorExitToSys.java,v 1.1 2003/04/24 22:18:43 hlin Exp $
 */

/**
 * Class to implenent error reporting and tool exit in the standard
 * ANTLR 2.7.1 fashion: output to System.err, quit through System.exit().
 * The system is expected to exit through quit() or done().
 * Added by SeeBeyond.
 */
public class ErrorExitToSys implements ErrorExit
{
    /**
     * Report a line to the error output.
     *
     * @param text  the error message
     */
    public void report (String text)
    {
        System.err.println(text);
    }

    /**
     * Quit ANTLR after error.
     */
    public void quit ()
    {
        System.exit(1);
    }

    /**
     * Leave ANTLR after successful completion.
     */
    public void done ()
    {
        System.exit(0);
    }
}
