/*
 * Ear.java
 *
 * Created on 2007/12/13, 22:53
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package earupdater;

import java.io.*;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import earupdater.transformer.*;


/**
 *
 * @author Administrator
 */
public class Ear_1 {

    //TODO

    //Dirty判定はC:\temp\test\1197740236545\kyotsu_u002F_04_Technica_21045912\backup_classes
    //C:\temp\test\1197740236545\kyotsu_u002F_04_Technica_21045912\xml_henkoumae
    //直下のフォルダ名=dirtyなJAR名

    private File backup_classesDir;

    private File unearDir;
    private File xml_henkoumaeDir;
    private File ra_xml_henkoumaeDir;

    private File oldjarDir;
    private File oldrarDir;
    private File unjarDir;
    private File unrarDir;
    private File henkokakunoDir;
    private File tempFolder;
    private ArrayList errorCollection = new ArrayList();
    private boolean showtransformationdetaillog;

    private boolean isEJB_JAR_ModificationTarget = true;
    private boolean isSUN_EJB_JAR_ModificationTarget = true;
    private boolean isAPPLICATIONXML_ModificationTarget = true;
    private boolean isMANIFEST_MF_ModificationTarget = false;

    private boolean isRA_ModificationTarget = false;
    private boolean isSUN_RA_ModificationTarget = false;

    private boolean skipAddingWorkflowSerivceClientJAR = false;

    private String workflowservicejarname = "WorkflowServiceClient.jar";

    private String ConnectorResourceQueue;
    private String ConnectorResourceTopic;

    private Set dirtyJogai = new HashSet();




    //private File tenkaisakiDir;

    /** Creates a new instance of Ear */
    public Ear_1() {
    }

    public void setisRA_ModificationTarget(boolean value) {
        this.isRA_ModificationTarget = value;
    }

    public void setisSUN_RA_ModificationTarget(boolean value) {
        this.isSUN_RA_ModificationTarget = value;
    }

    public void setskipAddingWorkflowSerivceClientJAR(boolean value) {
        this.skipAddingWorkflowSerivceClientJAR = value;
    }

    public void setWorkflowServiceJarName(String value) {
        this.workflowservicejarname = value;
    }

    public void setHenkokakunoFolder(File value) {
        this.henkokakunoDir = value;
    }

    public void setisMANIFEST_MF_ModificationTarget(boolean value) {
        this.isMANIFEST_MF_ModificationTarget = value;
    }


    public void setisAPPLICATIONXML_ModificationTarget(boolean value) {
        isAPPLICATIONXML_ModificationTarget = value;
    }

    public void setisEJB_JAR_ModificationTarget(boolean value) {
        isEJB_JAR_ModificationTarget = value;
    }

    public void setisSUN_EJB_JAR_ModificationTarget(boolean value) {
        isSUN_EJB_JAR_ModificationTarget = value;
    }

    public void setShowTransformationDetailLog(boolean value) {
        showtransformationdetaillog = value;
    }

    public void setWorkFlowServiceAsLocalCallPattern() {

            //ローカルコールEJB

            //Application.xmlへEJBエントリの追加が必要
            setisAPPLICATIONXML_ModificationTarget(true);

            //ejb-jar.xmlへローカルEJBリファレンスが必要
            setisEJB_JAR_ModificationTarget(true);

            //ローカルコールに変更したWorkflowServiceClient.jarでEARライブラリを更新する必要あり
            setskipAddingWorkflowSerivceClientJAR(false);


    }

    public boolean success() {
        if (errorCollection.size() == 0) {
            return true;
        } else {
            return false;
        }
    }

    private HashSet getAllDirtyJarFileNames() {
        //親フォルダ検出
        File backup_classes = new File(unearDir.getParent() + File.separator + "backup_classes");
        File xml_henkoumae  = new File(unearDir.getParent() + File.separator + "xml_henkoumae");

        HashSet alldirty = new HashSet();

        if (backup_classes != null) {
            File[] fb2 = backup_classes.listFiles();

            if (fb2 != null) {
                for (int i = 0 ; i < fb2.length; i++) {

                    if (!fb2[i].getName().equalsIgnoreCase("META-INF")) {
                        alldirty.add(fb2[i].getName());
                    }
                }
            }
        }

        if (xml_henkoumae != null) {
            File[] fb3 = xml_henkoumae.listFiles();

            if (fb3 != null) {
                for (int i = 0 ; i < fb3.length; i++) {
                    if (!fb3[i].getName().equalsIgnoreCase("META-INF")) {
                        if (!this.dirtyJogai.contains(fb3[i].getAbsolutePath())) {
                          alldirty.add(fb3[i].getName());
                        }
                    }
                }
            }
        }

        return alldirty;




    }

     private HashSet getAllDirtyRarFileNames() {
        //親フォルダ検出

         //File xml_henkoumae  = new File(unearDir.getParent() + File.separator + "xml_henkoumae");

        HashSet alldirty = new HashSet();

        if (ra_xml_henkoumaeDir != null) {
            File[] fb3 = ra_xml_henkoumaeDir.listFiles();

            if (fb3 != null) {
                for (int i = 0 ; i < fb3.length; i++) {
                    if (!fb3[i].getName().equalsIgnoreCase("META-INF")) {
                        alldirty.add(fb3[i].getName());
                    }
                }
            }
        }

        return alldirty;




    }


    public void zipAllJarsOfUnjarFolder() {
        Zipper mm = new Zipper();

        HashSet alldirtyfiles = getAllDirtyJarFileNames();

        try {


            File[] jarnameDirs = unjarDir.listFiles();
            for (int i = 0 ; i < jarnameDirs.length; i++) {

                //変更の全くないファイルはunjarから復元せずにoldjarからrenameする
                if (alldirtyfiles.contains(jarnameDirs[i].getName())) {

                    File tempzip = new File(this.tempFolder.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    String renameto = mm.zipForDir(jarnameDirs[i], tempzip, false, ".jar");
                    System.out.println("JARファイル : " +  renameto + "の復元が完了しました。");
                    tempzip.renameTo(new File(unearDir.getPath() + File.separator + renameto));

                } else {
                    File unmodifiedJar = new File(oldjarDir.getAbsolutePath() + File.separator + jarnameDirs[i].getName() + ".jar");
                    unmodifiedJar.renameTo(new File(unearDir.getPath() + File.separator + unmodifiedJar.getName()));
                    System.out.println("変更のないJARファイル:" + unmodifiedJar.getName() + "はそのままバックアップから戻します。" );
                }

            }

        } catch (Exception e) {
            e.printStackTrace();
            errorCollection.add(e.getMessage());
        }
    }

    public void zipAllRarsOfUnrarFolder() {
        Zipper mm = new Zipper();

        HashSet alldirtyfiles = getAllDirtyRarFileNames();

        try {


            File[] rarnameDirs = unrarDir.listFiles();
            for (int i = 0 ; i < rarnameDirs.length; i++) {

                //変更の全くないファイルはunrarから復元せずにoldrarからrenameする
                if (alldirtyfiles.contains(rarnameDirs[i].getName())) {

                    File tempzip = new File(this.tempFolder.getAbsolutePath() + File.separator + System.currentTimeMillis());
                    String renameto = mm.zipForDir(rarnameDirs[i], tempzip, false, ".rar");
                    System.out.println("RARファイル : " +  renameto + "の復元が完了しました。");
                    tempzip.renameTo(new File(unearDir.getPath() + File.separator + renameto));

                } else {
                    File unmodifiedRar = new File(oldrarDir.getAbsolutePath() + File.separator + rarnameDirs[i].getName() + ".rar");
                    unmodifiedRar.renameTo(new File(unearDir.getPath() + File.separator + unmodifiedRar.getName()));
                    System.out.println("変更のないRARファイル:" + unmodifiedRar.getName() + "はそのままバックアップから戻します。" );
                }

            }

        } catch (Exception e) {
            e.printStackTrace();
            errorCollection.add(e.getMessage());
        }
    }

    public void zipEar() {

        Zipper mm = new Zipper();

        try {


            File tempzip = new File(this.tempFolder.getAbsolutePath() + File.separator + System.currentTimeMillis());
            mm.zipForDir(unearDir, tempzip, true, ".ear");
            String renameto = unearDir.getParentFile().getName() + ".ear";
            System.out.println("EARファイル : " +  renameto + "の復元が完了しました。");
            tempzip.renameTo(new File(this.tempFolder + File.separator + renameto));



        } catch (Exception e) {
            e.printStackTrace();
            errorCollection.add(e.getMessage());
        }

    }


    public void processEar(File targetEar, File tempfolder, File henkokakunouFolder) throws Exception {

        if (!targetEar.exists()) {
            throw new Exception("ターゲットのEARが見つかりませんでした。");
        }

        if (!tempfolder.exists()) {
            throw new Exception("展開先のテンポラリフォルダが存在しないか見つかりません。");
        }

        if (!tempfolder.isDirectory()) {
            throw new Exception("展開先にディレクトリ以外が指定されています。");
        }

        this.tempFolder = tempfolder;

        File tenkaisakiDir = new File(tempfolder.getAbsolutePath() + File.separator +  this.getPureName(targetEar.getName(), ".EAR") + File.separator + "unear" + File.separator);
        tenkaisakiDir.mkdirs();
        unearDir = tenkaisakiDir;

        //変更対象XMLの変更前バックアップディレクトリ
        File oldxmldir = new File(tenkaisakiDir.getParent() + File.separator + "xml_henkoumae" + File.separator);
        xml_henkoumaeDir = oldxmldir;

        //RAR変更対象XMLの変更前バックアップディレクトリ
        File oldrarxmldir = new File(tenkaisakiDir.getParent() + File.separator + "ra_xml_henkoumae" + File.separator);
        ra_xml_henkoumaeDir = oldrarxmldir;

        System.out.println("展開完了したJARの移動先フォルダを作成します。");
        File oldjardir = new File(tenkaisakiDir.getParent() + File.separator + "oldjar" + File.separator);
        oldjardir.mkdirs();
        this.oldjarDir = oldjardir;

        System.out.println("展開完了したRARの移動先フォルダを作成します。");
        File oldrardir = new File(tenkaisakiDir.getParent() + File.separator + "oldrar" + File.separator);
        oldrardir.mkdirs();
        this.oldrarDir = oldrardir;

        System.out.println(tenkaisakiDir.getAbsolutePath() + "へEARファイル(" + targetEar.getName() + ")を展開します・・・");
        processZipFile(targetEar, tenkaisakiDir);
        System.out.println("EARファイルの展開が完了しました。");

        if (isAPPLICATIONXML_ModificationTarget) {

            System.out.println("application.xmlの更新をしています・・・");
            //application.xmlのファイル
            File applicationxml = new File(tenkaisakiDir.getAbsolutePath() + File.separator + "META-INF" + File.separator + "application.xml");

            //オリジナルapplication.xmlのフルパスを保存（後でここに書き戻すので）
            String applicationxml_fullpath = applicationxml.getAbsolutePath();

            //application.xmlのバックアップ先
            File old_applicationxml = new File(oldxmldir.getAbsolutePath() + File.separator + "META-INF" + File.separator + "application.xml");
            old_applicationxml.getParentFile().mkdirs();

            applicationxml.renameTo(old_applicationxml);

            File newapplicationxml = new File(applicationxml_fullpath);
            processApplication_xml(old_applicationxml, newapplicationxml);
            System.out.println("application.xmlの更新が完了しました。");

        }



        System.out.println("EARファイル内のJARファイルを展開します。");





        processJarDir(tenkaisakiDir);
        System.out.println("JARファイルの展開が完了しました。");

        //unjarディレクトリ特定
        File unjardir = new File(tenkaisakiDir.getParent() + File.separator + "unjar" + File.separator);
        if (!unjardir.exists()) {
            unjardir.mkdirs();
        }
        this.unjarDir = unjardir;

        //unrarディレクトリ特定
        File unrardir = new File(tenkaisakiDir.getParent() + File.separator + "unrar" + File.separator);
        if (!unrardir.exists()) {
            unrardir.mkdirs();
        }
        this.unrarDir = unrardir;



        System.out.println("JARファイル中の配備記述子を書き換え処理しています・・・");
        processUnJarDir(unjardir, oldxmldir);
        System.out.println("JARファイル中の配備記述子の書き換え処理が完了しました。");

        System.out.println("RARファイル中の配備記述子を書き換え処理しています・・・");
        processUnRarDir(unrardir, oldrarxmldir);
        System.out.println("RARファイル中の配備記述子の書き換え処理が完了しました。");


        //変更元ディレクトリに入っている.classファイルをunjarフォルダ配下の、そのクラスファイルを持っているJARディレクトリ下の.classファイルと置き換える
        //置き換え処理した.classファイルはどのJARのどのclassを置き換えたかをログに詳細に出力する
        File fromClassesDir = new File(henkokakunouFolder.getAbsolutePath() + File.separator + "classes");
        if (!fromClassesDir.exists()) {
            fromClassesDir.mkdirs();
        }
        updateClassFiles(fromClassesDir, unjardir, fromClassesDir);

        return;


    }

    public void copyLibraryJar(File henkokakunouFolder)  {

        //変更元フォルダに入っていてかつ、.jar拡張子がついているやつをこぴー
        File[] childf = henkokakunouFolder.listFiles();

        for (int i = 0 ; i < childf.length; i++) {

            String libname = childf[i].getName();
            if (libname.toUpperCase().endsWith(".JAR") && canThisLibraryImport(libname)) {



                //WorkflowService.jarをライブラリにいれます→tenkaisakiDir
                //File workflowservicejar = new File(henkokakunouFolder.getAbsolutePath() + File.separator + "workflowservice.jar");
                //File Toworkflowservice = new File(unearDir.getAbsolutePath() + File.separator + "workflowservice.jar");
                File Toworkflowservice = new File(unearDir.getAbsolutePath() + File.separator + childf[i].getName());

                //変更元に入ってるときだけ処理
                //if (workflowservicejar.exists()) {
                System.out.println(Toworkflowservice.getAbsolutePath());
                try {
                    if (!Toworkflowservice.exists()) {
                        copy(childf[i], Toworkflowservice);
                    } else {
                        //既に同名のライブラリが存在する場合はhenkokakunouFolderへオリジナル名+old+タイムスタンプ
                        System.out.println(childf[i].getName() + "は既にEARに存在しているので上書きします。");
                        File backupold = new File(henkokakunouFolder.getAbsolutePath() + File.separator + childf[i].getName()+"_old_" + System.currentTimeMillis());
                        Toworkflowservice.renameTo(backupold);
                        File newtarget = new File(unearDir.getAbsolutePath() + File.separator + childf[i].getName());
                        copy(childf[i], newtarget);
                        System.out.println("古いJARは" + backupold.getAbsolutePath() + "に移動しました。");
                    }
                } catch (Exception copye) {
                    errorCollection.add(copye.getMessage());
                }
                System.out.println("EARファイルへの" + Toworkflowservice.getName() + "の追加が完了しました。");


            }
        }
    }

    private boolean canThisLibraryImport(String libraryname) {
        if (!libraryname.equals(workflowservicejarname)) {
            return true;
        } else {
            //ライブラリがWorkflowServiceClientの場合
            if (skipAddingWorkflowSerivceClientJAR) {
                return false;
            } else {
                return true;
            }
        }
    }

    private void processJarDir(File file) {
        File dirfiles[] = file.listFiles();
        for(int i = 0; i < dirfiles.length; i++) {
        if(dirfiles[i].isFile() && dirfiles[i].getName().toUpperCase().indexOf(".JAR") != -1) {
                //JARを見つけたら同名（拡張子なし）のフォルダをそこに作成
                File jarfolder = new File(dirfiles[i].getParentFile().getParent() + File.separator +  "unjar"  + File.separator + this.getPureName(dirfiles[i].getName(), ".JAR") + File.separator);
                jarfolder.mkdirs();

                processZipFile(dirfiles[i], jarfolder);

                //JARファイルをoldフォルダに移動する

                File Roldjar = new File(dirfiles[i].getParentFile().getParent() + File.separator +  "oldjar"  + File.separator + dirfiles[i].getName());
                System.out.println("展開を終了したJARをoldフォルダに移動します:" + Roldjar.getAbsolutePath());

                if (!Roldjar.exists()) {
                    dirfiles[i].renameTo(Roldjar);
                } else {
                    File alternativepath = new File(dirfiles[i].getParentFile().getParent() + File.separator +  "oldjar"  + File.separator + System.currentTimeMillis());
                    dirfiles[i].renameTo(alternativepath);
                }


            } else
            if(dirfiles[i].isFile() && dirfiles[i].getName().toUpperCase().indexOf(".RAR") != -1) {
                //JARを見つけたら同名（拡張子なし）のフォルダをそこに作成
                File jarfolder = new File(dirfiles[i].getParentFile().getParent() + File.separator +  "unrar"  + File.separator + this.getPureName(dirfiles[i].getName(), ".RAR") + File.separator);
                jarfolder.mkdirs();

                processZipFile(dirfiles[i], jarfolder);

                //JARファイルをoldフォルダに移動する

                File Roldjar = new File(dirfiles[i].getParentFile().getParent() + File.separator +  "oldrar"  + File.separator + dirfiles[i].getName());
                System.out.println("展開を終了したRARをoldフォルダに移動します:" + Roldjar.getAbsolutePath());

                if (!Roldjar.exists()) {
                    dirfiles[i].renameTo(Roldjar);
                } else {
                    File alternativepath = new File(dirfiles[i].getParentFile().getParent() + File.separator +  "oldjar"  + File.separator + System.currentTimeMillis());
                    dirfiles[i].renameTo(alternativepath);
                }

            } else
            if(dirfiles[i].isDirectory()) {
                processJarDir(dirfiles[i]);
            }
        }
    }

    private String getPureName(String original, String uppercaseExtension) {
        int index = original.toUpperCase().indexOf(uppercaseExtension);
        if (index != -1) {
            return original.substring(0, index);
        } else {
            return original;
        }
    }

    private void processZipFile(File file, File tenkaisakiDir) {
        try {
            ZipFile zip = new ZipFile(file);
            for(Enumeration ezip = zip.entries(); ezip.hasMoreElements();) {
                Object ent = ezip.nextElement();
                ZipEntry ze = (ZipEntry)ent;
                String originalzipentry = ze.getName();
                //System.out.println(fileSeparatorOkikae(originalzipentry));
                //System.out.println(file.getParent() + File.separator + fileSeparatorOkikae(originalzipentry));
                String targetfilename = tenkaisakiDir.getAbsolutePath() + File.separator + fileSeparatorOkikae(originalzipentry);

                File targetfile = new File(targetfilename);
                //System.out.println("ターゲットのパス:" + targetfile.getPath());

                //ターゲットファイルがディレクトリだったら自分自身をmkdir
                if (ze.isDirectory()) {
                    targetfile.mkdirs();
                } else {
                    //それ以外なら親ディレクトリを作成
                    targetfile.getParentFile().mkdirs();


                    //File tfile = new File(targetdir.getPath() + File.separator + ze.getName());
                    BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(ze));
                    BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(targetfile));
                    int j;
                    while((j = bis.read()) != -1) {
                        bo.write(j);
                    }
                    bis.close();
                    bo.close();

                }



            }

            zip.close();

        } catch (Exception zipe) {
            zipe.printStackTrace();
            errorCollection.add(zipe.getMessage());
        }


    }

    private String fileSeparatorOkikae(String original) {
        char[] input = original.toCharArray();
        StringBuffer result = new StringBuffer();
        for (int i = 0 ; i < input.length; i++) {
            if(input[i] == '/') {
                result.append(File.separatorChar);
            } else {
                result.append(input[i]);
            }
        }

        return result.toString();
    }

    private String extractJARName(String fullpath) {
        if (fullpath == null) {
            return "";
        }

        StringTokenizer st = new StringTokenizer(fullpath, File.separator);
        int count = -1;
        int found = -1;
        ArrayList array = new ArrayList();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            count++;
            array.add(token);

            if (token.equals("classes")) {
                found = count + 1;
            }

        }

        if (found == -1) {
            return "notfound";
        } else {
            return (String)array.get(found);
        }



    }

    private void updateClassFiles(File fromDir, File unjarDir, File rootDir) {

        //fromDirをスキャンする。拡張子が.classのものを全部抽出。HashSetにいれる
        HashSet fromClassFullPaths = new HashSet();
        File dirfiles[] = fromDir.listFiles();
        for(int i = 0; i < dirfiles.length; i++) {
            if(dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(".CLASS")) {
                //.classファイル発見
                fromClassFullPaths.add(dirfiles[i].getAbsolutePath());


            } else
                if(dirfiles[i].isDirectory()) {
                updateClassFiles(dirfiles[i], unjarDir, rootDir);
                }

        }

        //unjarDirをスキャンして変更すべきクラスとマッチする場合は
        //変更元ネタDIRから、unjarDir配下へコピーする。
        //コピー前には、変更するクラスをbackup_classesへ入れる

        if (!fromClassFullPaths.isEmpty()) {
            matchClassesAndCopy(unjarDir, fromClassFullPaths, rootDir);
        }



    }

    private String convertDotedName(String input) {
        if (input == null)
            return null;

        char[] chars = input.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0 ; i < chars.length; i++) {
            if (chars[i] == '\\') {
                sb.append('.');
            } else {
                sb.append(chars[i]);
            }
        }

        return sb.toString();
    }


     private boolean matchJarFolderName(File input, HashSet moto) {
          boolean result = false;
          Iterator imoto = moto.iterator();

          while (imoto.hasNext()) {
              String moto_fullpath = (String) imoto.next();
              //System.out.println("フォルダ名：" + input.getName() + " Jarname:" + this.extractJARName(moto_fullpath));
              if (this.extractJARName(moto_fullpath).equals(input.getName())) {
                  result = true;
              }
          }

          return result;
     }

     private void matchClassesAndCopy(File unjarDir, HashSet fromClassFullPaths, File rootDir) {

        //バックアップディレクトリ親
        backup_classesDir = new File(unjarDir.getParent() + File.separator + "backup_classes" + File.separator);
        backup_classesDir.mkdirs();

        //対象のJARのみ処理する（あとでもっとスマートに書き換える）
        File dirfiles[] = unjarDir.listFiles();
        for(int i = 0; i < dirfiles.length; i++) {

              if(dirfiles[i].isDirectory() && matchJarFolderName(dirfiles[i], fromClassFullPaths)) {
                System.out.println("更新対象のJARを見つけました：Jar名は" + dirfiles[i].getName());
                processSubUnjarDir(dirfiles[i], fromClassFullPaths, rootDir, dirfiles[i]);
                //単純に、fromClassFullPathsにあるファイル全部をhenkosaki_jar_rootにコピーする
                Iterator ifcfp = fromClassFullPaths.iterator();
                while (ifcfp.hasNext()) {
                    String copyfromFilePath = (String)ifcfp.next();

                    //コピー元のJAR名と今処理しているフォルダ名（JARの名前のついたフォルダ）が一致したときにコピーする
                    if (extractJARName(copyfromFilePath).equals(dirfiles[i].getName())) {


                        //コピー先名作成
                        String copyTargetPath = dirfiles[i].getAbsolutePath() + File.separator + getPureFullClassName(copyfromFilePath, rootDir);
                        //System.out.println("コピー予定フルパス：" + copyTargetPath);
                        File cfrom = new File(copyfromFilePath);
                        File cTo   = new File(copyTargetPath);
                        cTo.getParentFile().mkdirs();
                        try {
                            if (!cTo.exists()) {
                                copy(cfrom, cTo);
                            }
                        } catch (Exception copyE) {
                            System.out.println(copyfromFilePath + "　から　" + copyTargetPath + "へのコピーに失敗しました。");
                            copyE.printStackTrace();
                            errorCollection.add(copyE.getMessage());
                        }
                        System.out.println("コピー完了しました：" + copyfromFilePath + "　から　" + copyTargetPath);
                    }
                }
            }

        }

    }

    private void processSubUnjarDir(File unjarDir, HashSet fromClassFullPaths, File motoneta_rootDir, File henkosaki_jar_root) {

        File dirfiles[] = unjarDir.listFiles();
        for(int i = 0; i < dirfiles.length; i++) {
            if(dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(".CLASS")) {
                //.classファイル発見
                //変更対象かどうかチェック（既存かつ変更対象のものはそのままだと上書きになるのでバックアップへ退避

                //変更先ファイルのフルクラス名取得
                String henkoumotofullclassname = getPureFullClassName(dirfiles[i].getAbsolutePath(), henkosaki_jar_root);
                //System.out.println("変更先ファイルのフルクラス名：" + henkoumotofullclassname);

                //元ネタに同様のpathがあるかどうかをチェック
                //比較用キー作成
                String hikakukey = motoneta_rootDir + File.separator + henkosaki_jar_root.getName() + File.separator + henkoumotofullclassname;
                //System.out.println("比較キー:" + hikakukey);

                //マッチ
                if (fromClassFullPaths.contains(hikakukey)) {
                    //backup_classesフォルダへ変更前オリジナルファイルを退避
                    File backupto = new File(backup_classesDir.getAbsoluteFile() + File.separator + henkosaki_jar_root.getName() + File.separator + henkoumotofullclassname);
                    backupto.getParentFile().mkdirs();
                    System.out.println("classファイルを更新する前に" + dirfiles[i].getAbsolutePath() + "を" + backupto.getAbsolutePath() + "へバックアップします。");

                    if (!backupto.exists()) {
                        dirfiles[i].renameTo(backupto);
                    } else {

                        File alternativepath = new File(backup_classesDir.getAbsoluteFile() + File.separator + henkosaki_jar_root.getName() + File.separator + System.currentTimeMillis());
                        dirfiles[i].renameTo(alternativepath);

                    }
                }



            } else
                if(dirfiles[i].isDirectory()) {
                processSubUnjarDir(dirfiles[i], fromClassFullPaths, motoneta_rootDir, henkosaki_jar_root);
                }

        }



    }

    private String getPureFullClassName(String original, File fromDir) {
        //fromDirのパスをのぞいた、packagename\\classだけがのこるようにする
        String fromDirPath =  fromDir.getAbsolutePath();
        //System.out.println("fromDirPath:" + fromDirPath);
        //System.out.println("original   :" + original);
        int index = original.indexOf(fromDirPath);
        if (index != -1) {
            return original.substring(index + fromDirPath.length() + 1);
        } else {
            return original;
        }
    }

    private void processUnJarDir(File file, File backupdir) {
        File dirfiles[] = file.listFiles();
        for(int i = 0; i < dirfiles.length; i++) {

            //if (!dirfiles[i].getParentFile().getParentFile().getName().equalsIgnoreCase("WorkflowServiceClient")) {
            if (!dirfiles[i].getParentFile().getParentFile().getName().equalsIgnoreCase(this.getPureName(workflowservicejarname,".JAR"))) {


                if(isEJB_JAR_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "EJB-JAR.XML")) {
                    //このFileパスを保存しておく
                    String fullpath = dirfiles[i].getAbsolutePath();
                    Stack stack = new Stack();

                    File ufile = dirfiles[i];

                    while (!ufile.getName().equals("unjar")) {

                        stack.push(ufile.getName());
                        ufile = ufile.getParentFile();

                    }

                    StringBuffer relativepath = new StringBuffer();

                    while (!stack.isEmpty()) {
                        String key = (String)stack.pop();
                        //System.out.println("key:" + key);
                        relativepath.append(File.separator);
                        relativepath.append(key);
                    }

                    //変更前のXMLをバックアップするフルパス
                    //System.out.println(backupdir.getAbsolutePath() + relativepath);
                    File backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                    backuppath.getParentFile().mkdirs();

                    if (!backuppath.exists()) {
                        dirfiles[i].renameTo(backuppath);
                    } else {
                        //ユニークな名前にして捨て
                        File alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                        dirfiles[i].renameTo(alternativepath);
                    }

                    //リネームしたファイルを読み込んで変更後、fullpathに書き戻す。
                    File outputfile = new File(fullpath);
                    System.out.println("ejb-jar.xmlの書き換えをしています:" + outputfile.getAbsolutePath());


                    try {
                        this.processEJB_JAR(backuppath, outputfile);
                    } catch (Exception ie) {
                        ie.printStackTrace();
                        System.err.println("EJB-JARの処理中に例外が発生しました:" + backuppath.getAbsolutePath());
                        errorCollection.add(ie.getMessage());
                    }




                } else

                    if(isSUN_EJB_JAR_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "SUN-EJB-JAR.XML")) {
                    //このFileパスを保存しておく
                    String fullpath = dirfiles[i].getAbsolutePath();
                    Stack stack = new Stack();

                    File ufile = dirfiles[i];

                    while (!ufile.getName().equals("unjar")) {

                        stack.push(ufile.getName());
                        ufile = ufile.getParentFile();

                    }

                    StringBuffer relativepath = new StringBuffer();

                    while (!stack.isEmpty()) {
                        String key = (String)stack.pop();
                        //System.out.println("key:" + key);
                        relativepath.append(File.separator);
                        relativepath.append(key);
                    }

                    //変更前のXMLをバックアップするフルパス

                    File backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                    backuppath.getParentFile().mkdirs();

                    if (!backuppath.exists()) {
                        dirfiles[i].renameTo(backuppath);
                    } else {
                        File alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                        dirfiles[i].renameTo(alternativepath);
                    }

                    //リネームしたファイルを読み込んで変更後、fullpathに書き戻す。
                    File outputfile = new File(fullpath);
                    System.out.println("sun-ejb-jar.xmlの書き換えをしています:" + outputfile.getAbsolutePath());

                    boolean modified = false;

                    try {
                        modified = this.processSUN_EJB_JAR(backuppath, outputfile);
                    } catch (Exception ie) {
                        ie.printStackTrace();
                        System.err.println("EJB-JARの処理中に例外が発生しました:" + backuppath.getAbsolutePath());
                        errorCollection.add(ie.getMessage());
                    }

                    if (modified) {
                    System.out.println("sun-ejb-jar.xmlの処理完了。オリジナルは" + backupdir.getAbsolutePath() + relativepath + "にバックアップされました。");
                    } else {
                        System.out.println("sun-ejb-jar.xmlには変更すべき内容が含まれていませんでした。更新をスキップしました。");
                    }



                    } else
                        if(isMANIFEST_MF_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "MANIFEST.MF")) {
                    //このFileパスを保存しておく
                    String fullpath = dirfiles[i].getAbsolutePath();
                    Stack stack = new Stack();

                    File ufile = dirfiles[i];

                    while (!ufile.getName().equals("unjar")) {

                        stack.push(ufile.getName());
                        ufile = ufile.getParentFile();

                    }

                    StringBuffer relativepath = new StringBuffer();

                    while (!stack.isEmpty()) {
                        String key = (String)stack.pop();
                        //System.out.println("key:" + key);
                        relativepath.append(File.separator);
                        relativepath.append(key);
                    }

                    //変更前のXMLをバックアップするフルパス

                    File backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                    backuppath.getParentFile().mkdirs();

                    if (!backuppath.exists()) {
                        dirfiles[i].renameTo(backuppath);
                    } else {
                        File alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                        dirfiles[i].renameTo(alternativepath);
                    }

                    //リネームしたファイルを読み込んで変更後、fullpathに書き戻す。
                    File outputfile = new File(fullpath);
                    System.out.println("MANIFEST.MFの書き換えをしています:" + outputfile.getAbsolutePath());


                    File manifest_motoneta = new File(this.henkokakunoDir.getAbsolutePath() + File.separator + "MANIFEST.MF");
                    if (manifest_motoneta.exists()) {

                        try {
                            this.copy(manifest_motoneta, outputfile);
                        } catch (Exception ie) {
                            ie.printStackTrace();
                            System.err.println("MANIFEST.MFのコピー中に例外が発生しました:" + backuppath.getAbsolutePath());
                            errorCollection.add(ie.getMessage());
                        }

                    }


                    System.out.println("MANIFEST.MFのコピー完了。オリジナルは" + backupdir.getAbsolutePath() + relativepath + "にバックアップされました。");



                        } else
                            if(dirfiles[i].isDirectory()) {
                    processUnJarDir(dirfiles[i], backupdir);
                            }
            }

        }

    }



    void processEJB_JAR(File inputfile, File outputfile) throws Exception {

        earupdater.transformer.Ejb_Jar ejb_jar = new earupdater.transformer.Ejb_Jar(inputfile);
        ejb_jar.setShowTransformationDetailLog(showtransformationdetaillog);
        System.out.println(ejb_jar.showChangingPoint());
        ejb_jar.transformAndSave(outputfile);
        return;
    }

    void processRA(File inputfile) throws Exception {

        earupdater.transformer.Ra ra = new earupdater.transformer.Ra(inputfile);
        ra.setShowTransformationDetailLog(showtransformationdetaillog);
        ra.transform();
        return;
    }

    boolean processSUN_EJB_JAR(File inputfile, File outputfile) throws Exception {


        earupdater.transformer.Sun_Ejb_Jar sun_ejb_jar = new earupdater.transformer.Sun_Ejb_Jar(inputfile);
        sun_ejb_jar.setShowTransformationDetailLog(showtransformationdetaillog);
        System.out.println(sun_ejb_jar.showChangingPoint());
        sun_ejb_jar.setConnectorResourceQueue(this.ConnectorResourceQueue);
        sun_ejb_jar.setConnectorResourceTopic(this.ConnectorResourceTopic);
        sun_ejb_jar.transformAndSave(outputfile);

        if (!sun_ejb_jar.isModified()) {

             System.out.println("** " + inputfile.getParentFile().getParent());
             this.dirtyJogai.add(inputfile.getParentFile().getParent());
        }

        return sun_ejb_jar.isModified();
    }

    void processApplication_xml(File inputfile, File outputfile) throws Exception {


        earupdater.transformer.Application applicationxml = new earupdater.transformer.Application(inputfile);
        applicationxml.setShowTransformationDetailLog(showtransformationdetaillog);
        applicationxml.setWorkflowservicename(workflowservicejarname);
        System.out.println(applicationxml.showChangingPoint());
        applicationxml.transformAndSave(outputfile);


        return;
    }

        void processSUN_RAR(File inputfile, File outputfile) throws Exception {


        DDTransformer sun_rar = new Sun_RAR(inputfile);
        sun_rar.setShowTransformationDetailLog(showtransformationdetaillog);
        System.out.println(sun_rar.showChangingPoint());
        sun_rar.transformAndSave(outputfile);


        return;
    }

    public void copy(File from, File to) throws IOException {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(from));
            out = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buff = new byte[4096];
            int len = 0;
            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                out.write(buff, 0, len);
            }
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    errorCollection.add(e.getMessage());
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    errorCollection.add(e.getMessage());
                }
            }
        }
    }

    private void processUnRarDir(File file, File backupdir) {
        File dirfiles[] = file.listFiles();
        for(int i = 0; i < dirfiles.length; i++) {


                if(isRA_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "RA.XML")) {
                    //このFileパスを保存しておく
                    String fullpath = dirfiles[i].getAbsolutePath();
                    Stack stack = new Stack();

                    File ufile = dirfiles[i];

                    while (!ufile.getName().equals("unrar")) {

                        stack.push(ufile.getName());
                        ufile = ufile.getParentFile();

                    }

                    StringBuffer relativepath = new StringBuffer();

                    while (!stack.isEmpty()) {
                        String key = (String)stack.pop();
                        //System.out.println("key:" + key);
                        relativepath.append(File.separator);
                        relativepath.append(key);
                    }

                    //変更前のXMLをバックアップするフルパス
                    //System.out.println(backupdir.getAbsolutePath() + relativepath);
                    File backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                    backuppath.getParentFile().mkdirs();

                    if (!backuppath.exists()) {
                        dirfiles[i].renameTo(backuppath);
                    } else {
                        //ユニークな名前にして捨て
                        File alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                        dirfiles[i].renameTo(alternativepath);
                    }

                    //リネームしたファイルを読み込んで変更後、fullpathに書き戻す。
                    File outputfile = new File(fullpath);
                    System.out.println("ra.xmlの書き換えをしています:" + outputfile.getAbsolutePath());


                    try {
                        this.processRA(backuppath);
                    } catch (Exception ie) {
                        ie.printStackTrace();
                        System.err.println("RA.XMLの処理中に例外が発生しました:" + backuppath.getAbsolutePath());
                        errorCollection.add(ie.getMessage());
                    }





                } else

                    if(isSUN_RA_ModificationTarget && dirfiles[i].isFile() && dirfiles[i].getAbsolutePath().toUpperCase().endsWith(File.separator + "SUN-RA.XML")) {
                    //このFileパスを保存しておく
                    String fullpath = dirfiles[i].getAbsolutePath();
                    Stack stack = new Stack();

                    File ufile = dirfiles[i];

                    while (!ufile.getName().equals("unrar")) {

                        stack.push(ufile.getName());
                        ufile = ufile.getParentFile();

                    }

                    StringBuffer relativepath = new StringBuffer();

                    while (!stack.isEmpty()) {
                        String key = (String)stack.pop();
                        //System.out.println("key:" + key);
                        relativepath.append(File.separator);
                        relativepath.append(key);
                    }

                    //変更前のXMLをバックアップするフルパス

                    File backuppath = new File(backupdir.getAbsolutePath() + relativepath);
                    backuppath.getParentFile().mkdirs();

                    if (!backuppath.exists()) {
                        dirfiles[i].renameTo(backuppath);
                    } else {
                        File alternativepath = new File(backupdir.getAbsolutePath() + File.separator + System.currentTimeMillis());
                        dirfiles[i].renameTo(alternativepath);
                    }

                    //リネームしたファイルを読み込んで変更後、fullpathに書き戻す。
                    File outputfile = new File(fullpath);
                    System.out.println("sun-ra.xmlの書き換えをしています:" + outputfile.getAbsolutePath());


                    try {
                        this.processSUN_RAR(backuppath, outputfile);
                    } catch (Exception ie) {
                        ie.printStackTrace();
                        System.err.println("SUN-RA.XMLの処理中に例外が発生しました:" + backuppath.getAbsolutePath());
                        errorCollection.add(ie.getMessage());
                    }



                    System.out.println("sun-ra.xmlの処理完了。オリジナルは" + backupdir.getAbsolutePath() + relativepath + "にバックアップされました。");



                    } else
                            if(dirfiles[i].isDirectory()) {
                    processUnRarDir(dirfiles[i], backupdir);
                            }


        }

    }

    public void setConnectorResourceQueue(String ConnectorResourceQueue) {
        this.ConnectorResourceQueue = ConnectorResourceQueue;
    }

    public void setConnectorResourceTopic(String ConnectorResourceTopic) {
        this.ConnectorResourceTopic = ConnectorResourceTopic;
    }

}
