/*
 * Ejb_Jar.java
 *
 * Created on 2007/12/20, 14:18
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package earupdater.transformer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.xmlbeans.XmlOptions;

/**
 *
 * @author Administrator
 */
public class Ejb_Jar implements DDTransformer {

    private File ejb_jar_xml;
    private byte[] innerbuffer;
    private boolean showdetaillog;


    public Ejb_Jar(File file) {
        this.ejb_jar_xml = file;
    }

    public String showChangingPoint() {

        StringBuffer sb = new StringBuffer();
        //sb.append("<module><ejb>WorkflowServiceClient.jar</ejb></module>を追加");

sb.append("変更箇所：以下のブロックを追加します。").append("\n");
sb.append("<ejb-local-ref>").append("\n");
    sb.append("<ejb-ref-name>ejb/stc/deployedServices/WorkflowService</ejb-ref-name>").append("\n");
    sb.append("<ejb-ref-type>Session</ejb-ref-type>").append("\n");
    sb.append("<local-home>com.stc.bpms.wlm.ejb.WorkflowServiceLocalHome</local-home>").append("\n");
    sb.append("<local>com.stc.bpms.wlm.ejb.WorkflowServiceLocal</local>").append("\n");
    sb.append("<ejb-link>WorkflowService</ejb-link>").append("\n");
sb.append("</ejb-local-ref>").append("\n");


        return sb.toString();

    }


    public byte[] getBytes() {
        //return baos.toByteArray();
        return this.innerbuffer;
    }

    boolean isThisEJBModificationTarget(String ejbname) {
        if (ejbname == null)
            return false;

        int foundUnderScoreCount = 0;

        char[] carray = ejbname.toCharArray();
        for (int i = 0 ; i < carray.length; i++) {
            if (carray[i] == '_') {
                foundUnderScoreCount++;
            }
        }

        //サービス名とデプロイプロファイルに＿を使っている場合は１ひく

        if (ejbname.toUpperCase().indexOf("JCD_") != -1) {
            foundUnderScoreCount--;
        }

        if (ejbname.indexOf("01_") != -1) {
            foundUnderScoreCount--;
        }

        //_が1のときはバリバリ対象
        if (foundUnderScoreCount == 1) {

            System.out.println("ejb-jar更新対象のSession EJB名:" + ejbname);
            return true;

        } else {
            //2以上のときは基本的に対象ではない
            System.out.println("ejb-jar更新対象ではないSession EJB名:" + ejbname);
            return false;

        }
    }

    public void setShowTransformationDetailLog(boolean value) {
        this.showdetaillog = value;
    }

    public byte[] transform() {
        try {



        com.sun.java.xml.ns.j2Ee.EjbJarDocument ejbjarxml =
                com.sun.java.xml.ns.j2Ee.EjbJarDocument.Factory.parse(this.ejb_jar_xml);

        if (this.showdetaillog)
        System.out.println("変更前：" + ejbjarxml.toString());

        com.sun.java.xml.ns.j2Ee.EjbJarType ejbjardoc =
                ejbjarxml.getEjbJar();



        for (int i = 0 ; i < ejbjardoc.getEnterpriseBeans().getSessionArray().length; i++) {
            com.sun.java.xml.ns.j2Ee.SessionBeanType sbt =
                    ejbjardoc.getEnterpriseBeans().getSessionArray(i);
            boolean workflow_local_ejb_ref_already_definded = false;
            //ejb-nameをチェックする
            //コネクティビティマップ名_JCDまたはBPM名_対象サービス名
            //または
            //外部システム名＿コネクティビティマップ名＿JCDサービス名
            //はCAPS基盤コードなので、いじくらない。（EJB ClassLoader例外が発生する）
            //サービス名にはjcd_UpdateBamなどのようにjcd_がはいる可能性もある
            //デプロイメントプロファイル名に01_がはいるかのうせいも
            String ejbname = sbt.getEjbName().getStringValue();
            if (isThisEJBModificationTarget(ejbname)) {
                //if (true) {

                for (int j = 0 ; j < sbt.getEjbLocalRefArray().length; j++) {




                    com.sun.java.xml.ns.j2Ee.EjbLocalRefType ejblocalref =
                            sbt.getEjbLocalRefArray(j);
                    if (ejblocalref.getEjbRefName().getStringValue().equals("ejb/stc/deployedServices/WorkflowService")) {
                        workflow_local_ejb_ref_already_definded = true;
                    }


                }


                if (!workflow_local_ejb_ref_already_definded) {
                    //int current_max_index = mdbt.getEjbLocalRefArray().length;
                    com.sun.java.xml.ns.j2Ee.EjbLocalRefType worklistlocalref = sbt.addNewEjbLocalRef();
                    worklistlocalref.addNewEjbRefName().setStringValue("ejb/stc/deployedServices/WorkflowService");
                    worklistlocalref.addNewEjbRefType().setStringValue("Session");
                    worklistlocalref.addNewLocal().setStringValue("com.stc.bpms.wlm.ejb.WorkflowServiceLocal");
                    worklistlocalref.addNewLocalHome().setStringValue("com.stc.bpms.wlm.ejb.WorkflowServiceLocalHome");
                    worklistlocalref.addNewEjbLink().setStringValue("WorkflowService");
                }



            }

        }

        /*
        for (int i = 0 ; i < ejbjardoc.getEnterpriseBeans().getMessageDrivenArray().length; i++) {
            com.sun.java.xml.ns.j2Ee.MessageDrivenBeanType mdbt =
                    ejbjardoc.getEnterpriseBeans().getMessageDrivenArray(i);
                    boolean workflow_local_ejb_ref_already_definded = false;
                    for (int j = 0; j < mdbt.getEjbLocalRefArray().length; j++) {
                        com.sun.java.xml.ns.j2Ee.EjbLocalRefType ejblocalref =
                                     mdbt.getEjbLocalRefArray(j);
                        if (ejblocalref.getEjbRefName().getStringValue().equals("ejb/stc/deployedServices/WorkflowService")) {
                            workflow_local_ejb_ref_already_definded = true;
                        }
                    }
                    if (!workflow_local_ejb_ref_already_definded) {
                        //int current_max_index = mdbt.getEjbLocalRefArray().length;
                        com.sun.java.xml.ns.j2Ee.EjbLocalRefType worklistlocalref = mdbt.addNewEjbLocalRef();
                        worklistlocalref.addNewEjbRefName().setStringValue("ejb/stc/deployedServices/WorkflowService");
                        worklistlocalref.addNewEjbRefType().setStringValue("Session");
                        worklistlocalref.addNewLocal().setStringValue("com.stc.bpms.wlm.ejb.WorkflowServiceLocal");
                        worklistlocalref.addNewLocalHome().setStringValue("com.stc.bpms.wlm.ejb.WorkflowServiceLocalHome");
                        worklistlocalref.addNewEjbLink().setStringValue("WorkflowService");
                    }
        }
         */

    /*

        for (int i = 0 ; i < ejbjardoc.getEnterpriseBeans().getEntityArray().length; i++) {
            com.sun.java.xml.ns.j2Ee.EntityBeanType ebt =
                    ejbjardoc.getEnterpriseBeans().getEntityArray(i);
            boolean workflow_local_ejb_ref_already_definded = false;
            for (int j = 0 ; j < ebt.getEjbLocalRefArray().length; j++) {
                com.sun.java.xml.ns.j2Ee.EjbLocalRefType ejblocalref =
                        ebt.getEjbLocalRefArray(j);
                if (ejblocalref.getEjbRefName().getStringValue().equals("ejb/stc/deployedServices/WorkflowService")) {
                    workflow_local_ejb_ref_already_definded = true;
                }

            }
                    if (!workflow_local_ejb_ref_already_definded) {
                        //int current_max_index = mdbt.getEjbLocalRefArray().length;
                        com.sun.java.xml.ns.j2Ee.EjbLocalRefType worklistlocalref = ebt.addNewEjbLocalRef();
                        worklistlocalref.addNewEjbRefName().setStringValue("ejb/stc/deployedServices/WorkflowService");
                        worklistlocalref.addNewEjbRefType().setStringValue("Session");
                        worklistlocalref.addNewLocal().setStringValue("com.stc.bpms.wlm.ejb.WorkflowServiceLocal");
                        worklistlocalref.addNewLocalHome().setStringValue("com.stc.bpms.wlm.ejb.WorkflowServiceLocalHome");
                        worklistlocalref.addNewEjbLink().setStringValue("WorkflowService");
                    }

        }

     **/

        XmlOptions option = new XmlOptions();
        option.setSavePrettyPrint();
        option.setSavePrettyPrintIndent(2);
        //option.setCharacterEncoding("SJIS");

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ejbjarxml.save(baos, option);

        this.innerbuffer = baos.toByteArray();

        if (this.showdetaillog)
        System.out.println("変更後：" + new String(this.innerbuffer));



        } catch (Exception e) {
            System.err.println("Ejb_Jar_XML.transform処理中に例外が発生しました。");
            e.printStackTrace();
        }

        return this.innerbuffer;
    }

    public void transformAndSave(File outputfile) throws Exception {
        java.io.FileOutputStream fo = null;
        fo = new FileOutputStream(outputfile);
        fo.write(transform());
        fo.close();
    }

}

