/*
 * Sun_Ejb_Jar.java
 *
 * Created on 2007/12/20, 14:17
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package earupdater.transformer;

import dtd.sun_ejb_jar_2_1_0_1452841624.Ejb;
import dtd.sun_ejb_jar_2_1_0_1452841624.Sun_ejb_jar;
import earupdater.transformer.DDTransformer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;

/**
 *
 * @author Administrator
 */
public class Sun_Ejb_Jar implements DDTransformer {

    private File sun_ejb_jar;
    private byte[] innerbuffer;
    private boolean showdetaillog;

    private String ConnectorResourceQueue;
    private String ConnectorResourceTopic;

    private boolean modified = false;


    /** Creates a new instance of Sun_RAR */
    //public Sun_RAR() {
    //}

    public Sun_Ejb_Jar(File file) {
        this.sun_ejb_jar = file;
    }

    public String showChangingPoint() {

        StringBuffer sb = new StringBuffer();
        sb.append("変更箇所：<jndi-name>__SYSTEM</jndi-name>→<jndi-name>コネクタリソース</jndi-name>");

        return sb.toString();

    }


    public byte[] getBytes() {
        //return baos.toByteArray();
        return this.innerbuffer;
    }

    public byte[] transform() {
        try {



        Sun_ejb_jar sun_ejb_jar = new Sun_ejb_jar();


        byte buf[] = new byte[1024];
        int len = 0;

        ByteArrayOutputStream baos = new ByteArrayOutputStream();


        java.io.FileInputStream fi = new FileInputStream(this.sun_ejb_jar);
        while ((len = fi.read(buf)) != -1) {
            //msg.writeBytes(buf, 0 , len);
            baos.write(buf, 0, len);

        }

        fi.close();

        this.innerbuffer = baos.toByteArray();

        if (this.showdetaillog)
        System.out.println("変更前：" + new String(this.innerbuffer));
        sun_ejb_jar.unmarshalFromBytes(this.innerbuffer);

        baos.close();

        for (int i = 0 ; i < sun_ejb_jar.getEnterprise_beans().countEjb(); i++) {
            Ejb ejb = sun_ejb_jar.getEnterprise_beans().getEjb(i);
            //ejb.setBean_pool(null);
            //Bean_pool bp = new Bean_pool();
            //ejb.setBean_pool(bp);

            ArrayList ar = ejb.getResource_env_refList();

            for (int j = 0; j < ar.size() ; j++) {

            dtd.sun_ejb_jar_2_1_0_1452841624.Resource_env_ref o
                    = (dtd.sun_ejb_jar_2_1_0_1452841624.Resource_env_ref) ar.get(j);

            String jndiname = o.getJndi_name();
            if (jndiname.indexOf("#javax.jms.QueueConnectionFactory") != -1) {
                  o.setJndi_name(this.ConnectorResourceQueue);
                  this.modified = true;
            } else if (jndiname.indexOf("#javax.jms.TopicConnectionFactory") != -1) {
                  o.setJndi_name(this.ConnectorResourceTopic);
                  this.modified = true;
            }

            }

        }

        this.innerbuffer = sun_ejb_jar.marshalToBytes();

        if (this.showdetaillog)
        System.out.println("変更後：" + new String(this.innerbuffer));



        } catch (Exception e) {
            System.err.println("Sun_Ejb_JAR.transform処理中に例外が発生しました。");
            e.printStackTrace();
        }

        return this.innerbuffer;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void transformAndSave(File outputfile) throws Exception {
        java.io.FileOutputStream fo = null;
        fo = new FileOutputStream(outputfile);
        //fo.write(sunconnectorotd.marshalToBytes());
        fo.write(transform());
        fo.close();
    }

    public void setShowTransformationDetailLog(boolean value) {
        this.showdetaillog = value;
    }

    public String getConnectorResourceQueue() {
        return ConnectorResourceQueue;
    }

    public void setConnectorResourceQueue(String ConnectorResourceQueue) {
        this.ConnectorResourceQueue = ConnectorResourceQueue;
    }

    public String getConnectorResourceTopic() {
        return ConnectorResourceTopic;
    }

    public void setConnectorResourceTopic(String ConnectorResourceTopic) {
        this.ConnectorResourceTopic = ConnectorResourceTopic;
    }

}

