using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameData.Expression
{
	internal sealed class ExpressionEvaluator
	{
		public ExpressionEvaluator(VariableEvaluator vev)
		{
			vEvaluator = vev;
		}
		
		public FixedVariablePointer GetFixedVariable(VariableToken token)
		{
			FixedVariablePointer p = new FixedVariablePointer();
			p.ID = token.Identifier;
			SingleTerm s1 = GetValue(token.Element1);
			SingleTerm s2 = GetValue(token.Element2);
			if (s1 == null)
				return p;
			if (s1.GetOperandType() == typeof(Int64))
				p.Index1 = s1.Int;
			else
				p.Index1 = vEvaluator.Constant.KeywordToInteger(token.Identifier.Code, s1.Str);
			if (s2 == null)
				return p;
			if (s2.GetOperandType() == typeof(Int64))
				p.Index2 = s2.Int;
			else
				p.Index2 = vEvaluator.Constant.KeywordToInteger(token.Identifier.Code, s2.Str);
			return p;
		}

		public Int64 GetInteger(IOperandTerm term)
		{
			SingleTerm sTerm = GetValue(term);
			if (sTerm == null)
				return 0;
			return sTerm.Int;
		}

		public string GetString(IOperandTerm term)
		{
			SingleTerm sTerm = GetValue(term);
			if (sTerm == null)
				return null;
			return sTerm.Str;
		}

		private SingleTerm GetValue(IOperandTerm term)
		{
			if (term == null)
				return null;
			if (term is SingleTerm)
			{
				return (SingleTerm)term;
			}
			else if (term is StringFormTerm)
			{
				return new SingleTerm(((StringFormTerm)term).StrForm.GetString(this));
			}
			else if (term is VariableToken)
			{
				VariableToken varTerm = (VariableToken)term;
				if (varTerm.IsInteger)
					return new SingleTerm(vEvaluator.GetInteger(this.GetFixedVariable(varTerm)));
				else
					return new SingleTerm(vEvaluator.GetString(this.GetFixedVariable(varTerm)));
			}
			else if (term is UnaryExpressionTerm)
			{
				UnaryExpressionTerm ueTerm = (UnaryExpressionTerm)term;
				return ueTerm.Method(ueTerm.Operand, GetValue);
			}
			else if (term is BinaryExpressionTerm)
			{
				BinaryExpressionTerm beTerm = (BinaryExpressionTerm)term;
				return beTerm.Method(beTerm.Left, beTerm.Right, GetValue);
			}
            else if (term is TernaryExpressionTerm)
            {
                TernaryExpressionTerm teTerm = (TernaryExpressionTerm)term;
                return teTerm.Method(teTerm.Left, teTerm.Right1, teTerm.Right2, GetValue);
            }
			throw new ExeEE("ςȃIyh");
		}

		readonly VariableEvaluator vEvaluator;
	}
}
