using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
namespace MinorShift.Emuera.GameProc
{
	//1.60Ŕp~B
	//BuiltInFunctionCodeƓ̂Ē`͔̂
	//internal enum ArgumentType
	//{
	//    NULL = 0,
	//    VOID = BuiltInFunctionCode.__ARG_VOID__,//void
	//    INT_EXPRESSION = BuiltInFunctionCode.__ARG_INT_EXPRESSION__,//^
	//    STR_EXPRESSION = BuiltInFunctionCode.__ARG_STR_EXPRESSION__,//񎮌^
	//    STR = BuiltInFunctionCode.__ARG_STR__,//P^
	//    FORM_STR = BuiltInFunctionCode.__ARG_FORM_STR__,//t^
	//    SP_PRINTV = BuiltInFunctionCode.__ARG_SP_PRINTV__,//^B'``,
	//    SP_TIMES = BuiltInFunctionCode.__ARG_SP_TIMES__,//lϐE^B
	//    SP_BAR = BuiltInFunctionCode.__ARG_SP_BAR__,//EE^
	//    SP_SET = BuiltInFunctionCode.__ARG_SP_SET__,//ϐlϐE^B
	//    SP_SETS = BuiltInFunctionCode.__ARG_SP_SETS__,//ϕϐEP^B
	//    SP_SUBSTRING = BuiltInFunctionCode.__ARG_SP_SUBSTRING__,
	//    SP_SWAP = BuiltInFunctionCode.__ARG_SP_SWAP__,
	//    SP_VARSIZE = BuiltInFunctionCode.__ARG_SP_VAR__,
	//    SP_SAVEDATA = BuiltInFunctionCode.__ARG_SP_SAVEDATA__,
	//    SP_TINPUTS = BuiltInFunctionCode.__ARG_SP_TINPUTS__,
	//    __MASK__ = unchecked((int)0x7FF00000),
	//}
	internal abstract class Argument
	{
		//ArgumentType type = (ArgumentType)((int)ArgumentType.__MASK__ & (int)func);
	}

	internal sealed class VoidArgument : Argument
	{
		public VoidArgument() { }
	}

	internal sealed class ExpressionArgument : Argument
	{
		public ExpressionArgument(IOperandTerm termSrc)
		{
			Term = termSrc;
		}
		readonly public IOperandTerm Term;
	}

	internal sealed class StrArgument : Argument
	{
		public StrArgument(string str)
		{
			Str = str;
		}
		readonly public string Str;
	}

	internal sealed class FormStrArgument : Argument
	{
		public FormStrArgument(StringForm strform)
		{
			StrForm = strform;
		}
		readonly public StringForm StrForm;
	}


	internal sealed class SpPrintVArgument : Argument
	{
		public SpPrintVArgument(List<IOperandTerm> list)
		{
			Terms = list;
		}
		readonly public List<IOperandTerm> Terms;
	}

	internal sealed class SpTimesArgument : Argument
	{
		public SpTimesArgument(VariableToken var, double d)
		{
			VariableDest = var;
			DoubleValue = d;
		}
		readonly public VariableToken VariableDest;
		readonly public double DoubleValue;
	}

	internal sealed class SpBarArgument : Argument
	{
		public SpBarArgument(IOperandTerm value, IOperandTerm max, IOperandTerm length)
		{
			Terms[0] = value;
			Terms[1] = max;
			Terms[2] = length;
		}
		readonly public IOperandTerm[] Terms = new IOperandTerm[3];
	}

	internal sealed class SpSetArgument : Argument
	{
		public SpSetArgument(VariableToken var, IOperandTerm termSrc)
		{
			VariableDest = var;
			Term = termSrc;
		}
		readonly public VariableToken VariableDest;
		readonly public IOperandTerm Term;
	}

	internal sealed class SpSetsArgument : Argument
	{
		public SpSetsArgument(VariableToken var, StringForm strform)
		{
			VariableDest = var;
			StrForm = strform;
		}
		readonly public VariableToken VariableDest;
		readonly public StringForm StrForm;
	}

	internal sealed class SpSubstringArgument : Argument
	{
		public SpSubstringArgument(IOperandTerm var, IOperandTerm start, IOperandTerm length)
		{
			StrExpression = var;
			Start = start;
			Length = length;
		}
		readonly public IOperandTerm StrExpression;
		readonly public IOperandTerm Start;
		readonly public IOperandTerm Length;
	}

	internal sealed class SpSwapCharaArgument : Argument
	{
		public SpSwapCharaArgument(IOperandTerm x, IOperandTerm y)
		{
			X = x;
			Y = y;
		}
		readonly public IOperandTerm X;
		readonly public IOperandTerm Y;
	}

	internal sealed class SpSwapVarArgument : Argument
	{
		public SpSwapVarArgument(VariableToken v1, VariableToken v2)
		{
			var1 = v1;
			var2 = v2;
		}
		readonly public VariableToken var1;
		readonly public VariableToken var2;
	}

	internal sealed class SpVarsizeArgument : Argument
	{
		public SpVarsizeArgument(VariableIdentifier var)
		{
			VariableID = var;
		}
		readonly public VariableIdentifier VariableID;
	}

	internal sealed class SpSaveDataArgument : Argument
	{
		public SpSaveDataArgument(IOperandTerm target, IOperandTerm var)
		{
			Target = target;
			StrExpression = var;
		}
		readonly public IOperandTerm Target;
		readonly public IOperandTerm StrExpression;
	}

	internal sealed class SpTInputsArgument : Argument
	{
		public SpTInputsArgument(IOperandTerm time, IOperandTerm def, IOperandTerm disp)
		{
			Time = time;
			Def = def;
			Disp = disp;
		}
		readonly public IOperandTerm Time;
		readonly public IOperandTerm Def;
		readonly public IOperandTerm Disp;
	}

	internal enum SortOrder
	{
		UNDEF = 0,
		ASCENDING = 1,
		DESENDING = 2,
	}

	internal sealed class SpSortcharaArgument : Argument
	{
		public SpSortcharaArgument(VariableToken var, SortOrder order)
		{
			SortKey = var;
			SortOrder = order;
		}
		readonly public VariableToken SortKey;
		readonly public SortOrder SortOrder;
	}

	internal sealed class SpCallArgment : Argument
	{
		public SpCallArgment(string funcname, IOperandTerm[] args)
		{
			Str = funcname;
			Args = args;
		}
		readonly public string Str;
		readonly public IOperandTerm[] Args;
	}

	internal sealed class SpCallformArgment : Argument
	{
		public SpCallformArgment(StringForm formstr, IOperandTerm[] args)
		{
			StrForm = formstr;
			Args = args;
		}
		readonly public StringForm StrForm;
		readonly public IOperandTerm[] Args;
	}

	internal sealed class SpForNextArgment : Argument
	{
		public SpForNextArgment(VariableToken var, IOperandTerm start, IOperandTerm end, IOperandTerm step)
		{
			this.Cnt = var;
			this.Start = start;
			this.End = end;
			this.Step = step;
		}
		readonly public VariableToken Cnt;
		readonly public IOperandTerm Start;
		readonly public IOperandTerm End;
		readonly public IOperandTerm Step;
	}

	internal sealed class SpPowerArgument : Argument
	{
		public SpPowerArgument(VariableToken var, IOperandTerm x, IOperandTerm y)
		{
			VariableDest = var;
			X = x;
			Y = y;
		}
		readonly public VariableToken VariableDest;
		readonly public IOperandTerm X;
		readonly public IOperandTerm Y;
	}

	internal sealed class SpStrFindArgument : Argument
	{
		public SpStrFindArgument(IOperandTerm target, IOperandTerm word)
		{
			TargetStr = target;
			WordStr = word;
		}
		readonly public IOperandTerm TargetStr;
		readonly public IOperandTerm WordStr;
	}
}
