using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Drawing;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera
{
	public sealed class StrIgnoreCaseComparer : IComparer<string>
	{
		public int Compare(string x, string y)
		{
			return string.Compare(x, y, StringComparison.OrdinalIgnoreCase);
		}
	}

	/// <summary>
	/// プログラム全体で使用される値でWindow作成前に設定して以後変更されないもの
	/// (という予定だったが今は違う)
	/// </summary>
	internal sealed class Config
	{
		readonly static string configPath = Program.ExeDir + "emuera.config";
        readonly static string macroPath = Program.ExeDir + "macro.txt";

		static Config() { }
		private static Config instance = new Config();
		public static Config Instance { get { return instance; } }
		public readonly static Encoding Encode = Encoding.GetEncoding("SHIFT-JIS");

		private Config() { setDefault(); }

		//適当に大き目の配列を作っておく。
		private AConfigItem[] configArray = new AConfigItem[70];
		private AConfigItem[] replaceArray = new AConfigItem[50];
        private AConfigItem[] macroArray = new AConfigItem[12];

		private void setDefault()
		{
			int i = 0;
			configArray[i++] = new ConfigItem<bool>(ConfigCode.IgnoreCase, "大文字小文字の違いを無視する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseRenameFile, "_Rename.csvを利用する", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseReplaceFile, "_Replace.csvを利用する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseMouse, "マウスを使用する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseMenu, "メニューを使用する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseDebugCommand, "デバッグコマンドを使用する", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.AllowMultipleInstances, "多重起動を許可する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.AutoSave, "オートセーブを行なう", true);
            configArray[i++] = new ConfigItem<bool>(ConfigCode.UseKeyMacro, "キーボードマクロを使用する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.SizableWindow, "ウィンドウの高さを可変にする", true);
			configArray[i++] = new ConfigItem<TextDrawingMode>(ConfigCode.TextDrawingMode, "描画インターフェース", TextDrawingMode.GRAPHICS);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseImageBuffer, "イメージバッファを使用する", true);
			configArray[i++] = new ConfigItem<int>(ConfigCode.WindowX, "ウィンドウ幅", 760);
			configArray[i++] = new ConfigItem<int>(ConfigCode.WindowY, "ウィンドウ高さ", 480);
			configArray[i++] = new ConfigItem<int>(ConfigCode.WindowPosX, "ウィンドウ位置X", 0);
			configArray[i++] = new ConfigItem<int>(ConfigCode.WindowPosY, "ウィンドウ位置Y", 0);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.SetWindowPos, "起動時のウィンドウ位置を指定する", false);
            configArray[i++] = new ConfigItem<bool>(ConfigCode.WindowMaximixed, "起動時にウィンドウを最大化する", false);
			configArray[i++] = new ConfigItem<int>(ConfigCode.MaxLog, "履歴ログの行数", 5000);
			configArray[i++] = new ConfigItem<int>(ConfigCode.PrintCPerLine, "PRINTCを並べる数", 3);
			configArray[i++] = new ConfigItem<int>(ConfigCode.PrintCLength, "PRINTCの文字数", 25);
			configArray[i++] = new ConfigItem<string>(ConfigCode.FontName, "フォント名", "ＭＳ ゴシック");
			configArray[i++] = new ConfigItem<int>(ConfigCode.FontSize, "フォントサイズ", 18);
			configArray[i++] = new ConfigItem<int>(ConfigCode.LineHeight, "一行の高さ", 19);
			configArray[i++] = new ConfigItem<Color>(ConfigCode.ForeColor, "文字色", Color.FromArgb(192, 192, 192));//LIGHTGRAY
			configArray[i++] = new ConfigItem<Color>(ConfigCode.BackColor, "背景色", Color.FromArgb(0, 0, 0));//BLACK
			configArray[i++] = new ConfigItem<Color>(ConfigCode.FocusColor, "選択中文字色", Color.FromArgb(255, 255, 0));//YELLOW
			configArray[i++] = new ConfigItem<Color>(ConfigCode.LogColor, "履歴文字色", Color.FromArgb(192, 192, 192));//LIGHTGRAY//Color.FromArgb(128, 128, 128);//GRAY
			configArray[i++] = new ConfigItem<int>(ConfigCode.FPS, "フレーム毎秒", 5);
			configArray[i++] = new ConfigItem<int>(ConfigCode.SkipFrame, "最大スキップフレーム数", 3);
            configArray[i++] = new ConfigItem<int>(ConfigCode.ScrollHeight, "スクロール行数", 1);
            configArray[i++] = new ConfigItem<int>(ConfigCode.InfiniteLoopAlertTime, "無限ループ警告までのミリ秒数", 5000);
			configArray[i++] = new ConfigItem<int>(ConfigCode.DisplayWarningLevel, "表示する最低警告レベル", 1);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.DisplayReport, "ロード時にレポートを表示する", false);
			configArray[i++] = new ConfigItem<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad, "ロード時に引数を解析する", ReduceArgumentOnLoadFlag.NO);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.ReduceFormattedStringOnLoad, "ロード時にFORM文字列を解析する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.IgnoreUncalledFunction, "呼び出されなかった関数を無視する", true);
			configArray[i++] = new ConfigItem<DisplayWarningFlag>(ConfigCode.FunctionNotFoundWarning, "関数が見つからない警告の扱い", DisplayWarningFlag.IGNORE);
			configArray[i++] = new ConfigItem<DisplayWarningFlag>(ConfigCode.FunctionNotCalledWarning, "関数が呼び出されなかった警告の扱い", DisplayWarningFlag.IGNORE);
			configArray[i++] = new ConfigItem<List<string>>(ConfigCode.IgnoreWarningFiles, "指定したファイル中の警告を無視する", new List<string>());
			configArray[i++] = new ConfigItem<bool>(ConfigCode.ChangeMasterNameIfDebug, "デバッグコマンドを使用した時にMASTERの名前を変更する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.ButtonWrap, "ボタンの途中で行を折りかえさない", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.SearchSubdirectory, "サブディレクトリを検索する", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.SortWithFilename, "読み込み順をファイル名順にソートする", false);
            configArray[i++] = new ConfigItem<long>(ConfigCode.LastKey, "最終更新コード", 0);
            configArray[i++] = new ConfigItem<int>(ConfigCode.SaveDataNos, "表示するセーブデータ数", 20);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.WarnBackCompatibility, "eramaker互換性に関する警告を表示する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.AllowFunctionOverloading, "システム関数の上書きを許可する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.WarnFunctionOverloading, "システム関数が上書きされたとき警告を表示する", true);
            configArray[i++] = new ConfigItem<string>(ConfigCode.TextEditor, "関連づけるテキストエディタ", "notepad");
            configArray[i++] = new ConfigItem<string>(ConfigCode.EditorArgument, "エディタに渡す行指定引数", "");
            configArray[i++] = new ConfigItem<bool>(ConfigCode.WarnNormalFunctionOverloading, "同名の非イベント関数が複数定義されたとき警告する", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.CompatiErrorLine, "解釈不可能な行があっても実行する", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.CompatiCALLNAME, "CALLNAMEが空文字列の時にNAMEを代入する", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.DebugShowWindow, "起動時にデバッグウインドウを表示する", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.DebugWindowTopMost, "デバッグウインドウを最前面に表示する", true);
			configArray[i++] = new ConfigItem<int>(ConfigCode.DebugWindowWidth, "デバッグウィンドウ幅", 400);
			configArray[i++] = new ConfigItem<int>(ConfigCode.DebugWindowHeight, "デバッグウィンドウ高さ", 300);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.DebugSetWindowPos, "デバッグウィンドウ位置を指定する", false);
			configArray[i++] = new ConfigItem<int>(ConfigCode.DebugWindowPosX, "デバッグウィンドウ位置X", 0);
			configArray[i++] = new ConfigItem<int>(ConfigCode.DebugWindowPosY, "デバッグウィンドウ位置Y", 0);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseSaveFolder, "セーブデータをsavフォルダ内に作成する", false);
			
			i = 0;
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.MoneyLabel, "お金の単位", "$");
			replaceArray[i++] = new ConfigItem<bool>(ConfigCode.MoneyFirst, "単位の位置", true);
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.LoadLabel, "起動時簡略表示", "Now Loading...");
			replaceArray[i++] = new ConfigItem<int>(ConfigCode.MaxShopItem, "販売アイテム数", 100);
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.DrawLineString, "DRAWLINE文字", "-");
			replaceArray[i++] = new ConfigItem<char>(ConfigCode.BarChar1, "BAR文字1", '*');
			replaceArray[i++] = new ConfigItem<char>(ConfigCode.BarChar2, "BAR文字2", '.');
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.TitleMenuString0, "システムメニュー0", "最初からはじめる");
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.TitleMenuString1, "システムメニュー1", "ロードしてはじめる");
            replaceArray[i++] = new ConfigItem<int>(ConfigCode.ComAbleDefault, "COM_ABLE初期値", 1);
            replaceArray[i++] = new ConfigItem<List<Int64>>(ConfigCode.StainDefault, "汚れの初期値", new List<Int64>(new Int64[]{0,0,2,1,8}));
            replaceArray[i++] = new ConfigItem<string>(ConfigCode.TimeupLabel, "時間切れ表示", "時間切れ");
            replaceArray[i++] = new ConfigItem<List<Int64>>(ConfigCode.ExpLvDef, "EXPLVの初期値", new List<long>(new Int64[]{0, 1, 4, 20, 50, 200}));
            replaceArray[i++] = new ConfigItem<List<Int64>>(ConfigCode.PalamLvDef, "PALAMLVの初期値", new List<long>(new Int64[] { 0, 100, 500, 3000, 10000, 30000, 60000, 100000, 150000, 250000}));
            replaceArray[i++] = new ConfigItem<Int64>(ConfigCode.pbandDef, "PBANDの初期値", 4);

            i = 0;
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF1, "マクロキーF1", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF2, "マクロキーF2", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF3, "マクロキーF3", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF4, "マクロキーF4", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF5, "マクロキーF5", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF6, "マクロキーF6", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF7, "マクロキーF7", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF8, "マクロキーF8", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF9, "マクロキーF9", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF10, "マクロキーF10", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF11, "マクロキーF11", "");
            macroArray[i++] = new ConfigItem<string>(ConfigCode.MacroF12, "マクロキーF12", "");
        }
		public Config Copy()
		{
			Config config = new Config();
			//for(int i = 0; i< configArray.Length;i++)
			//    config.configArray[i] = AConfigItem.Copy(this.configArray[i]);
			//for(int i = 0; i< replaceArray.Length;i++)
			//    config.replaceArray[i] = AConfigItem.Copy(this.replaceArray[i]);
			for (int i = 0; i < configArray.Length; i++)
				if ((this.configArray[i] != null) && (config.configArray[i] != null))
					this.configArray[i].CopyTo(config.configArray[i]);
			for (int i = 0; i < replaceArray.Length; i++)
				if ((this.replaceArray[i] != null) && (config.replaceArray[i] != null))
					this.replaceArray[i].CopyTo(config.replaceArray[i]);
            for (int i = 0; i < macroArray.Length; i++)
                if ((this.macroArray[i] != null) && (config.macroArray[i] != null))
                    this.macroArray[i].CopyTo(config.macroArray[i]);
			return config;
		}

		public T GetConfigValue<T>(ConfigCode code)
		{
			AConfigItem item = GetItem(code);
			if ((item != null) && (item is ConfigItem<T>))
				return ((ConfigItem<T>)item).Value;
			throw new ExeEE("GetConfigValueのCodeまたは型が不適切");
		}

#region getitem
		public AConfigItem GetItem(ConfigCode code)
		{
			AConfigItem item = GetConfigItem(code);
            if (item == null)
            {
                item = GetReplaceItem(code);
                if (item == null)
                    return GetMacroItem(code);
            }
			return item;
		}
		public AConfigItem GetItem(string key)
		{
			AConfigItem item = GetConfigItem(key);
			if (item == null)
				return GetReplaceItem(key);
			return item;
		}

		public AConfigItem GetConfigItem(ConfigCode code)
		{
			foreach (AConfigItem item in configArray)
			{
				if (item == null)
					continue;
				if (item.Code == code)
					return item;
			}
			return null;
		}
		public AConfigItem GetConfigItem(string key)
		{
			foreach (AConfigItem item in configArray)
			{
				if (item == null)
					continue;
				if (item.Name == key)
					return item;
				if (item.Text == key)
					return item;
			}
			return null;
		}

		public AConfigItem GetReplaceItem(ConfigCode code)
		{
			foreach (AConfigItem item in replaceArray)
			{
				if (item == null)
					continue;
				if (item.Code == code)
					return item;
			}
			return null;
		}
		public AConfigItem GetReplaceItem(string key)
		{
			foreach (AConfigItem item in replaceArray)
			{
				if (item == null)
					continue;
				if (item.Name == key)
					return item;
				if (item.Text == key)
					return item;
			}
			return null;
		}
		public AConfigItem GetMacroItem(ConfigCode code)
		{
			foreach (AConfigItem item in macroArray)
			{
				if (item == null)
					continue;
				if (item.Code == code)
					return item;
			}
			return null;
		}
		public AConfigItem GetMacroItem(string key)
		{
			foreach (AConfigItem item in macroArray)
			{
				if (item == null)
					continue;
				if (item.Name == key)
					return item;
				if (item.Text == key)
					return item;
			}
			return null;
		}
#endregion

#region プロパティ

		public bool IgnoreCase { get { return GetConfigValue<bool>(ConfigCode.IgnoreCase); } }
		public bool UseRenameFile { get { return GetConfigValue<bool>(ConfigCode.UseRenameFile); } }
		public bool UseReplaceFile { get { return GetConfigValue<bool>(ConfigCode.UseReplaceFile); } }
		public bool UseMouse { get { return GetConfigValue<bool>(ConfigCode.UseMouse); } }
		public bool UseMenu { get { return GetConfigValue<bool>(ConfigCode.UseMenu); } }
		public bool UseDebugCommand { get { return GetConfigValue<bool>(ConfigCode.UseDebugCommand); } }
		public bool AllowMultipleInstances { get { return GetConfigValue<bool>(ConfigCode.AllowMultipleInstances); } }
		public bool AutoSave { get { return GetConfigValue<bool>(ConfigCode.AutoSave); } }
        public bool UseKeyMacro { get { return GetConfigValue<bool>(ConfigCode.UseKeyMacro); } }
		public bool SizableWindow { get { return GetConfigValue<bool>(ConfigCode.SizableWindow); } }
		public bool UseImageBuffer { get { return GetConfigValue<bool>(ConfigCode.UseImageBuffer); } }
		public TextDrawingMode TextDrawingMode { get { return GetConfigValue<TextDrawingMode>(ConfigCode.TextDrawingMode); } }
		public int WindowX { get { return GetConfigValue<int>(ConfigCode.WindowX); } }
		public int WindowY { get { return GetConfigValue<int>(ConfigCode.WindowY); } }
		public int WindowPosX { get { return GetConfigValue<int>(ConfigCode.WindowPosX); } }
		public int WindowPosY { get { return GetConfigValue<int>(ConfigCode.WindowPosY); } }
		public bool SetWindowPos { get { return GetConfigValue<bool>(ConfigCode.SetWindowPos); } }
		public int MaxLog { get { return GetConfigValue<int>(ConfigCode.MaxLog); } }
		public int PrintCPerLine { get { return GetConfigValue<int>(ConfigCode.PrintCPerLine); } }
		public int PrintCLength { get { return GetConfigValue<int>(ConfigCode.PrintCLength); } }
		public Color ForeColor { get { return GetConfigValue<Color>(ConfigCode.ForeColor); } }
		public Color BackColor { get { return GetConfigValue<Color>(ConfigCode.BackColor); } }
		public Color FocusColor { get { return GetConfigValue<Color>(ConfigCode.FocusColor); } }
		public Color LogColor { get { return GetConfigValue<Color>(ConfigCode.LogColor); } }
		public int Fontsize { get { return GetConfigValue<int>(ConfigCode.FontSize); } }
		public string Fontname { get { return GetConfigValue<string>(ConfigCode.FontName); } }
		public int LineHeight { get { return GetConfigValue<int>(ConfigCode.LineHeight); } }
		public int FPS { get { return GetConfigValue<int>(ConfigCode.FPS); } }
		public int SkipFrame { get { return GetConfigValue<int>(ConfigCode.SkipFrame); } }
        public int ScrollHeight { get { return GetConfigValue<int>(ConfigCode.ScrollHeight); } }
        public int InfiniteLoopAlertTime { get { return GetConfigValue<int>(ConfigCode.InfiniteLoopAlertTime); } }
        public int SaveDataNos { get { return GetConfigValue<int>(ConfigCode.SaveDataNos); } }
        public bool WarnBackCompatibility { get { return GetConfigValue<bool>(ConfigCode.WarnBackCompatibility); } }
        public bool WindowMaximixed { get { return GetConfigValue<bool>(ConfigCode.WindowMaximixed); } }
        public bool WarnNormalFunctionOverloading { get { return GetConfigValue<bool>(ConfigCode.WarnNormalFunctionOverloading); } }
        
        public bool AllowFunctionOverloading { get { return GetConfigValue<bool>(ConfigCode.AllowFunctionOverloading); } }
        public bool WarnFunctionOverloading { get {
			if (!AllowFunctionOverloading) return true;
			return GetConfigValue<bool>(ConfigCode.WarnFunctionOverloading); 
		} }
		
		public int DisplayWarningLevel { get { return GetConfigValue<int>(ConfigCode.DisplayWarningLevel); } }
		public bool DisplayReport { get { return GetConfigValue<bool>(ConfigCode.DisplayReport); } }
		public ReduceArgumentOnLoadFlag ReduceArgumentOnLoad { get { return GetConfigValue<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad); } }
		public bool ReduceFormattedStringOnLoad { get { return GetConfigValue<bool>(ConfigCode.ReduceFormattedStringOnLoad); } }
		public bool IgnoreUncalledFunction { get { return GetConfigValue<bool>(ConfigCode.IgnoreUncalledFunction); } }
		public DisplayWarningFlag FunctionNotFoundWarning { get { return GetConfigValue<DisplayWarningFlag>(ConfigCode.FunctionNotFoundWarning); } }
		public DisplayWarningFlag FunctionNotCalledWarning { get { return GetConfigValue<DisplayWarningFlag>(ConfigCode.FunctionNotCalledWarning); } }
		public List<string> IgnoreWarningFiles { get { return GetConfigValue<List<string>>(ConfigCode.IgnoreWarningFiles); } }

		public bool ChangeMasterNameIfDebug { get { return GetConfigValue<bool>(ConfigCode.ChangeMasterNameIfDebug); } }
		public long LastKey { get { return GetConfigValue<long>(ConfigCode.LastKey); } }
		public bool ButtonWrap { get { return GetConfigValue<bool>(ConfigCode.ButtonWrap); } }

        public string TextEditor { get { return GetConfigValue<string>(ConfigCode.TextEditor); } }
        public string EditorArg { get { return GetConfigValue<string>(ConfigCode.EditorArgument); } }

		public bool CompatiErrorLine { get { return GetConfigValue<bool>(ConfigCode.CompatiErrorLine); } }
		public bool CompatiCALLNAME { get { return GetConfigValue<bool>(ConfigCode.CompatiCALLNAME); } }
		public bool DebugShowWindow { get { return GetConfigValue<bool>(ConfigCode.DebugShowWindow); } }
		public bool DebugWindowTopMost { get { return GetConfigValue<bool>(ConfigCode.DebugWindowTopMost); } }
		public int DebugWindowWidth { get { return GetConfigValue<int>(ConfigCode.DebugWindowWidth); } }
		public int DebugWindowHeight { get { return GetConfigValue<int>(ConfigCode.DebugWindowHeight); } }
		public bool DebugSetWindowPos { get { return GetConfigValue<bool>(ConfigCode.DebugSetWindowPos); } }
		public int DebugWindowPosX { get { return GetConfigValue<int>(ConfigCode.DebugWindowPosX); } }
		public int DebugWindowPosY { get { return GetConfigValue<int>(ConfigCode.DebugWindowPosY); } }
		public bool UseSaveFolder { get { return GetConfigValue<bool>(ConfigCode.UseSaveFolder); } }

		public string MoneyLabel { get { return GetConfigValue<string>(ConfigCode.MoneyLabel); } }
		public bool MoneyFirst { get { return GetConfigValue<bool>(ConfigCode.MoneyFirst); } }
		public string LoadLabel { get { return GetConfigValue<string>(ConfigCode.LoadLabel); } }
		public int MaxShopItem { get { return GetConfigValue<int>(ConfigCode.MaxShopItem); } }
		public string DrawLineString { get { return GetConfigValue<string>(ConfigCode.DrawLineString); } }
		public char BarChar1 { get { return GetConfigValue<char>(ConfigCode.BarChar1); } }
		public char BarChar2 { get { return GetConfigValue<char>(ConfigCode.BarChar2); } }
		public string TitleMenuString0 { get { return GetConfigValue<string>(ConfigCode.TitleMenuString0); } }
		public string TitleMenuString1 { get { return GetConfigValue<string>(ConfigCode.TitleMenuString1); } }
		public int ComAbleDefault { get { return GetConfigValue<int>(ConfigCode.ComAbleDefault); } }
        public List<Int64> StainDefault { get { return GetConfigValue<List<Int64>>(ConfigCode.StainDefault); } }
        public string TimeupLabel { get { return GetConfigValue<string>(ConfigCode.TimeupLabel); } }
        public List<Int64> ExpLvDef { get { return GetConfigValue<List<Int64>>(ConfigCode.ExpLvDef); } }
        public List<Int64> PalamLvDef { get { return GetConfigValue<List<Int64>>(ConfigCode.PalamLvDef); } }
        public Int64 PbandDef { get { return GetConfigValue<Int64>(ConfigCode.pbandDef); } }

        public string MacroF1 { get { return GetConfigValue<string>(ConfigCode.MacroF1); } }
        public string MacroF2 { get { return GetConfigValue<string>(ConfigCode.MacroF2); } }
        public string MacroF3 { get { return GetConfigValue<string>(ConfigCode.MacroF3); } }
        public string MacroF4 { get { return GetConfigValue<string>(ConfigCode.MacroF4); } }
        public string MacroF5 { get { return GetConfigValue<string>(ConfigCode.MacroF5); } }
        public string MacroF6 { get { return GetConfigValue<string>(ConfigCode.MacroF6); } }
        public string MacroF7 { get { return GetConfigValue<string>(ConfigCode.MacroF7); } }
        public string MacroF8 { get { return GetConfigValue<string>(ConfigCode.MacroF8); } }
        public string MacroF9 { get { return GetConfigValue<string>(ConfigCode.MacroF9); } }
        public string MacroF10 { get { return GetConfigValue<string>(ConfigCode.MacroF10); } }
        public string MacroF11 { get { return GetConfigValue<string>(ConfigCode.MacroF11); } }
        public string MacroF12 { get { return GetConfigValue<string>(ConfigCode.MacroF12); } }
#endregion
		bool updated = false;

		//Dictionary<FontStyle, Font> fontDic = new Dictionary<FontStyle, Font>();
		Dictionary<string, Dictionary<FontStyle, Font>> fontDic = new Dictionary<string, Dictionary<FontStyle, Font>>();
		public Font Font { get { return GetFont(null, FontStyle.Regular); } }

		public Font GetFont(string theFontname, FontStyle style)
		{
			string fn = theFontname;
			if (string.IsNullOrEmpty(theFontname))
				fn = GetConfigValue<string>(ConfigCode.FontName);
			if (!fontDic.ContainsKey(fn))
				fontDic.Add(fn, new Dictionary<FontStyle, Font>());
			Dictionary<FontStyle, Font> fontStyleDic = fontDic[fn];
            if (!fontStyleDic.ContainsKey(style))
            {
                int fontsize = GetConfigValue<int>(ConfigCode.FontSize);
                try
                {
                    fontStyleDic.Add(style, new Font(fn, fontsize, style, GraphicsUnit.Pixel));
                }
                catch
                {
                    fontStyleDic.Add(style, new Font(fn, fontsize, FontStyle.Regular, GraphicsUnit.Pixel));
                }
            }
			return fontStyleDic[style];
		}

		public void ClearFont()
		{
			foreach (KeyValuePair<string, Dictionary<FontStyle, Font>> fontStyleDicPair in fontDic)
			{
				foreach (KeyValuePair<FontStyle, Font> pair in fontStyleDicPair.Value)
				{
					pair.Value.Dispose();
				}
				fontStyleDicPair.Value.Clear();
			}
			fontDic.Clear();
		}
		public List<KeyValuePair<string, string>> GetFiles(string rootdir, string pattern)
		{
			bool toponly = !GetConfigValue<bool>(ConfigCode.SearchSubdirectory);
			bool sort = GetConfigValue<bool>(ConfigCode.SortWithFilename);
			return getFiles(rootdir, rootdir, pattern, toponly, sort);
		}

		private List<KeyValuePair<string, string>> getFiles(string dir, string rootdir, string pattern, bool toponly, bool sort)
		{
			List<KeyValuePair<string, string>> retList = new List<KeyValuePair<string, string>>();
			if (!toponly)
			{
				string[] dirList = Directory.GetDirectories(dir, "*", SearchOption.TopDirectoryOnly);
				if (dirList.Length > 0)
				{
					if (sort)
						Array.Sort(dirList, new StrIgnoreCaseComparer());
					for (int i = 0; i < dirList.Length; i++)
						retList.AddRange(getFiles(dirList[i], rootdir,pattern,toponly, sort));
				}
			}
			string RelativePath = "";
			if (string.Equals(dir, rootdir, StringComparison.CurrentCultureIgnoreCase))
				RelativePath = "";
			else
			{
				if (!dir.StartsWith(rootdir, StringComparison.CurrentCultureIgnoreCase))
					RelativePath = dir;
				else
					RelativePath = dir.Substring(rootdir.Length);
				if (!RelativePath.EndsWith("\\") && !RelativePath.EndsWith("/"))
					RelativePath += "\\";
			}
			string[] erbFiles = Directory.GetFiles(dir, pattern, SearchOption.TopDirectoryOnly);
			if (sort)
				Array.Sort(erbFiles, new StrIgnoreCaseComparer());
			for (int i = 0; i < erbFiles.Length; i++)
                if (Path.GetExtension(erbFiles[i]).ToUpper() == ".ERB" || Path.GetExtension(erbFiles[i]).ToUpper() == ".CSV")
                    retList.Add(new KeyValuePair<string, string>(RelativePath + Path.GetFileName(erbFiles[i]), erbFiles[i]));
			return retList;
		}

		public bool NeedReduceArgumentOnLoad
		{
			get
			{

				ReduceArgumentOnLoadFlag flag = GetConfigValue<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad);
				if (flag == ReduceArgumentOnLoadFlag.ONCE)
					return updated;
				if (flag == ReduceArgumentOnLoadFlag.YES)
					return true;
				//if (flag == ReduceArgumentOnLoadFlag.NO)
				return false;
			}
		}

		private long getUpdateKey()
		{
			string csvDir = Program.ExeDir + "csv\\";
			string erbDir = Program.ExeDir + "erb\\";
			string[] erbFiles = Directory.GetFiles(erbDir, "*.ERB", SearchOption.TopDirectoryOnly);
			string[] csvFiles = Directory.GetFiles(csvDir, "*.csv", SearchOption.TopDirectoryOnly);
			long[] writetimes = new long[erbFiles.Length + csvFiles.Length];
			for (int i = 0; i < erbFiles.Length; i++)
                if (Path.GetExtension(erbFiles[i]).ToUpper() == ".ERB")
                    writetimes[i] = System.IO.File.GetLastWriteTime(erbFiles[i]).ToBinary();
			for (int i = 0; i < csvFiles.Length; i++)
                if (Path.GetExtension(csvFiles[i]).ToUpper() == ".CSV")
                    writetimes[i + erbFiles.Length] = System.IO.File.GetLastWriteTime(csvFiles[i]).ToBinary();
			long key = 0;
			for (int i = 0; i < writetimes.Length; i++)
			{
				unchecked
				{
					key ^= writetimes[i] * 1103515245 + 12345;
				}
			}
			return key;
		}

		private void checkUpdate()
		{
			ReduceArgumentOnLoadFlag flag = GetConfigValue<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad);
			if (flag != ReduceArgumentOnLoadFlag.ONCE)
				return;
			long lastKey = GetConfigValue<long>(ConfigCode.LastKey);
			updated = true;
			long key = getUpdateKey();
			updated = lastKey != key;
			GetItem(ConfigCode.LastKey).SetValue(key);
			if (updated)
				SaveConfig();
		}

		public bool SaveConfig()
		{
			StreamWriter writer = null;

			try
			{
				writer = new StreamWriter(configPath, false, Encode);
				for (int i = 0; i < configArray.Length; i++)
				{
					AConfigItem item = configArray[i];
					if (item == null)
						continue;
					if ((item.Code == ConfigCode.ChangeMasterNameIfDebug) && (item.GetValue<bool>()))
						continue;
					if ((item.Code == ConfigCode.LastKey) && (item.GetValue<long>() == 0))
						continue;
					if (item.Code == ConfigCode.IgnoreWarningFiles)
					{
						List<string> files = item.GetValue<List<string>>();
						foreach (string filename in files)
							writer.WriteLine(item.Text + ":" + filename.ToString());
						continue;
					}
					writer.WriteLine(item.ToString());
				}
			}
			catch (Exception)
			{
				return false;
			}
			finally
			{
				if (writer != null)
					writer.Close();
			}
			return true;
		}

        public bool SaveMacro()
        {
            if (!isMacroChanged)
                return true;
			StreamWriter writer = null;

			try
			{
				writer = new StreamWriter(macroPath, false, Encode);
				for (int i = 0; i < macroArray.Length; i++)
				{
					AConfigItem item = macroArray[i];
					if (item == null)
						continue;
					writer.WriteLine(item.ToString());
				}
			}
			catch (Exception)
			{
				return false;
			}
			finally
			{
				if (writer != null)
					writer.Close();
			}
			return true;
		}        

		public bool LoadConfig()
		{
			ClearFont();
			string defaultConfigPath = Program.ExeDir + "csv\\_default.config";
			string fixedConfigPath = Program.ExeDir + "csv\\_fixed.config";
			if(!File.Exists(defaultConfigPath))
				defaultConfigPath = Program.ExeDir + "csv\\default.config";
			if (!File.Exists(fixedConfigPath))
				fixedConfigPath = Program.ExeDir + "csv\\fixed.config";

			loadConfig(defaultConfigPath, false);
			loadConfig(configPath, false);
			loadConfig(fixedConfigPath, true);
			if (!File.Exists(configPath))
				SaveConfig();
			checkUpdate();
            if (Fontsize < 8)
            {
                MessageBox.Show("フォントサイズが小さすぎます(8が下限)", "設定のエラー");
                AConfigItem fsize = GetConfigItem(ConfigCode.FontSize);
                ((ConfigItem<int>)fsize).Value = 8;
            }
            if (LineHeight < Fontsize)
            {
                MessageBox.Show("行の高さがフォントサイズより小さいため、フォントサイズと同じ高さと解釈されます","設定のエラー");
                AConfigItem height = GetConfigItem(ConfigCode.LineHeight);
                ((ConfigItem<int>)height).Value = Fontsize;
            }
            if (SaveDataNos < 20)
            {
                MessageBox.Show("表示するセーブデータ数が少なすぎます(20が下限)", "設定のエラー");
                AConfigItem saves = GetConfigItem(ConfigCode.SaveDataNos);
                ((ConfigItem<int>)saves).Value = 20;
            }
            if (SaveDataNos > 80)
            {
                MessageBox.Show("表示するセーブデータ数が多すぎます(80が上限)", "設定のエラー");
                AConfigItem saves = GetConfigItem(ConfigCode.SaveDataNos);
                ((ConfigItem<int>)saves).Value = 80;
            }
            if (MaxLog < 500)
            {
                MessageBox.Show("ログ表示行数が少なすぎます(500が下限)", "設定のエラー");
                AConfigItem maxLog = GetConfigItem(ConfigCode.MaxLog);
                ((ConfigItem<int>)maxLog).Value = 500;
			}
			if(UseSaveFolder)
			{
				savDir = Program.ExeDir + "sav\\";
			}
			else
			{
				savDir = Program.ExeDir;
			}
			if (UseSaveFolder && !Directory.Exists(savDir))
			{
				try
				{
					Directory.CreateDirectory(savDir);
				}
				catch
				{
					MessageBox.Show("savフォルダの作成に失敗しました", "フォルダ作成失敗");
				}
				bool existGlobal = File.Exists(Program.ExeDir + "global.sav");
				string[] savFiles = Directory.GetFiles(Program.ExeDir, "save*.sav", SearchOption.TopDirectoryOnly);
				if (existGlobal || savFiles.Length > 0)
				{
					DialogResult result = MessageBox.Show("savフォルダを作成しました\n現在のデータをsavフォルダ内に移動しますか？", "データ移動", MessageBoxButtons.YesNo);
					if (result == DialogResult.Yes)
					{//ダイアログが開いている間にファイルを消してしまうような邪悪なユーザーがいるかもしれない
						savDir += "\\";
						try
						{
							if (File.Exists(Program.ExeDir + "global.sav"))
								File.Move(Program.ExeDir + "global.sav", savDir + "global.sav");
							foreach (string oldpath in savFiles)
								if (File.Exists(oldpath))
									File.Move(oldpath, savDir + Path.GetFileName(oldpath));
						}
						catch
						{
							MessageBox.Show("savファイルの移動に失敗しました", "移動失敗");
						}
					}
				}
			}
            return true;
		}
		private string savDir = Program.ExeDir;
		public string SavDir { get { return savDir; } }

		/// <summary>
		/// ディレクトリ作成失敗のExceptionは呼び出し元で処理すること
		/// </summary>
		public void CreateSavDir()
		{
			if (UseSaveFolder && !Directory.Exists(savDir))
			{
				Directory.CreateDirectory(savDir);
			}
		}

		private bool loadConfig(string confPath, bool fix)
		{
			if (!File.Exists(confPath))
				return false;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(confPath))
				return false;
			try
			{
				string line = null;
				bool defineIgnoreWarningFiles = false;
				while ((line = eReader.ReadLine()) != null)
				{
					if ((line.Length == 0) || (line[0] == ';'))
						continue;
					string[] tokens = line.Split(new char[] { ':' });
					if (tokens.Length < 2)
						continue;
					AConfigItem item = GetConfigItem(tokens[0].Trim());
					if (item != null)
					{
						if ((item.Code == ConfigCode.IgnoreWarningFiles))
						{ 
							if (!defineIgnoreWarningFiles)
								(item.GetValue<List<string>>()).Clear();
							defineIgnoreWarningFiles = true;
							if ((item.Fixed) && (fix))
								item.Fixed = false;
						}
                        if (item.Code == ConfigCode.TextEditor)
                        {
                            //パスの関係上tokens[2]は使わないといけない
                            if (tokens.Length > 2)
                            {
                                if (tokens[2].StartsWith("\\"))
                                    tokens[1] += ":" + tokens[2];
                                if (tokens.Length > 3)
                                {
                                    for (int i = 3; i < tokens.Length; i++)
                                    {
                                        tokens[1] += ":" + tokens[i];
                                    }
                                }
                            }
                        }
                        if (item.Code == ConfigCode.EditorArgument)
                        {
                            //半角スペースを要求する引数が必要なエディタがあるので別処理で
                            ((ConfigItem<string>)item).Value = tokens[1];
                            continue;
                        }
						if ((item.TryParse(tokens[1])) && (fix))
							item.Fixed = true;
					}
#if DEBUG
					//else
					//	throw new Exception("コンフィグファイルが変");
#endif
				}
			}
			catch { return false; }
			finally { eReader.Dispose(); }
			return true;
		}

		// 1.52a改変部分　（単位の差し替えおよび前置、後置のためのコンフィグ処理）
		public void LoadReplaceFile(string filename)
		{
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(filename))
				return;
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					if ((line.Length == 0) || (line[0] == ';'))
						continue;
                    string[] tokens = line.Split(new char[] { ',', ':' });
					if (tokens.Length < 2)
						continue;
                    string itemName = tokens[0].Trim();
                    tokens[1] = line.Substring(tokens[0].Length + 1);
                    if (string.IsNullOrEmpty(tokens[1].Trim()))
                        continue;
                    AConfigItem item = GetReplaceItem(itemName);
					if (item != null)
						item.TryParse(tokens[1]);
				}
			}
			catch { return; }
			finally { eReader.Dispose(); }
		}

        public void LoadMacroFile(string filename)
        {
            EraStreamReader eReader = new EraStreamReader();
            if (!eReader.Open(filename))
                return;
            try
            {
                string line = null;
                while ((line = eReader.ReadLine()) != null)
                {
                    if ((line.Length == 0) || (line[0] == ';'))
                        continue;
                    string[] tokens = line.Split(new char[] { ',', ':' });
                    if (tokens.Length < 2)
                        continue;
                    if (string.IsNullOrEmpty(tokens[1].Trim()))
                        continue;
                    AConfigItem item = GetMacroItem(tokens[0].Trim());
                    if (item != null)
                        item.TryParse(tokens[1]);
                }
            }
            catch { return; }
            finally { eReader.Dispose(); }
        }

        bool isMacroChanged = false;

        public void SetMacro(Keys key, string macro)
        {
            AConfigItem item;
            switch (key)
            {
                case Keys.F1:
                    item = GetMacroItem(ConfigCode.MacroF1);
                    item.TryParse(macro);
                    break;
                case Keys.F2:
                    item = GetMacroItem(ConfigCode.MacroF2);
                    item.TryParse(macro);
                    break;
                case Keys.F3:
                    item = GetMacroItem(ConfigCode.MacroF3);
                    item.TryParse(macro);
                    break;
                case Keys.F4:
                    item = GetMacroItem(ConfigCode.MacroF4);
                    item.TryParse(macro);
                    break;
                case Keys.F5:
                    item = GetMacroItem(ConfigCode.MacroF5);
                    item.TryParse(macro);
                    break;
                case Keys.F6:
                    item = GetMacroItem(ConfigCode.MacroF6);
                    item.TryParse(macro);
                    break;
                case Keys.F7:
                    item = GetMacroItem(ConfigCode.MacroF7);
                    item.TryParse(macro);
                    break;
                case Keys.F8:
                    item = GetMacroItem(ConfigCode.MacroF8);
                    item.TryParse(macro);
                    break;
                case Keys.F9:
                    item = GetMacroItem(ConfigCode.MacroF9);
                    item.TryParse(macro);
                    break;
                case Keys.F10:
                    item = GetMacroItem(ConfigCode.MacroF10);
                    item.TryParse(macro);
                    break;
                case Keys.F11:
                    item = GetMacroItem(ConfigCode.MacroF11);
                    item.TryParse(macro);
                    break;
                case Keys.F12:
                    item = GetMacroItem(ConfigCode.MacroF12);
                    item.TryParse(macro);
                    break;
                default:
                    return;
            }
            isMacroChanged = true;
        }
	}
}