using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.Sub;
using MinorShift._Library;

namespace MinorShift.Emuera.GameData
{
	internal sealed class StringForm
	{
		public StringForm(string row)
		{
			rowString = row;
		}

		string rowString;
		public string RowString { get { return rowString; } }
		string formString;
		List<IOperandTerm> argList = new List<IOperandTerm>();
		List<bool> isTernary = new List<bool>();
        List<bool> isAlign = new List<bool>();
        bool containAlignVar = false;

		public bool Reduced
		{
			get
			{
				return formString != null;
			}
		}

		private VariableToken getVariable(VariableCode code, VariableCode subCode)
		{
			VariableIdentifier subId = VariableIdentifier.GetVariableId(subCode);
			VariableToken subToken = new VariableToken(subId, new SingleTerm(0), null, null);
			VariableIdentifier id = VariableIdentifier.GetVariableId(VariableCode.NAME);
			VariableToken token = new VariableToken(id, subToken, null, null);
			return token;
		}

		public void Reduce()
		{
			Reduce(new StringStream(rowString), '\0');
		}
		public void Reduce(StringStream st, char endKey)
		{
			int start = st.CurrentPosition;
			if (this.Reduced)
				return;
			StringBuilder buffer = new StringBuilder();
			int countArg = 0;
			while (!st.EOS && (st.Current != endKey))
			{
				char expStart = st.Current;
				if ((st.Current == '%') || (st.Current == '{'))
				{
					//1.712 式中で関数を使える機能に対応させ{MAX(A,B)}とかが,で切られないように修正
					//ついでに{}と%%を統一
					char expEnd = '}';
					if (st.Current == '%')
						expEnd = '%';

					st.ShiftNext();
                    if (expEnd == '%')
                    {
                        if (st.ToString().IndexOf("\\@") == -1)
                            isTernary.Add(false);
                        else
                        {
                            StringStream tSt = new StringStream(st.ToString().Substring(st.CurrentPosition));
                            isTernary.Add(ExpressionParser.checkTernary(tSt));
                        }
                        argList.Add(ExpressionParser.ReduceStringTerm(st, new char[]{','}));
                        isAlign.Add(false);
                    }
                    else
                    {
                        argList.Add(ExpressionParser.ReduceIntegerTerm(st, new char[]{'}', ','}));
                        isTernary.Add(false);
                        isAlign.Add(false);
                    }
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					if (st.Current == ',')
					{
						st.ShiftNext();
                        TokenReader.SkipWhiteSpace(st);
						buffer.Append(",");

                        IOperandTerm alignTerm = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',', expEnd });
						if (st.Current == ',')
						{
							st.ShiftNext();
							string str2 = TokenReader.ReadStringEndWith(st, new char[] { ',', expEnd });
							str2 = str2.Trim().ToUpper();
                            if (str2 == "LEFT")
                            {
                                buffer.Append("-");
                            }
                            else if (str2 != "RIGHT")
                                throw new CodeEE("第3項の指定はLEFTもしくはRIGHTのみです");
						}
                        countArg++;
                        buffer.Append("{");
                        buffer.Append(countArg);
                        buffer.Append("}");
                        argList.Add(alignTerm);
                        isTernary.Add(false);
                        isAlign.Add(true);
                        containAlignVar = true;
						if (st.Current == ',')
							throw new CodeEE("\',\'の数が多すぎます");
					}
					buffer.Append("}");
					countArg++;
					if (st.Current != expEnd)
					{
						if (expEnd == '%')
							throw new CodeEE("\'%\'が使われましたが対応する\'%\'が見つかりません");
						else
							throw new CodeEE("\'{\'が使われましたが対応する\'}\'が見つかりません");
					}
					st.ShiftNext();
					continue;
				}
				else if (st.Current == '}')
				{
					throw new CodeEE("\'}\'が使われましたが対応する\'{\'が見つかりません");
				}
				else if (st.CurrentEqualTo("***"))
				{
                    st.Jump(3);
					VariableToken token = getVariable(VariableCode.NAME, VariableCode.TARGET);
					argList.Add(token);
					isTernary.Add(false);
                    isAlign.Add(false);
					buffer.Append('{');
					buffer.Append(countArg.ToString());
					buffer.Append('}');
					countArg++;
					continue;
				}
				else if (st.CurrentEqualTo("+++"))
				{
                    st.Jump(3);
                    VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.MASTER);
					argList.Add(token);
					isTernary.Add(false);
                    isAlign.Add(false);
                    buffer.Append('{');
					buffer.Append(countArg.ToString());
					buffer.Append('}');
					countArg++;
					continue;
				}
				else if (st.CurrentEqualTo("==="))
				{
                    st.Jump(3);
                    VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.PLAYER);
					argList.Add(token);
					isTernary.Add(false);
                    isAlign.Add(false);
                    buffer.Append('{');
					buffer.Append(countArg.ToString());
					buffer.Append('}');
					countArg++;
					continue;
				}
				else if (st.CurrentEqualTo("///"))
				{
                    st.Jump(3);
                    //1740 VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.ASSI);
                    VariableToken token = getVariable(VariableCode.NAME, VariableCode.ASSI);
					argList.Add(token);
					isTernary.Add(false);
                    isAlign.Add(false);
                    buffer.Append('{');
					buffer.Append(countArg.ToString());
					buffer.Append('}');
					countArg++;
					continue;
				}
				else if (st.CurrentEqualTo("$$$"))
				{
                    st.Jump(3);
                    VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.TARGET);
					argList.Add(token);
					isTernary.Add(false);
                    isAlign.Add(false);
                    buffer.Append('{');
					buffer.Append(countArg.ToString());
					buffer.Append('}');
					countArg++;
					continue;
				}
				//エスケープ文字の使用
				else if (st.Current == '\\')
				{
					st.ShiftNext();
					switch (st.Current)
					{
						case StringStream.EndOfString:
							throw new CodeEE("エスケープ文字\\の後に文字がありません");
						case '\n':
							break;
						case 's':
							buffer.Append(' ');
							break;
						case 'S':
							buffer.Append('　');
							break;
						case 't':
							buffer.Append('\t');
							break;
						case 'n':
							buffer.Append('\n');
							break;
						case '{':
							buffer.Append('{');
							buffer.Append('{');
							break;
						case '}':
							buffer.Append('}');
							buffer.Append('}');
							break;
						case '@':
							st.ShiftNext();

                            string ternaryStr = ExpressionParser.resolveEscape(st);
                            if (ternaryStr == null)
                                throw new CodeEE("対応する\\@が見つかりません");

							argList.Add(ExpressionParser.ReduceTernaryStringTerm(ternaryStr));
							isTernary.Add(true);
                            isAlign.Add(false);
                            buffer.Append('{');
							buffer.Append(countArg.ToString());
							buffer.Append('}');
							countArg++;
							break;
						default:
							buffer.Append(st.Current);
							break;
					}
					st.ShiftNext();
					continue;
				}
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			formString = buffer.ToString();
			if ((start != 0) || (!st.EOS))
				rowString = st.Substring(start, st.CurrentPosition - start);
		}

		//private int ParseInner(string[] str, StringStream st, char endWrite)
		//{
		//    int count = 0;
		//    StringBuilder tempBuf = new StringBuilder();
		//    while (st.Current != endWrite)
		//    {
		//        if (st.EOS)
		//            throw new CodeEE("\'" + endWrite.ToString() + "\'が使われましたが対応する\'" + endWrite.ToString() + "\'が見つかりません");
		//        if (st.Current == ',')
		//        {
		//            str[count] = tempBuf.ToString();
		//            tempBuf = new StringBuilder();
		//            count++;
		//            if (count == 3)
		//                throw new CodeEE("\',\'の数が多すぎます");
		//            st.ShiftNext();
		//            continue;
		//        }
		//        tempBuf.Append(st.Current);
		//        st.ShiftNext();
		//    }
		//    str[count] = tempBuf.ToString();
		//    return count;
		//}

		public string GetString(ExpressionEvaluator eEvaluator)
		{
			if (!this.Reduced)
				this.Reduce();
			string[] objArgList = new string[argList.Count];
			string tempFormString = formString;
            //桁数の変数を先に還元
            if (containAlignVar)
            {
                for (int i = 0; i < objArgList.Length; i++)
                {
                    if (!isAlign[i])
                        continue;
                    Int64 align = eEvaluator.GetInteger(argList[i]);
                    objArgList[i] = align.ToString();
                    tempFormString = tempFormString.Replace(String.Format("{{{0}}}", i.ToString()), String.Format("{0}", objArgList[i]));
                    if (tempFormString.Contains("--" + String.Format("{0}", Math.Abs(align))))
                        tempFormString.Replace("--" + String.Format("{0}", Math.Abs(align)), String.Format("{0}", Math.Abs(align)));
                }
            }

            for (int i = 0; i < objArgList.Length; i++)
			{
                if (isAlign[i])
                    continue;
				IOperandTerm term = argList[i];
				if (term.GetOperandType() == typeof(Int64))
					objArgList[i] = eEvaluator.GetInteger(term).ToString();
				else if (term.GetOperandType() == typeof(string))
				{
					if (isTernary[i])
					{
						StringForm tSf = new StringForm(eEvaluator.GetString(term));
						tSf.Reduce();
						objArgList[i] = tSf.GetString(eEvaluator);
					}
					else
						objArgList[i] = eEvaluator.GetString(term);
				}
				if (objArgList[i].Length != ShiftJisManager.GetStrlenShiftJis(objArgList[i]))
				{
					string sstr = String.Format("{{{0},", i);
					int index = tempFormString.IndexOf(sstr);
					if (index >= 0)
					{
						index += sstr.Length;
                        int shrink = ShiftJisManager.GetStrlenShiftJis(objArgList[i]) - objArgList[i].Length;
                        int lastindex = tempFormString.IndexOf('}', index);
                        int BaseLength = Convert.ToInt32(tempFormString.Substring(index, lastindex - index));
                        int NewLength = (Math.Abs(BaseLength) - shrink);
                        if (NewLength < 0)
							NewLength = 0;
						NewLength *= Math.Sign(BaseLength);
                        tempFormString = tempFormString.Replace(String.Format("{{{0},{1}}}", i.ToString(), BaseLength.ToString()), String.Format("{{{0},{1}}}", i.ToString(), NewLength.ToString()));
                    }
				}
			}
			return string.Format(tempFormString, objArgList);
		}
		public string Format
		{
			get
			{
				if (!this.Reduced)
					this.Reduce();
				return formString;
			}
		}

		public List<IOperandTerm> ArgList
		{
			get
			{
				if (!this.Reduced)
					this.Reduce();
				return argList;
			}
		}

	}
}