using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData
{
	internal sealed class GameBase
	{
		public string ScriptAutherName = "";
		public string ScriptDetail = "";//詳細な説明
		public string ScriptYear = "";
		public string ScriptTitle = "";
		public int ScriptUniqueCode = 0;
		//1.713 訂正。バージョンの初期値は0ではなく1000だった
		public int ScriptVersion = 0;//1000;
		//上の変更とあわせて。セーブデータのバージョンが1000であり、現在のバージョンが未定義である場合、セーブデータのバージョンを同じとみなす
		public bool ScriptVersionDefined = false;
		public int ScriptCompatibleMinVersion = -1;

		//1.727 追加。Form.Text
		public string ScriptWindowTitle = null;
		public string ScriptVersionText
		{
			get
			{
				StringBuilder versionStr = new StringBuilder();
				versionStr.Append((ScriptVersion / 1000).ToString());
				versionStr.Append(".");
				if ((ScriptVersion % 10) != 0)
					versionStr.Append((ScriptVersion % 1000).ToString("000"));
				else
					versionStr.Append((ScriptVersion % 1000 / 10).ToString("00"));
				return versionStr.ToString();
			}
		}

		public int DefaultCharacter = -1;
		public int DefaultNoItem = 0;

		public void LoadGameBaseCsv(string basePath)
		{
			if (!File.Exists(basePath))
				return;

			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(basePath))
			{
				//output.PrintLine(eReader.Filename + "のオープンに失敗しました");
				return;
			}
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					if ((line.Length == 0) || (line[0] == ';'))
						continue;
					string[] tokens = line.Split(',');
					if (tokens.Length < 2)
						continue;
					string param = tokens[1].Trim();
					int i = 0;
					switch (tokens[0])
					{
						case "コード":
							if(Int32.TryParse(tokens[1], out i))
								ScriptUniqueCode = i;
                            else
                            {
                                StringStream st = new StringStream(tokens[1]);
                                StringBuilder sb = new StringBuilder();

                                while (true)
                                {
                                    if (st.EOS)
                                        break;
                                    if (!char.IsNumber(st.Current))
                                        break;
                                    sb.Append(st.Current);
                                    st.ShiftNext();
                                }
                                if (sb.Length > 0)
                                    Int32.TryParse(sb.ToString(), out ScriptUniqueCode);
                            }
							break;
						case "バージョン":
                            if (Int32.TryParse(tokens[1], out i))
                            {
                                ScriptVersionDefined = true;
                                ScriptVersion = i;
                            }
                            else
                            {
                                StringStream st = new StringStream(tokens[1]);
                                StringBuilder sb = new StringBuilder();

                                while (true)
                                {
                                    if (st.EOS)
                                        break;
                                    if (!char.IsNumber(st.Current))
                                        break;
                                    sb.Append(st.Current);
                                    st.ShiftNext();
                                }
                                if (sb.Length > 0)
                                {
                                    Int32.TryParse(sb.ToString(), out ScriptVersion);
                                    ScriptVersionDefined = true;
                                }
                            }
							break;
						case "バージョン違い認める":
							if(Int32.TryParse(tokens[1], out i))
								ScriptCompatibleMinVersion = i;
                            else
                            {
                                StringStream st = new StringStream(tokens[1]);
                                StringBuilder sb = new StringBuilder();

                                while (true)
                                {
                                    if (st.EOS)
                                        break;
                                    if (!char.IsNumber(st.Current))
                                        break;
                                    sb.Append(st.Current);
                                    st.ShiftNext();
                                }
                                if (sb.Length > 0)
                                    Int32.TryParse(sb.ToString(), out ScriptCompatibleMinVersion);
                            }
							break;
						case "最初からいるキャラ":
							if(Int32.TryParse(tokens[1], out i))
								DefaultCharacter = i;
                            else
                            {
                                StringStream st = new StringStream(tokens[1]);
                                StringBuilder sb = new StringBuilder();

                                while (true)
                                {
                                    if (st.EOS)
                                        break;
                                    if (!char.IsNumber(st.Current))
                                        break;
                                    sb.Append(st.Current);
                                    st.ShiftNext();
                                }
                                if (sb.Length > 0)
                                    Int32.TryParse(sb.ToString(), out DefaultCharacter);
                            }
							break;
						case "アイテムなし":
							if(Int32.TryParse(tokens[1], out i))
								DefaultNoItem = i;
                            else
                            {
                                StringStream st = new StringStream(tokens[1]);
                                StringBuilder sb = new StringBuilder();

                                while (true)
                                {
                                    if (st.EOS)
                                        break;
                                    if (!char.IsNumber(st.Current))
                                        break;
                                    sb.Append(st.Current);
                                    st.ShiftNext();
                                }
                                if (sb.Length > 0)
                                    Int32.TryParse(sb.ToString(), out DefaultNoItem);
                            }
							break;
						case "タイトル":
							ScriptTitle = tokens[1];
							break;
						case "作者":
							ScriptAutherName = tokens[1];
							break;
						case "製作年":
							ScriptYear = tokens[1];
							break;
						case "追加情報":
							ScriptDetail = tokens[1];
							break;
						case "ウィンドウタイトル":
							ScriptWindowTitle = tokens[1];
							break;

					}

				}
			}
			catch
			{
				return;
			}
			finally
			{
				eReader.Close();
			}
			if (ScriptWindowTitle == null)
			{
				if (string.IsNullOrEmpty(ScriptTitle))
					ScriptWindowTitle = "Emuera";
				else
					ScriptWindowTitle = ScriptTitle + " " + ScriptVersionText;
			}
			return;
		}

	}





}
