using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.GameData.Variable
{
	internal enum VariableCode
	{
		__NULL__ = 0x00000000,
		__INTEGER__ = 0x00020000,
		__STRING__ = 0x00040000,
		__ARRAY_1D__ = 0x00080000,
		__CHARACTER_DATA__ = 0x00100000,//第一引数を省略可能。TARGETで補う
		__UNCHANGEABLE__ = 0x00400000,//変更不可属性
		__CALC__ = 0x00800000,//計算値
		__EXTENDED__ = 0x01000000,//Emueraで追加した変数
		__LOCAL__ = 0x02000000,//ローカル変数。
		__GLOBAL__ = 0x04000000,//グローバル変数。
		__ARRAY_2D__ = 0x08000000,//二次元配列。キャラクタ変数フラグと排他
		__SAVE_EXTENDED__ = 0x10000000,//拡張セーブ機能によってセーブするべき変数。
							//このフラグを立てておけば勝手にセーブされる(はず)。名前を変えると正常にロードできなくなるので注意。
        __ARRAY_3D__ = 0x20000000,//三次元配列

		__UPPERCASE__ = 0x7FFF0000,
		__LOWERCASE__ = 0x0000FFFF,

		__COUNT_SAVE_INTEGER__ = 0x00,//実は全て配列
		__COUNT_INTEGER__ = 0x00,

		DAY = 0x00 | __INTEGER__ | __ARRAY_1D__,//経過日数。
		MONEY = 0x01 | __INTEGER__ | __ARRAY_1D__,//金
		ITEM = 0x02 | __INTEGER__ | __ARRAY_1D__,//所持数
		FLAG = 0x03 | __INTEGER__ | __ARRAY_1D__,//フラグ
		TFLAG = 0x04 | __INTEGER__ | __ARRAY_1D__,//一時フラグ
		UP = 0x05 | __INTEGER__ | __ARRAY_1D__,//調教中パラメータの上昇値。indexはPALAM.CSVのもの。
		PALAMLV = 0x06 | __INTEGER__ | __ARRAY_1D__,//調教中パラメータのレベルわけの境界値。境界値を越えると珠の数が多くなる。
		EXPLV = 0x07 | __INTEGER__ | __ARRAY_1D__,//経験のレベルわけの境界値。境界値を越えると調教の効果が上がる。
		EJAC = 0x08 | __INTEGER__ | __ARRAY_1D__,//射精チェックのための一時変数。
		DOWN = 0x09 | __INTEGER__ | __ARRAY_1D__,//調教中パラメータの減少値。indexはPALAM.CSVのもの
		RESULT = 0x0A | __INTEGER__ | __ARRAY_1D__,//戻り値(数値)
		COUNT = 0x0B | __INTEGER__ | __ARRAY_1D__,//繰り返しカウンター
		TARGET = 0x0C | __INTEGER__ | __ARRAY_1D__,//調教中のキャラの"登録番号"
		ASSI = 0x0D | __INTEGER__ | __ARRAY_1D__,//助手のキャラの"登録番号"
		MASTER = 0x0E | __INTEGER__ | __ARRAY_1D__,//主人公のキャラの"登録番号"。通常0
		NOITEM = 0x0F | __INTEGER__ | __ARRAY_1D__,//アイテムが存在しないか？存在しない設定なら１．GAMEBASE.CSV
		LOSEBASE = 0x10 | __INTEGER__ | __ARRAY_1D__,//基礎パラメータの減少値。通常はLOSEBASE:0が体力の消耗、LOSEBASE:1が気力の消耗。
		SELECTCOM = 0x11 | __INTEGER__ | __ARRAY_1D__,//選択されたコマンド。TRAIN.CSVのものと同じ
		ASSIPLAY = 0x12 | __INTEGER__ | __ARRAY_1D__,//助手現在調教しているか？1 = true, 0 = false
		PREVCOM = 0x13 | __INTEGER__ | __ARRAY_1D__,//前回のコマンド。
		NOTUSE_14 = 0x14 | __INTEGER__ | __ARRAY_1D__,//eramakerではRANDが格納されている領域。
		NOTUSE_15 = 0x15 | __INTEGER__ | __ARRAY_1D__,//eramakerではCHARANUMが格納されている領域。
		TIME = 0x16 | __INTEGER__ | __ARRAY_1D__,//時刻
		ITEMSALES = 0x17 | __INTEGER__ | __ARRAY_1D__,//売っているか？
		PLAYER = 0x18 | __INTEGER__ | __ARRAY_1D__,//調教している人間のキャラの登録番号。通常はMASTERかASSI
		NEXTCOM = 0x19 | __INTEGER__ | __ARRAY_1D__,//調教している人間のキャラの登録番号。通常はMASTERかASSI
		PBAND = 0x1A | __INTEGER__ | __ARRAY_1D__,//ペニスバンドのアイテム番号
		BOUGHT = 0x1B | __INTEGER__ | __ARRAY_1D__,//直前に購入したアイテム番号
		NOTUSE_1C = 0x1C | __INTEGER__ | __ARRAY_1D__,//未使用領域
		NOTUSE_1D = 0x1D | __INTEGER__ | __ARRAY_1D__,//未使用領域
		A = 0x1E | __INTEGER__ | __ARRAY_1D__,//汎用変数
		B = 0x1F | __INTEGER__ | __ARRAY_1D__,
		C = 0x20 | __INTEGER__ | __ARRAY_1D__,
		D = 0x21 | __INTEGER__ | __ARRAY_1D__,
		E = 0x22 | __INTEGER__ | __ARRAY_1D__,
		F = 0x23 | __INTEGER__ | __ARRAY_1D__,
		G = 0x24 | __INTEGER__ | __ARRAY_1D__,
		H = 0x25 | __INTEGER__ | __ARRAY_1D__,
		I = 0x26 | __INTEGER__ | __ARRAY_1D__,
		J = 0x27 | __INTEGER__ | __ARRAY_1D__,
		K = 0x28 | __INTEGER__ | __ARRAY_1D__,
		L = 0x29 | __INTEGER__ | __ARRAY_1D__,
		M = 0x2A | __INTEGER__ | __ARRAY_1D__,
		N = 0x2B | __INTEGER__ | __ARRAY_1D__,
		O = 0x2C | __INTEGER__ | __ARRAY_1D__,
		P = 0x2D | __INTEGER__ | __ARRAY_1D__,
		Q = 0x2E | __INTEGER__ | __ARRAY_1D__,
		R = 0x2F | __INTEGER__ | __ARRAY_1D__,
		S = 0x30 | __INTEGER__ | __ARRAY_1D__,
		T = 0x31 | __INTEGER__ | __ARRAY_1D__,
		U = 0x32 | __INTEGER__ | __ARRAY_1D__,
		V = 0x33 | __INTEGER__ | __ARRAY_1D__,
		W = 0x34 | __INTEGER__ | __ARRAY_1D__,
		X = 0x35 | __INTEGER__ | __ARRAY_1D__,
		Y = 0x36 | __INTEGER__ | __ARRAY_1D__,
		Z = 0x37 | __INTEGER__ | __ARRAY_1D__,
		NOTUSE_38 = 0x38 | __INTEGER__ | __ARRAY_1D__,//未使用領域
		NOTUSE_39 = 0x39 | __INTEGER__ | __ARRAY_1D__,//未使用領域
		NOTUSE_3A = 0x3A | __INTEGER__ | __ARRAY_1D__,//未使用領域
		NOTUSE_3B = 0x3B | __INTEGER__ | __ARRAY_1D__,//未使用領域
		__COUNT_SAVE_INTEGER_ARRAY__ = 0x3C,

		ITEMPRICE = 0x3C | __INTEGER__ | __ARRAY_1D__ | __UNCHANGEABLE__ | __EXTENDED__,//アイテム価格
		LOCAL = 0x3D | __INTEGER__ | __ARRAY_1D__ | __LOCAL__ | __EXTENDED__,//ローカル変数
		ARG = 0x3E | __INTEGER__ | __ARRAY_1D__ | __LOCAL__ | __EXTENDED__,//関数の引数用
		GLOBAL = 0x3F | __INTEGER__ | __ARRAY_1D__ | __GLOBAL__ | __EXTENDED__,//グローバル数値型変数
		RANDDATA = 0x40 | __INTEGER__ | __ARRAY_1D__ | __SAVE_EXTENDED__ | __EXTENDED__,//グローバル数値型変数
		__COUNT_INTEGER_ARRAY__ = 0x41,


		SAVESTR = 0x00 | __STRING__ | __ARRAY_1D__,//文字列データ。保存される
        TSTR = 0x06 | __STRING__ | __ARRAY_1D__ | __SAVE_EXTENDED__ | __EXTENDED__,

		__COUNT_SAVE_STRING_ARRAY__ = 0x01,
		STR = 0x01 | __STRING__ | __ARRAY_1D__,//文字列データ。STR.CSV。書き換え可能。
		RESULTS = 0x02 | __STRING__ | __ARRAY_1D__,//実はこいつも配列
		LOCALS = 0x03 | __STRING__ | __ARRAY_1D__ | __LOCAL__ | __EXTENDED__, //ローカル文字列変数
		ARGS = 0x04 | __STRING__ | __ARRAY_1D__ | __LOCAL__ | __EXTENDED__,//関数の引数用
		GLOBALS = 0x05 | __STRING__ | __ARRAY_1D__ | __GLOBAL__ | __EXTENDED__, //グローバル文字列変数

		__COUNT_STRING_ARRAY__ = 0x07,



		SAVEDATA_TEXT = 0x00 | __STRING__ | __EXTENDED__, //セーブ時につかう文字列。PUTFORMで追加できるやつ
		__COUNT_SAVE_STRING__ = 0x00,
		__COUNT_STRING__ = 0x01,






		ISASSI = 0x00 | __INTEGER__ | __CHARACTER_DATA__,//助手か？1 = ture, 0 = false
		NO = 0x01 | __INTEGER__ | __CHARACTER_DATA__,//キャラ番号

		__COUNT_SAVE_CHARACTER_INTEGER__ = 0x02,//こいつらは配列ではないらしい。
		__COUNT_CHARACTER_INTEGER__ = 0x02,

		BASE = 0x00 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//基礎パラメータ。
		MAXBASE = 0x01 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//基礎パラメータの最大値。
		ABL = 0x02 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//能力。ABL.CSV
		TALENT = 0x03 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//素質。TALENT.CSV
		EXP = 0x04 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//経験。EXP.CSV
		MARK = 0x05 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//刻印。MARK.CSV
		PALAM = 0x06 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//調教中パラメータ。PALAM.CSV
		SOURCE = 0x07 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//調教中パラメータ。直前のコマンドで発生した調教ソース。
		EX = 0x08 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//調教中パラメータ。この調教中、どこで何回絶頂したか。
		CFLAG = 0x09 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//フラグ。
		JUEL = 0x0A | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//珠。PALAM.CSV
		RELATION = 0x0B | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//関係。indexは登録番号ではなくキャラ番号
		EQUIP = 0x0C | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//未使用変数
		TEQUIP = 0x0D | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//調教中パラメータ。アイテムを使用中か。ITEM.CSV
		STAIN = 0x0E | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//調教中パラメータ。汚れ
		GOTJUEL = 0x0F | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//調教中パラメータ。今回獲得した珠。PALAM.CSV
		NOWEX = 0x10 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__,//調教中パラメータ。直前のコマンドでどこで何回絶頂したか。
        DOWNBASE = 0x11 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__ | __SAVE_EXTENDED__ | __EXTENDED__, //調教中パラメータ。LOSEBASEのキャラクタ変数版
        CUP = 0x12 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__ | __SAVE_EXTENDED__ | __EXTENDED__,//調教中パラメータ。UPのキャラクタ変数版
        CDOWN = 0x13 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__ | __SAVE_EXTENDED__ | __EXTENDED__,//調教中パラメータ。DOWNのキャラクタ変数版
        TCVAR = 0x14 | __INTEGER__ | __CHARACTER_DATA__ | __ARRAY_1D__ | __SAVE_EXTENDED__ | __EXTENDED__,//キャラクタ変数での一時変数


		__COUNT_SAVE_CHARACTER_INTEGER_ARRAY__ = 0x11,
		__COUNT_CHARACTER_INTEGER_ARRAY__ = 0x54,

		NAME = 0x00 | __STRING__ | __CHARACTER_DATA__,//名前//登録番号で呼び出す
		CALLNAME = 0x01 | __STRING__ | __CHARACTER_DATA__,//呼び名
		NICKNAME = 0x02 | __STRING__ | __CHARACTER_DATA__ | __SAVE_EXTENDED__ | __EXTENDED__,//あだ名
		MASTERNAME = 0x03 | __STRING__ | __CHARACTER_DATA__ | __SAVE_EXTENDED__ | __EXTENDED__,//あだ名

		__COUNT_SAVE_CHARACTER_STRING__ = 0x02,
		__COUNT_CHARACTER_STRING__ = 0x04,

		CSTR = 0x00 | __STRING__ | __CHARACTER_DATA__ | __ARRAY_1D__ | __SAVE_EXTENDED__ | __EXTENDED__,//キャラクタ用文字列配列

		__COUNT_SAVE_CHARACTER_STRING_ARRAY__ = 0x00,
		__COUNT_CHARACTER_STRING_ARRAY__ = 0x01,


		DITEMTYPE = 0x00 | __INTEGER__ | __ARRAY_2D__ | __SAVE_EXTENDED__ | __EXTENDED__,
		DA = 0x01 | __INTEGER__ | __ARRAY_2D__ | __SAVE_EXTENDED__ | __EXTENDED__,
		DB = 0x02 | __INTEGER__ | __ARRAY_2D__ | __SAVE_EXTENDED__ | __EXTENDED__,
		DC = 0x03 | __INTEGER__ | __ARRAY_2D__ | __SAVE_EXTENDED__ | __EXTENDED__,
		DD = 0x04 | __INTEGER__ | __ARRAY_2D__ | __SAVE_EXTENDED__ | __EXTENDED__,
		DE = 0x05 | __INTEGER__ | __ARRAY_2D__ | __SAVE_EXTENDED__ | __EXTENDED__,
        __COUNT_INTEGER_ARRAY_2D__ = 0x06,

		__COUNT_STRING_ARRAY_2D__ = 0x00,

        TA = 0x00 | __INTEGER__ | __ARRAY_3D__ | __SAVE_EXTENDED__ | __EXTENDED__,
        TB = 0x01 | __INTEGER__ | __ARRAY_3D__ | __SAVE_EXTENDED__ | __EXTENDED__,
        __COUNT_INTEGER_ARRAY_3D__ = 0x02,

        __COUNT_STRING_ARRAY_3D__ = 0x00,

		//CALCな変数については番号順はどうでもいい。
		
		RAND = 0x00 | __INTEGER__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__,//乱数。０～引数-1までの値を返す。
		CHARANUM = 0x01 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__,//キャラクタ数。キャラクタ登録数を返す。

		ABLNAME = 0x00 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__,//能力。ABL.CSV//csvから読まれるデータは保存されない。変更不可
		TALENTNAME = 0x01 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__,//素質。TALENT.CSV
		EXPNAME = 0x02 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__,//経験。EXP.CSV
		MARKNAME = 0x03 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__,//刻印。MARK.CSV
		PALAMNAME = 0x04 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__,//能力。PALAM.CSV
		ITEMNAME = 0x05 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__,//アイテム。ITEM.CSV
		TRAINNAME = 0x06 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//調教名。TRAIN.CSV
		BASENAME = 0x07 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//基礎能力名。BASE.CSV
		SOURCENAME = 0x08 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//調教ソース名。SOURCE.CSV
		EXNAME = 0x09 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//絶頂名。EX.CSV
		EQUIPNAME = 0x0A | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//装着物名。EQUIP.CSV
		TEQUIPNAME = 0x0B | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//調教時装着物名。TEQUIP.CSV
		FLAGNAME = 0x0C | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//フラグ名。FLAG.CSV
		TFLAGNAME = 0x0D | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//一時フラグ名。TFLAG.CSV
		CFLAGNAME = 0x0E | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//キャラクタフラグ名。CFLAG.CSV
        TCVARNAME = 0x0F | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,
		CSTRNAME = 0x10 | __STRING__ | __ARRAY_1D__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,

		GAMEBASE_AUTHER = 0x04 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//文字列型。作者。綴りを間違えていたが互換性のため残す。
		GAMEBASE_AUTHOR = 0x00 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//文字列型。作者
		GAMEBASE_INFO = 0x01 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//文字列型。追加情報
		GAMEBASE_YEAR = 0x02 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//文字列型。製作年
		GAMEBASE_TITLE = 0x03 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//文字列型。タイトル
		WINDOW_TITLE = 0x05 | __STRING__ | __CALC__ | __EXTENDED__,//文字列型。ウインドウのタイトル。変更可能。
		__FILE__ = 0x06 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//現在実行中のファイル名
		__FUNCTION__ = 0x07 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//現在実行中の関数名
		//アンダースコア2つで囲まれた変数を追加したらVariableIdentifierに特別な処理が必要。

		LASTLOAD_TEXT = 0x05 | __STRING__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。

		GAMEBASE_GAMECODE = 0x00 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。コード
		GAMEBASE_VERSION = 0x01 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。バージョン
		GAMEBASE_ALLOWVERSION = 0x02 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。バージョン違い認める
		GAMEBASE_DEFAULTCHARA = 0x03 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。最初からいるキャラ
		GAMEBASE_NOITEM = 0x04 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。アイテムなし

		LASTLOAD_VERSION = 0x05 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。
		LASTLOAD_NO = 0x06 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//数値型。
		__LINE__ = 0x07 | __INTEGER__ | __CALC__ | __UNCHANGEABLE__ | __EXTENDED__,//現在実行中の行番号

	}
}
