using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Variable
{
	/// <summary>
	/// 変数一個分
	/// </summary>
	internal sealed class VariableToken : IOperandTerm
	{
		public VariableToken(VariableIdentifier theId, IOperandTerm p1, IOperandTerm p2, IOperandTerm p3)
		{
			//rowString = row;
			id = theId;
			subId1 = p1;
			subId2 = p2;
            subId3 = p3;
			if (id.IsInteger)
				type = typeof(Int64);
			else if (id.IsString)
				type = typeof(string);
		}
		readonly VariableIdentifier id;
		readonly IOperandTerm subId1 = null;
		readonly IOperandTerm subId2 = null;
        readonly IOperandTerm subId3 = null;
		readonly Type type;

		internal VariableIdentifier Identifier
		{
			get { return id; }
		}


		internal IOperandTerm Element1
		{
			get { return subId1; }
		}


		internal IOperandTerm Element2
		{
			get { return subId2; }
		}

        internal IOperandTerm Element3
        {
            get { return subId3; }
        }
		internal bool IsInteger { get { return id.IsInteger; } }
		internal bool IsString { get { return id.IsString; } }
		#region IOperandTerm メンバ


		public bool IsConstant
		{
			get { return false; }
		}

		public Type GetOperandType()
		{
			return type;
		}
		#endregion


		#region IKiriScript メンバ

		public string ToKiriScript()
		{
			throw new Exception("The method or operation is not implemented.");
		}

		public string ToErbScript()
		{
			throw new Exception("The method or operation is not implemented.");
		}
		public int KiriScriptPriority
		{
			get { return -1; }
		}

		#endregion

	}
}
