using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift._Library
{
	public static class ShiftJisManager
	{

		static Encoding shiftJis = Encoding.GetEncoding("SHIFT-JIS");

		public static int GetStrlenShiftJis(string str)
		{
			return shiftJis.GetByteCount(str);
		}

		public static int GetUFTIndex(string str, int JISindex)
		{
			if (JISindex <= 0)
				return 0;
			int totalByte = GetStrlenShiftJis(str);
			if (JISindex >= totalByte)
				return str.Length;
			int UTFcnt = 0;
			int JIScnt = 0;
			for (int i = 0; i < str.Length; i++)
			{
				JIScnt += shiftJis.GetByteCount(str[UTFcnt].ToString());
				UTFcnt++;
				if (JIScnt >= JISindex)
					break;
			}
			return UTFcnt;
		}

		public static string GetSubStringShiftJis(string str, int startindex, int length)
		{
			int totalByte = GetStrlenShiftJis(str);
			if ((startindex >= totalByte) || (length == 0))
				return "";
			if ((length < 0) || (length > totalByte))
				length = totalByte;

			StringBuilder ret = new StringBuilder();
			int UTFcnt = 0;
			int JIScnt = 0;

			if (startindex <= 0)
			{
				if (length == totalByte)
					return str;
			}
			else
			{
				for (int i = 0; i < str.Length; i++)
				{
					JIScnt += shiftJis.GetByteCount(str[UTFcnt].ToString());
					UTFcnt++;
					if (JIScnt >= startindex)
						break;
				}
			}

			JIScnt = 0;
			while (true)
			{
				ret.Append(str[UTFcnt]);
				JIScnt += shiftJis.GetByteCount(str[UTFcnt].ToString());
				UTFcnt++;
				if (JIScnt >= length)
					break;
				if (UTFcnt >= str.Length)
					break;
			}
			return ret.ToString();
		}

	}
}
