using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.Sub
{


	//1.60-引数タイプの残り数がやばいのでlong化
	//1.704 抜本的な対策が必要かなあ
	//1.709 よく考えたらARGは重複しないからフラグ形式の必要ないよね。long化は不要だった。
	internal enum BuiltInFunctionCode
	{
		__NULL__ = 0x0000,
		__FLOW_CONTROL__ = 0x10000,
		__EXTENDED__ = 0x20000,//Emuera拡張命令
		__METHOD_SAFE__ = 0x40000,//#Function中で呼び出してよい命令。WAITなど入力を伴うもの、CALLなど関数呼び出しを伴うものは不可。
		__DEBUG__ = 0x80000,//-Debug引数付きで起動した場合にのみ実行される命令。
		//__ARG_METHOD__ = 0x80000,//0x280000へ移動。ARG引数と排他なので問題ないはず

		__ARG_VOID__ = 0x00100000,//なし
		__ARG_INT_EXPRESSION__ = 0x00200000,//数式型
        __ARG_STR_EXPRESSION__ = 0x00300000,//文字列式型
		__ARG_STR__ = 0x00500000,//単純文字列型
        __ARG_FORM_STR__ = 0x00600000,//書式付文字列型
        __ARG_SP_PRINTV__ = 0x00700000,//複数数式型。'～～,文字列可
		__ARG_SP_TIMES__ = 0x00800000,//<数値型変数>,<実数定数>
		__ARG_SP_BAR__ = 0x00900000,//<数値>,<数値>,<数値>
		__ARG_SP_SET__ = 0x00A00000,//可変数値変数・数式型。
		__ARG_SP_SETS__ = 0x00B00000,//可変文字列変数・単純又は複合文字列型。
		//__ARG_SP_SUBSTRING__ = 0x00C00000,//<文字列式>,<数値>,<数値>
		__ARG_SP_SWAP__ = 0x00D00000,//<数値>,<数値>
		__ARG_SP_VAR__ = 0x00E00000,//<変数>
		__ARG_SP_SAVEDATA__ = 0x00F00000,//<数値>,<文字列式>
		__ARG_SP_TINPUTS__ = 0x01000000,//<数値>,<文字列式>,<数値>
		__ARG_SP_SORTCHARA__ = 0x01100000,//<キャラクタ変数>,<ソート順序>(両方省略可能)
		__ARG_SP_CALL__ = 0x01200000,//<文字列>,<引数>,... //引数は省略可能
		__ARG_SP_CALLFORM__ = 0x01300000,//<書式付文字列>,<引数>,... //引数は省略可能
		__ARG_SP_FOR_NEXT__ = 0x01400000,//<可変数値変数>,<数値>,<数値>,<数値> //引数は省略可能
		__ARG_SP_POWER__ = 0x01500000,//<可変数値変数>,<数値>,<数値>
		__ARG_SP_SWAPVAR__ = 0x01600000,//<可変変数>,<可変変数>(同型のみ)
		//__ARG_SP_STRFIND__ = 0x01700000,//<文字列式>,<文字列式>
		//__ARG_SP_FINDCHARA__ = 0x01800000,//<キャラクタ変数>,<式>(,<数式>)
		__ARG_EXPRESSION__ = 0x01900000,//<式>、変数の型は不問
		__ARG_CASE__ = 0x01A00000,//<CASE条件式>(, <CASE条件式>...)
        __ARG_VAR_INT__ = 0x01B00000,//<可変文字変数> //引数は省略可
		__ARG_BIT_ARG__ = 0x01c00000,//<可変数値変数>,<数値>(__ARG_SP_SET__が使えないため新設)
		__ARG_SP_VAR_SET__ = 0x01D00000,//<可変変数>,<数式 or 文字列式 or null>(,<範囲初値>, <範囲終値>)
		__ARG_SP_BUTTON__ = 0x01E00000,//<文字列式>,<数式>
		__ARG_SP_SET_ARRAY__ = 0x01F00000,//可変数値変数・<数式配列型>。未使用
		__ARG_SP_SETS_ARRAY__ = 0x02000000,//可変文字列変数・<文字列配列型>。未使用
		__ARG_SP_COLOR__ = 0x02100000,
        __ARG_SP_SPLIT__ = 0x02200000,//<文字列式>, <文字列式>, <可変文字変数>
        __ARG_SP_GETINT__ = 0x02300000,//<可変数値変数>(今までこれがないことに驚いた)
        __ARG_SP_CVAR_SET__ = 0x02400000,//<可変変数>,<式>,<数式 or 文字列式 or null>(,<範囲初値>, <範囲終値>)
        __ARG_SP_CONTROL_ARRAY__ = 0x2500000,//<可変変数>,<数値>,<数値>
        __ARG_SP_SHIFT_ARRAY__ = 0x2600000,//<可変変数>,<数値>,<数値or文字列>(,<数値>,<数値>>)
		__ARG_INT_ANY__ = 0x2700000,//1つ以上の数値を任意数
		__ARG_METHOD__ = 0x2800000,//FucntionMethodに置換するべき命令。同名のFunctionMethodが定義されていること。ARGは定義不要。__FLOW_CONTROL__とは排他
		__ARG_FORM_STR_ANY__ = 0x2900000,//1つ以上のFORM文字列を任意数  
        __ARG_MASK__ = unchecked(0x0FF00000),

        __PRINT_NEWLINE__ = 0x10000000,//PRINT命令で出力後改行するもの
        __PRINT_WAITINPUT__ = 0x20000000,//PRINT命令で出力後入力待ちするもの
        __PRINT_SINGLE__ = 0x40000000,//PRINTSINGLE系

		SET = 0x0001 |__METHOD_SAFE__| __ARG_SP_SET__,//数値代入文
		SETS = 0x0002 | __METHOD_SAFE__ | __ARG_SP_SETS__,//文字列代入文
		PRINT = 0x0100 | __METHOD_SAFE__ | __ARG_STR__,//文字を表示する
		PRINTL = 0x0101 | __METHOD_SAFE__ | __ARG_STR__ | __PRINT_NEWLINE__,//改行
		PRINTW = 0x0102 | __ARG_STR__ | __PRINT_WAITINPUT__,//入力待ち(実質改行)

		PRINTV = 0x0103 | __METHOD_SAFE__ | __ARG_SP_PRINTV__,//変数の内容
        PRINTVL = 0x0104 | __METHOD_SAFE__ | __ARG_SP_PRINTV__ | __PRINT_NEWLINE__,
        PRINTVW = 0x0105 | __ARG_SP_PRINTV__ | __PRINT_WAITINPUT__,

		PRINTS = 0x0106 | __METHOD_SAFE__ | __ARG_STR_EXPRESSION__,//文字列変数の内容
        PRINTSL = 0x0107 | __METHOD_SAFE__ | __ARG_STR_EXPRESSION__ | __PRINT_NEWLINE__,
        PRINTSW = 0x0108 | __ARG_STR_EXPRESSION__ | __PRINT_WAITINPUT__,

		PRINTFORM = 0x0109 | __METHOD_SAFE__ | __ARG_FORM_STR__,//{数式}、%文字列変数%などの書式が使える。
        PRINTFORML = 0x010A | __METHOD_SAFE__ | __ARG_FORM_STR__ | __PRINT_NEWLINE__,
        PRINTFORMW = 0x010B | __ARG_FORM_STR__ | __PRINT_WAITINPUT__,

		PRINTFORMS = 0x010C | __METHOD_SAFE__ | __ARG_STR_EXPRESSION__,//文字列変数の内容を変換して表示。
        PRINTFORMSL = 0x010D | __METHOD_SAFE__ | __ARG_STR_EXPRESSION__ | __PRINT_NEWLINE__,
        PRINTFORMSW = 0x010E | __ARG_STR_EXPRESSION__ | __PRINT_WAITINPUT__,

		PRINTC = 0x010F | __METHOD_SAFE__ | __ARG_STR__,//??

		CLEARLINE = 0x0110 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,
		REUSELASTLINE = 0x111 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,

		WAIT = 0x0200 | __ARG_VOID__,//改行待ち。
		INPUT = 0x0201 | __ARG_VOID__,//整数入力。入力はRESULTへ。
		INPUTS = 0x0202 | __ARG_VOID__,//文字列入力。入力はRESULTSへ。
		TINPUT = 0x0203 | __ARG_SP_BAR__,
		TINPUTS = 0x0204 | __ARG_SP_TINPUTS__,
		TWAIT = 0x0205 | __EXTENDED__ | __ARG_SP_SWAP__,
        ONEINPUT = 0x0206 | __EXTENDED__ | __ARG_VOID__,
        ONEINPUTS = 0x0207 | __EXTENDED__ | __ARG_VOID__,

		DRAWLINE = 0x0401 | __METHOD_SAFE__ | __ARG_VOID__,//画面の左端から右端まで----と線を引く。
		BAR = 0x0402 | __METHOD_SAFE__ | __ARG_SP_BAR__,//[*****....]のようなグラフを書く。BAR (変数) , (最大値), (長さ)
		BARL = 0x0403 | __METHOD_SAFE__ | __ARG_SP_BAR__,//改行付き。
		TIMES = 0x0404 | __METHOD_SAFE__ | __ARG_SP_TIMES__,//小数計算。TIMES (変数) , (小数値)という形で使う。

		PRINT_ABL = 0x0801 | __METHOD_SAFE__ | __ARG_INT_EXPRESSION__,//能力。引数は登録番号
		PRINT_TALENT = 0x0802 | __METHOD_SAFE__ | __ARG_INT_EXPRESSION__,//素質
		PRINT_MARK = 0x0803 | __METHOD_SAFE__ | __ARG_INT_EXPRESSION__,//刻印
		PRINT_EXP = 0x0804 | __METHOD_SAFE__ | __ARG_INT_EXPRESSION__,//経験
		PRINT_PALAM = 0x0805 | __METHOD_SAFE__ | __ARG_INT_EXPRESSION__,//パラメータ
		PRINT_ITEM = 0x0806 | __METHOD_SAFE__ | __ARG_VOID__,//所持アイテム
		PRINT_SHOPITEM = 0x0807 | __METHOD_SAFE__ | __ARG_VOID__,//ショップで売っているアイテム

		UPCHECK = 0x1001 | __METHOD_SAFE__ | __ARG_VOID__,//パラメータの変動
        CUPCHECK = 0x1002 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,
        ADDCHARA = 0x1003 | __METHOD_SAFE__ | __ARG_INT_ANY__,//(キャラ番号)のキャラクタを追加
        ADDSPCHARA = 0x1004 | __METHOD_SAFE__ | __ARG_INT_ANY__,//(キャラ番号)のSPキャラクタを追加（フラグ0を1にして作成）
        ADDDEFCHARA = 0x1005 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
        ADDVOIDCHARA = 0x1006 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,//変数に何の設定のないキャラを作成
        DELCHARA = 0x1007 | __METHOD_SAFE__ | __ARG_INT_ANY__,//(キャラ登録番号)のキャラクタを削除。
		GETCHARA = 0x1008 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//(キャラ番号)のキャラクタが現在の所有キャラの中にいるかを判定
		GETSPCHARA = 0x1009 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//(キャラ番号)のSPキャラクタが現在の所有キャラの中にいるかを判定

		CSVNAME = 0x1012 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//(キャラ番号)のキャラクタのNAMEを取り出す
		CSVCALLNAME = 0x1013 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//(キャラ番号)のキャラクタのCALLNAMEを取り出す
        CSVNICKNAME = 0x1014 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//(キャラ番号)のキャラクタのNICKNAMEを取り出す
        CSVMASTERNAME = 0x1015 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//(キャラ番号)のキャラクタのMASTERNAMEを取り出す
        CSVCSTR = 0x1016 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//関数化不可

        CSVBASE = 0x1020 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CSVABL = 0x1021 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CSVTALENT = 0x1022 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CSVMARK = 0x1023 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CSVEXP = 0x1024 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CSVRELATION = 0x1025 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CSVCFLAG = 0x1026 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

		PUTFORM = 0x1030 | __METHOD_SAFE__ | __ARG_FORM_STR__,//@SAVEINFO関数でのみ使用可能。PRINTFORMと同様の書式でセーブデータに概要をつける。
		QUIT = 0x1031 | __ARG_VOID__,//ゲームを終了
        OUTPUTLOG = 0x1032 | __ARG_VOID__,

		BEGIN = 0x03 | __FLOW_CONTROL__ | __ARG_STR__,//システム関数の実行。実行するとCALLの呼び出し元などを忘れてしまう。

		SAVEGAME = 0x04 | __FLOW_CONTROL__ | __ARG_VOID__,//セーブ画面を呼ぶ。ショップのみ。
		LOADGAME = 0x05 | __FLOW_CONTROL__ | __ARG_VOID__,//

		SIF = 0x10 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,//一行のみIF
		IF = 0x11 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,
		ELSE = 0x12 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_VOID__,
		ELSEIF = 0x13 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,
		ENDIF = 0x14 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_VOID__,

		REPEAT = 0x21 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,//RENDまで繰り返し。繰り返した回数がCOUNTへ。ネスト不可。
		REND = 0x22 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_VOID__,
		CONTINUE = 0x23 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_VOID__,//REPEATに戻る
		BREAK = 0x24 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_VOID__,//RENDの次の行まで

		GOTO = 0x31 | __METHOD_SAFE__ | __FLOW_CONTROL__ | __ARG_STR__,//$ラベルへジャンプ

		JUMP = 0x32 | __FLOW_CONTROL__ | __ARG_SP_CALL__,//関数に移動
		CALL = 0x33 | __FLOW_CONTROL__ | __ARG_SP_CALL__,//関数に移動。移動元を記憶し、RETURNで帰る。
		RETURN = 0x34 | __FLOW_CONTROL__ | __ARG_INT_ANY__,//__ARG_INT_EXPRESSION__,//関数の終了。RESULTに整数を格納可能。省略した場合、０。(次の@～～がRETURNと見なされる。)  
		RETURNFORM = 0x35 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_FORM_STR_ANY__,//__ARG_FORM_STR__,//関数の終了。RESULTに整数を格納可能。省略した場合、０。(次の@～～がRETURNと見なされる。)  
		RETURNF = 0x36 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_EXPRESSION__,
        RESTART = 0x37 | __FLOW_CONTROL__ | __ARG_VOID__,//関数の再開。関数の最初に戻る。


		STRLEN = 0x2040 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
		STRLENS = 0x2041 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,//
		STRLENFORM = 0x2042 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,
        STRLENU = 0x2043 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
        STRLENSU = 0x2044 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        STRLENFORMU = 0x2045 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,

        PRINTLC = 0x2046 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
		PRINTFORMC = 0x2047 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,
		PRINTFORMLC = 0x2048 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,

        SUBSTRING = 0x2049 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        SUBSTRINGU = 0x204A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

		SWAPCHARA = 0x204B | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_SWAP__,
		VARSIZE = 0x204C | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_VAR__,//動作が違うので__ARG_METHOD__化できない
        SPLIT = 0x204D | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_SPLIT__,

        PRINTSINGLE = 0x2050 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__ | __PRINT_SINGLE__,
        PRINTSINGLEV = 0x2051 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_PRINTV__ | __PRINT_SINGLE__,
        PRINTSINGLES = 0x2052 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_SINGLE__,
        PRINTSINGLEFORM = 0x2053 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__ | __PRINT_SINGLE__,
        PRINTSINGLEFORMS = 0x2054 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_SINGLE__,

		SAVEDATA = 0x2080 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_SAVEDATA__,
		LOADDATA = 0x2081 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,
		DELDATA = 0x2082 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,
		CHKDATA = 0x2083 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		GETTIME = 0x2084 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,//2つに代入する必要があるので__ARG_METHOD__化できない
		GETMILLISECOND = 0x2085 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        GETSECOND = 0x2086 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

		TRYJUMP = 0x2100 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALL__,
		TRYCALL = 0x2101 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALL__,
		TRYGOTO = 0x2102 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_STR__,
		JUMPFORM = 0x2110 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALLFORM__,
		CALLFORM = 0x2111 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALLFORM__,
		GOTOFORM = 0x2112 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_FORM_STR__,
		TRYJUMPFORM = 0x2120 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALLFORM__,
		TRYCALLFORM = 0x2121 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALLFORM__,
		TRYGOTOFORM = 0x2122 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_FORM_STR__,
		CALLTRAIN = 0x2123 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,
		CATCH = 0x2124 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
		ENDCATCH = 0x2125 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
		TRYCJUMP = 0x2126 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALL__,
        TRYCCALL = 0x2127 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALL__,
        TRYCGOTO = 0x2128 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_STR__,
		TRYCJUMPFORM = 0x2129 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALLFORM__,
        TRYCCALLFORM = 0x2130 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALLFORM__,
        TRYCGOTOFORM = 0x2131 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_FORM_STR__,
        TRYCALLLIST = 0x2132 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
        TRYJUMPLIST = 0x2133 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
        TRYGOTOLIST = 0x2134 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
        FUNC = 0x2135 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_CALLFORM__,
        ENDFUNC = 0x2136 | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
        CALLF = 0x2137 | __EXTENDED__ | __METHOD_SAFE__ | __ARG_SP_CALL__,
        CALLFORMF = 0x2138 | __EXTENDED__ | __METHOD_SAFE__ | __ARG_SP_CALLFORM__,

		SETCOLOR = 0x2200 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_COLOR__,
		RESETCOLOR = 0x2201 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		FONTBOLD = 0x2202 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		FONTITALIC = 0x2203 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		FONTREGULAR = 0x2204 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		SORTCHARA = 0x2205 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_SORTCHARA__,
		FONTSTYLE = 0x2206 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,
		ALIGNMENT = 0x2207 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
		CUSTOMDRAWLINE = 0x2208 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,

		CHKFONT = 0x2209 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		SETFONT = 0x220A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__,
        GETSTYLE = 0x220B | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

		FOR = 0x2300 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_SP_FOR_NEXT__,
		NEXT = 0x2301 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
		WHILE = 0x2302 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,
		WEND = 0x2303 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,

		POWER = 0x2400 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_POWER__,//引数が違うので__ARG_METHOD__化できない。
		SAVEGLOBAL = 0x2401 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		LOADGLOBAL = 0x2402 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		SWAP = 0x2403 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_SWAPVAR__,

		RESETDATA = 0x2403 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		RESETGLOBAL = 0x2404 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,

		RANDOMIZE = 0x2500 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,
		DUMPRAND = 0x2501 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
		INITRAND = 0x2502 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,

		STRFIND = 0x2600 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		FINDCHARA = 0x2601 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        STRCOUNT = 0x2602 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        REPLACE = 0x2603 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        STRFINDU = 0x2604 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

		REDRAW = 0x2610 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,

		ABS = 0x2611 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		SIGN = 0x2612 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		MAX = 0x2613 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		MIN = 0x2614 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		SQRT = 0x2615 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        LOG = 0x2616 | __METHOD_SAFE__ | __EXTENDED__ |__ARG_METHOD__,
        LOG10 = 0x2617 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        EXPONENT = 0x2618 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CBRT = 0x2619 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		GETBIT = 0x261C | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		GETNUM = 0x261D | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		DOTRAIN = 0x261E | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,

        SELECTCASE = 0x2620 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_EXPRESSION__,
        CASE = 0x2621 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_CASE__,
        CASEELSE = 0x2622 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
        ENDSELECT = 0x2623 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,

        DO = 0x2625 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_VOID__,
        LOOP = 0x2626 | __METHOD_SAFE__ | __EXTENDED__ | __FLOW_CONTROL__ | __ARG_INT_EXPRESSION__,

        PRINTDATA = 0x2630 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VAR_INT__,
        PRINTDATAL = 0x2631 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VAR_INT__ | __PRINT_NEWLINE__,
        PRINTDATAW = 0x2632 | __EXTENDED__ | __ARG_VAR_INT__ | __PRINT_WAITINPUT__,
        DATA = 0x2633 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
        DATAFORM = 0x2634 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,
        ENDDATA = 0x2635 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
        DATALIST = 0x2636 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
        ENDLIST = 0x2637 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,

        PRINTCPERLINE = 0x2640 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_GETINT__,//よく考えたら引数の仕様違うや
        LIMIT = 0x2641 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

        EXISTCSV = 0x2642 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

        SETBIT = 0x2643 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_BIT_ARG__,
        CLEARBIT = 0x2644 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_BIT_ARG__,
        INVERTBIT = 0x2645 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_BIT_ARG__,
		DELALLCHARA = 0x2650 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
        PICKUPCHARA = 0x2651 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_ANY__,

		VARSET = 0x2700 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_VAR_SET__,
        CVARSET = 0x2701 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_CVAR_SET__,
		UNICODE = 0x2702 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		GETFONT = 0x2703 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		GETCOLOR = 0x2704 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
		TOSTR = 0x2705 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        TOINT = 0x2707 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        TOUPPER = 0x2708 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        TOLOWER = 0x2709 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        TOHALF = 0x270A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        TOFULL = 0x270B | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        LINEISEMPTY = 0x270C | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        PRINTBUTTON = 0x270D | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_BUTTON__,
        PRINTBUTTONC = 0x270E | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_BUTTON__,
        PRINTBUTTONLC = 0x270F | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_BUTTON__,

        RESET_STAIN = 0x2706 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,

        SAVENOS = 0x2710 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_GETINT__,//引数の仕様が違うので(ry
        GETPALAMLV = 0x2715 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        GETEXPLV = 0x2716 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

        FORCEKANA = 0x2720 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,
        MATCH = 0x2724 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        SUMARRAY = 0x2725 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        MAXARRAY = 0x2726 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        MINARRAY = 0x2727 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        SUMCARRAY = 0x2728 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        MAXCARRAY = 0x2729 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        MINCARRAY = 0x272A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        CMATCH = 0x272B | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        GROUPMATCH = 0x272C | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        NOSAMES = 0x272D | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        ALLSAMES = 0x272E | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,

        SKIPDISP = 0x2740 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_INT_EXPRESSION__,
        ISSKIP = 0x2741 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_METHOD__,
        NOSKIP = 0x2742 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,
        ENDNOSKIP = 0x2743 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VOID__,

        ARRAYSHIFT = 0x2750 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_SHIFT_ARRAY__,
        ARRAYREMOVE = 0x2751 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_CONTROL_ARRAY__,

        ENCODETOUNI = 0x2752 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,


		DEBUGPRINT = 0x2800 | __METHOD_SAFE__ | __EXTENDED__ | __DEBUG__ | __ARG_STR__,
		DEBUGPRINTL = 0x2800 | __METHOD_SAFE__ | __EXTENDED__ | __DEBUG__ | __ARG_STR__ | __PRINT_NEWLINE__,
		DEBUGPRINTFORM = 0x2800 | __METHOD_SAFE__ | __EXTENDED__ | __DEBUG__ | __ARG_FORM_STR__,
		DEBUGPRINTFORML = 0x2800 | __METHOD_SAFE__ | __EXTENDED__ | __DEBUG__ | __ARG_FORM_STR__ | __PRINT_NEWLINE__,
		ASSERT = 0x2801 | __METHOD_SAFE__ | __EXTENDED__ | __DEBUG__ | __ARG_INT_EXPRESSION__ ,

        __ISPRINTKFUNC__ = 0xFE00,//PRINTK系判定用
        PRINTK = 0xFE00 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
        PRINTKL = 0xFE01 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__ | __PRINT_NEWLINE__,
        PRINTKW = 0xFE02 | __EXTENDED__ | __ARG_STR__ | __PRINT_WAITINPUT__,

        PRINTVK = 0xFE04 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_PRINTV__,//変数の内容
        PRINTVKL = 0xFE05 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_PRINTV__ | __PRINT_NEWLINE__,
        PRINTVKW = 0xFE06 | __EXTENDED__ | __ARG_SP_PRINTV__ | __PRINT_WAITINPUT__,

        PRINTSK = 0xFE07 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__,//文字列変数の内容
        PRINTSKL = 0xFE08 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_NEWLINE__,
        PRINTSKW = 0xFE09 | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_WAITINPUT__,

        PRINTFORMK = 0xFE0A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,//{数式}、%文字列変数%などの書式が使える。
        PRINTFORMKL = 0xFE0B | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__ | __PRINT_NEWLINE__,
        PRINTFORMKW = 0xFE0C | __EXTENDED__ | __ARG_FORM_STR__ | __PRINT_WAITINPUT__,

        PRINTFORMSK = 0xFE0D | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__,//文字列変数の内容を変換して表示。
        PRINTFORMSKL = 0xFE0E | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_NEWLINE__,
        PRINTFORMSKW = 0xFE0F | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_WAITINPUT__,

        PRINTCK = 0xFE10 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,//??
        PRINTLCK = 0xFE11 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
        PRINTFORMCK = 0xFE12 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,
        PRINTFORMLCK = 0xFE13 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,

        PRINTSINGLEK = 0xFE14 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__ | __PRINT_SINGLE__,
        PRINTSINGLEVK = 0xFE15 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_PRINTV__ | __PRINT_SINGLE__,
        PRINTSINGLESK = 0xFE16 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_SINGLE__,
        PRINTSINGLEFORMK = 0xFE17 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__ | __PRINT_SINGLE__,
        PRINTSINGLEFORMSK = 0xFE18 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_SINGLE__,

        PRINTDATAK = 0xFE19 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VAR_INT__,
        PRINTDATAKL = 0xFE1A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VAR_INT__ | __PRINT_NEWLINE__,
        PRINTDATAKW = 0xFE1B | __EXTENDED__ | __ARG_VAR_INT__ | __PRINT_WAITINPUT__,

        __ISPRINTDFUNC__ = 0xFF00,//PRINTD系判定用
        PRINTD = 0xFF01 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,//文字を表示する
        PRINTDL = 0xFF02 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__ | __PRINT_NEWLINE__,//改行
        PRINTDW = 0xFF03 | __EXTENDED__ | __ARG_STR__ | __PRINT_WAITINPUT__,//入力待ち(実質改行)

        PRINTVD = 0xFF04 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_PRINTV__,//変数の内容
        PRINTVDL = 0xFF05 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_PRINTV__ | __PRINT_NEWLINE__,
        PRINTVDW = 0xFF06 | __EXTENDED__ | __ARG_SP_PRINTV__ | __PRINT_WAITINPUT__,

        PRINTSD = 0xFF07 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__,//文字列変数の内容
        PRINTSDL = 0xFF08 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_NEWLINE__,
        PRINTSDW = 0xFF09 | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_WAITINPUT__,

        PRINTFORMD = 0xFF0A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,//{数式}、%文字列変数%などの書式が使える。
        PRINTFORMDL = 0xFF0B | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__ | __PRINT_NEWLINE__,
        PRINTFORMDW = 0xFF0C | __EXTENDED__ | __ARG_FORM_STR__ | __PRINT_WAITINPUT__,

        PRINTFORMSD = 0xFF0D | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__,//文字列変数の内容を変換して表示。
        PRINTFORMSDL = 0xFF0E | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_NEWLINE__,
        PRINTFORMSDW = 0xFF0F | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_WAITINPUT__,

        PRINTCD = 0xFF10 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,//??
        PRINTLCD = 0xFF11 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__,
        PRINTFORMCD = 0xFF12 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,
        PRINTFORMLCD = 0xFF13 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__,

        PRINTSINGLED = 0xFF14 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR__ | __PRINT_SINGLE__,
        PRINTSINGLEVD = 0xFF15 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_SP_PRINTV__ | __PRINT_SINGLE__,
        PRINTSINGLESD = 0xFF16 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_SINGLE__,
        PRINTSINGLEFORMD = 0xFF17 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_FORM_STR__ | __PRINT_SINGLE__,
        PRINTSINGLEFORMSD = 0xFF18 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_STR_EXPRESSION__ | __PRINT_SINGLE__,

        PRINTDATAD = 0xFF19 | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VAR_INT__,
        PRINTDATADL = 0xFF1A | __METHOD_SAFE__ | __EXTENDED__ | __ARG_VAR_INT__ | __PRINT_NEWLINE__,
        PRINTDATADW = 0xFF1B | __EXTENDED__ | __ARG_VAR_INT__ | __PRINT_WAITINPUT__,

    }

	internal static class BuiltInFunctionManager
	{
		readonly static Dictionary<string, BuiltInFunctionCode> nameDic = new Dictionary<string, BuiltInFunctionCode>();
        readonly static Dictionary<BuiltInFunctionCode, string> funcMatch = new Dictionary<BuiltInFunctionCode, string>();
        static BuiltInFunctionManager()
		{
			//Enum.IsDefined(typeof(BuiltInFunctionCode), key)とすると重い。
			//チェック無しでParseして例外処理にまかせるとさらに重い。
			//なのであらかじめ変換辞書を作っておく。
			Array array = Enum.GetValues(typeof(BuiltInFunctionCode));
			foreach (object name in array)
			{
				BuiltInFunctionCode func = (BuiltInFunctionCode)name;
				string key = func.ToString();
				if ((key == null) || (key.StartsWith("__") && key.EndsWith("__")))
					continue;
				if ((key == "SET") || (key == "SETS"))
					continue;
				if (Config.Instance.IgnoreCase)
					key = key.ToUpper();
				nameDic.Add(key, func);
			}

            funcMatch[BuiltInFunctionCode.IF] = "ENDIF";
            funcMatch[BuiltInFunctionCode.SELECTCASE] = "ENDSELECT";
            funcMatch[BuiltInFunctionCode.REPEAT] = "REND";
            funcMatch[BuiltInFunctionCode.FOR] = "NEXT";
            funcMatch[BuiltInFunctionCode.WHILE] = "WEND";
            funcMatch[BuiltInFunctionCode.TRYCGOTO] = "CATCH";
            funcMatch[BuiltInFunctionCode.TRYCJUMP] = "CATCH";
            funcMatch[BuiltInFunctionCode.TRYCCALL] = "CATCH";
            funcMatch[BuiltInFunctionCode.TRYCGOTOFORM] = "CATCH";
            funcMatch[BuiltInFunctionCode.TRYCJUMPFORM] = "CATCH";
            funcMatch[BuiltInFunctionCode.TRYCCALLFORM] = "CATCH";
            funcMatch[BuiltInFunctionCode.DO] = "LOOP";
            funcMatch[BuiltInFunctionCode.PRINTDATA] = "ENDDATA";
            funcMatch[BuiltInFunctionCode.PRINTDATAL] = "ENDDATA";
            funcMatch[BuiltInFunctionCode.PRINTDATAW] = "ENDDATA";
            funcMatch[BuiltInFunctionCode.NOSKIP] = "ENDNOSKIP";
        }

		public static BuiltInFunctionCode ToBuiltInFunction(string str)
		{
			string key = str;
			if (string.IsNullOrEmpty(key))
				return BuiltInFunctionCode.__NULL__;
			if (Config.Instance.IgnoreCase)
				key = key.ToUpper();
			if (!nameDic.ContainsKey(key))
				return BuiltInFunctionCode.__NULL__;
			return nameDic[key];
		}


		internal static bool IsFlowContorol(BuiltInFunctionCode builtInFunctionName)
		{
			return ((builtInFunctionName & BuiltInFunctionCode.__FLOW_CONTROL__) == BuiltInFunctionCode.__FLOW_CONTROL__);
		}

        internal static bool IsPrintDFunction(BuiltInFunctionCode builtInFunctionName)
        {
            return ((builtInFunctionName & BuiltInFunctionCode.__ISPRINTDFUNC__) == BuiltInFunctionCode.__ISPRINTDFUNC__);
        }

        internal static bool IsPrintKFunction(BuiltInFunctionCode builtInFunctionName)
        {
            return ((builtInFunctionName & BuiltInFunctionCode.__ISPRINTDFUNC__) == BuiltInFunctionCode.__ISPRINTKFUNC__);
        }

        internal static bool IsNewLine(BuiltInFunctionCode builtInFunctionName)
        {
            return ((builtInFunctionName & BuiltInFunctionCode.__PRINT_NEWLINE__) == BuiltInFunctionCode.__PRINT_NEWLINE__);
        }

        internal static bool IsWaitInput(BuiltInFunctionCode builtInFunctionName)
        {
            return ((builtInFunctionName & BuiltInFunctionCode.__PRINT_WAITINPUT__) == BuiltInFunctionCode.__PRINT_WAITINPUT__);
        }
        internal static bool IsPrintSingle(BuiltInFunctionCode builtInFunctionName)
        {
            return ((builtInFunctionName & BuiltInFunctionCode.__PRINT_SINGLE__) == BuiltInFunctionCode.__PRINT_SINGLE__);
        }

		internal static bool IsMethodSafe(BuiltInFunctionCode builtInFunctionName)
		{
			return ((builtInFunctionName & BuiltInFunctionCode.__METHOD_SAFE__) == BuiltInFunctionCode.__METHOD_SAFE__);
		}

        public static string getMatchFunction(BuiltInFunctionCode func)
        {
            if (funcMatch.ContainsKey(func))
                return funcMatch[func];
            return null;
        }

        public static BuiltInFunctionCode getParentFunc(BuiltInFunctionCode func)
        {
            if (funcMatch.ContainsValue(func.ToString()))
            {
                foreach (BuiltInFunctionCode pFunc in funcMatch.Keys)
                {
                    if (funcMatch[pFunc] == func.ToString())
                        return pFunc;
                }
            }
            return BuiltInFunctionCode.__NULL__;
        }
    }
}
