/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.processor;

import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.tag.ReportsTagParser;

public class ReportsParserInfo {
    private ReportBook reportBook = null;
    private ParamInfo paramInfo = null;
    private List<ReportsTagParser<?>> reportParsers = null;

    public ParamInfo getParamInfo() {
        return this.paramInfo;
    }

    public void setParamInfo(ParamInfo paramInfo) {
        this.paramInfo = paramInfo;
    }

    public List<ReportsTagParser<?>> getReportParsers() {
        return this.reportParsers;
    }

    public void setReportParsers(List<ReportsTagParser<?>> reportParsers) {
        this.reportParsers = reportParsers;
    }

    public ReportsParserInfo createChildParserInfo(ParamInfo paramInfo) {
        ReportsParserInfo reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.reportParsers = this.reportParsers;
        reportsParserInfo.reportBook = this.reportBook;
        reportsParserInfo.paramInfo = paramInfo;
        return reportsParserInfo;
    }

    public TagParser<?> getMatchTagParser(Sheet sheet, Cell tagCell) throws ParseException {
        if (this.reportParsers != null) {
            for (ReportsTagParser<?> tagParser : this.reportParsers) {
                if (!tagParser.isParse(sheet, tagCell)) continue;
                return tagParser;
            }
        }
        return null;
    }

    public ReportBook getReportBook() {
        return this.reportBook;
    }

    public void setReportBook(ReportBook reportBook) {
        this.reportBook = reportBook;
    }
}

