/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.CellClone;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.util.ReportsUtil;

public class RowRepeatParamParser
extends ReportsTagParser<Object[]> {
    private static Log log = LogFactory.getLog(RowRepeatParamParser.class);
    public static final String DEFAULT_TAG = "$R[]";
    public static final String PARAM_VALUE = "";
    protected static final String PARAM_DUPLICATE = "hideDuplicate";
    public static final String PARAM_ROW_SHIFT = "rowShift";
    public static final String PARAM_BREAK_NUM = "breakNum";
    public static final String PARAM_CHANGE_BREAK = "changeBreak";
    public static final String PARAM_REPEAT_NUM = "repeatNum";
    public static final String PARAM_SHEET_LINK = "sheetLink";
    public static final String PARAM_PROPERTY = "property";

    public RowRepeatParamParser() {
        super(DEFAULT_TAG);
    }

    public RowRepeatParamParser(String tag) {
        super(tag);
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
        this.checkParam(paramDef, tagCell);
        String tag = tagCell.getStringCellValue();
        ReportsParserInfo reportsParserInfo = (ReportsParserInfo)data;
        Object[] paramValues = null;
        try {
            String replaceParam;
            boolean rowShift = false;
            if (paramDef.containsKey(PARAM_ROW_SHIFT)) {
                rowShift = Boolean.valueOf((String)paramDef.get(PARAM_ROW_SHIFT));
            }
            boolean hideDuplicate = false;
            if (paramDef.containsKey(PARAM_DUPLICATE)) {
                hideDuplicate = Boolean.valueOf((String)paramDef.get(PARAM_DUPLICATE));
            }
            Integer breakNum = null;
            if (paramDef.containsKey(PARAM_BREAK_NUM)) {
                breakNum = Integer.valueOf((String)paramDef.get(PARAM_BREAK_NUM));
            }
            boolean changeBreak = false;
            if (paramDef.containsKey(PARAM_CHANGE_BREAK)) {
                changeBreak = Boolean.valueOf((String)paramDef.get(PARAM_CHANGE_BREAK));
            }
            Integer repeatNum = null;
            if (paramDef.containsKey(PARAM_REPEAT_NUM)) {
                repeatNum = Integer.valueOf((String)paramDef.get(PARAM_REPEAT_NUM));
            }
            boolean sheetLink = false;
            if (paramDef.containsKey(PARAM_SHEET_LINK)) {
                sheetLink = Boolean.valueOf((String)paramDef.get(PARAM_SHEET_LINK));
            }
            String propertyName = null;
            if (paramDef.containsKey(PARAM_PROPERTY)) {
                propertyName = (String)paramDef.get(PARAM_PROPERTY);
            }
            if ("#SHEET_NAME[]".equals(replaceParam = (String)paramDef.get(PARAM_VALUE))) {
                paramValues = ReportsUtil.getSheetNames(reportsParserInfo.getReportBook()).toArray();
            } else if ("#SHEET_VALUE[]".equals(replaceParam)) {
                paramValues = ReportsUtil.getSheetValues(reportsParserInfo.getReportBook(), propertyName, reportsParserInfo.getReportParsers()).toArray();
            } else {
                ParamInfo paramInfo = reportsParserInfo.getParamInfo();
                if (paramInfo != null) {
                    paramValues = (Object[])this.getParamData(paramInfo, replaceParam);
                }
            }
            if (paramValues == null || paramValues.length == 0) {
                paramValues = new Object[]{null};
            }
            int shiftNum = paramValues.length;
            int paramLength = paramValues.length;
            int defaultFromCellRowIndex = tagCell.getRowIndex();
            int defaultFromCellColIndex = tagCell.getColumnIndex();
            int unitRowSize = 1;
            ArrayList<CellRangeAddress> maegedAddresses = new ArrayList<CellRangeAddress>();
            for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                CellRangeAddress targetAddress = sheet.getMergedRegion(i);
                maegedAddresses.add(targetAddress);
            }
            if (maegedAddresses.size() > 0) {
                for (CellRangeAddress curMergedAdress : maegedAddresses) {
                    if (defaultFromCellColIndex != curMergedAdress.getFirstColumn() || defaultFromCellRowIndex != curMergedAdress.getFirstRow()) continue;
                    unitRowSize = curMergedAdress.getLastRow() - curMergedAdress.getFirstRow() + 1;
                    shiftNum *= unitRowSize;
                }
            }
            tagCell = new CellClone(tagCell);
            ArrayList<CellClone> cellList = new ArrayList<CellClone>();
            int defaultToOverCellRowIndex = tagCell.getRowIndex() + unitRowSize;
            for (int i = defaultFromCellRowIndex; i < defaultToOverCellRowIndex; ++i) {
                Row targetCellRow = sheet.getRow(i);
                cellList.add(new CellClone(targetCellRow.getCell(tagCell.getColumnIndex())));
            }
            if (repeatNum != null && repeatNum < shiftNum) {
                shiftNum = repeatNum * unitRowSize;
                paramLength = repeatNum;
            }
            if (shiftNum > 1) {
                int shiftRowSize = tagCell.getRowIndex() + shiftNum - unitRowSize - 1;
                if (!rowShift) {
                    CellRangeAddress rangeAddress = new CellRangeAddress(tagCell.getRowIndex(), shiftRowSize, tagCell.getColumnIndex(), tagCell.getColumnIndex());
                    PoiUtil.insertRangeDown((Sheet)sheet, (CellRangeAddress)rangeAddress);
                } else {
                    int shiftStartRow = tagCell.getRowIndex() + 1;
                    int shiftEndRow = sheet.getLastRowNum();
                    if (shiftEndRow < shiftStartRow) {
                        shiftEndRow = shiftStartRow + 1;
                    }
                    sheet.shiftRows(shiftStartRow, shiftEndRow, shiftNum - unitRowSize);
                }
            }
            Workbook workbook = sheet.getWorkbook();
            String sheetName = workbook.getSheetName(workbook.getSheetIndex(sheet));
            List<String> sheetNames = ReportsUtil.getSheetNames(reportsParserInfo.getReportBook());
            ArrayList<Object> resultValues = new ArrayList<Object>();
            Object beforeValue = null;
            int valueIndex = -1;
            for (int rowIndex = 0; rowIndex < shiftNum; ++rowIndex) {
                Cell cell;
                Row row = sheet.getRow(tagCell.getRowIndex() + rowIndex);
                if (row == null) {
                    row = sheet.createRow(tagCell.getRowIndex() + rowIndex);
                }
                if ((cell = row.getCell(tagCell.getColumnIndex())) == null) {
                    cell = row.createCell(tagCell.getColumnIndex());
                }
                Object value = null;
                int cellIndex = rowIndex % unitRowSize;
                boolean skipRow = false;
                if (cellIndex != 0) {
                    skipRow = true;
                } else {
                    ++valueIndex;
                }
                PoiUtil.copyCell((Cell)((Cell)cellList.get(cellIndex)), (Cell)cell);
                Object currentValue = paramValues[valueIndex];
                boolean duplicateValue = false;
                if (beforeValue != null && currentValue != null && beforeValue.equals(currentValue)) {
                    duplicateValue = true;
                }
                if (!(skipRow || hideDuplicate && duplicateValue)) {
                    value = currentValue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  " + tag + " \u21d2 " + value));
                }
                PoiUtil.setCellValue((Cell)cell, (Object)value);
                resultValues.add(value);
                if (sheetLink && !skipRow && valueIndex < sheetNames.size()) {
                    PoiUtil.setHyperlink((Cell)cell, (int)2, (String)("'" + sheetNames.get(valueIndex) + "'!A1"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  Hyperlink \u21d2 " + "'" + sheetNames.get(valueIndex) + "'!A1"));
                    }
                }
                if (cell instanceof HSSFCell && !skipRow) {
                    if (breakNum != null && valueIndex != 0 && valueIndex % breakNum == 0) {
                        sheet.setRowBreak(row.getRowNum() - 1);
                    }
                    if (changeBreak && valueIndex != 0 && !duplicateValue) {
                        sheet.setRowBreak(row.getRowNum() - 1);
                    }
                }
                if (!skipRow && unitRowSize > 1) {
                    boolean mergedRegionFlag = false;
                    if (rowShift && valueIndex != 0) {
                        mergedRegionFlag = true;
                    } else if (!rowShift && paramLength > valueIndex + 1) {
                        mergedRegionFlag = true;
                    }
                    if (mergedRegionFlag) {
                        CellRangeAddress rangeAddress = new CellRangeAddress(cell.getRowIndex(), cell.getRowIndex() + unitRowSize - 1, cell.getColumnIndex(), cell.getColumnIndex());
                        sheet.addMergedRegion(rangeAddress);
                        beforeValue = currentValue;
                    }
                }
                if (unitRowSize != 1) continue;
                beforeValue = currentValue;
            }
            ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
            parsedReportInfo.setParsedObject(resultValues);
            parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex() + unitRowSize - 1);
            parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex());
            parsedReportInfo.setRowIndex(tagCell.getRowIndex() + shiftNum - 1);
            parsedReportInfo.setColumnIndex(tagCell.getColumnIndex());
            if (log.isDebugEnabled()) {
                log.debug((Object)parsedReportInfo);
            }
            return parsedReportInfo;
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (paramDef.containsKey(PARAM_DUPLICATE) && paramDef.containsKey(PARAM_SHEET_LINK)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1ahideDuplicate,sheetLink");
        }
    }

    @Override
    public boolean useControlRow() {
        return false;
    }
}

