/*
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 *
 * () ȉ͓{̕₷l̂߂ɁAp̒쌠\
 * ͂łBȒ쌠́Ap̌{ɏ]B
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * ύX̗Lɂ炸A\[XуoCi`̍ĔzzїṕA
 * ȉ̏𖞂Ă΁AB
 *
 * 1. \[XER[h̍ĔzźAL̒쌠\ȀځAсA
 * ȉ̖ƐӎۑȂ΂ȂȂB
 *
 * 2. oCi`̍ĔzźAL̒쌠\ȀځAсA
 * ̖ƐӎA̔zzɕtA邢͂̑̎̂
 * ɖLȂ΂ȂȂB
 *
 * 3. Oēʂɋ𓾂ȂÃ\tgEFAhi
 * ̔î߂ɁA̒쌠Җ𗘗pĂ͂ȂȂB
 *
 * ̃\tgEFÁû܂܂̌`Łv񋟂AI邢͌O̕ۏ
 * ́AppѓړIւ̓Kɑ΂錾O̕ۏ؂܂݁A܂
 * Ɍ炸A݂ȂBƂȉ̂悤ȑQ̉\Ă
 * ƂĂAǂ̂悤Ȍ`ɂ낱̃\tgEFA̗p甭
 * āA̒쌠҂́A(֐iT[rX̒B; pAf[^A
 * 邢͗v̑; 邢͉cƂ̒f܂ށA܂炾Ɍ炸)
 * ړIɁAԐړIɁARɁAʂɁAA邢́AKRIɐĂ܂
 * Qɑ΂ӔC͂ȂAȂӔC_ł_̗LɌW炸
 * ȐӔC͂ȂA܂(ߎ邢͂̑܂)s@sׂɑ΂ĂӔC͂
 * B
 *
 */

/***************************************************************************
	NX}\[X𐶐DynamicDrawpvOC
	  ExportSrc.dll
	$Id: ExtractInfo_Delphi.cpp,v 1.6 2002/11/30 11:00:48 matsumo Exp $
***************************************************************************/
/*!
	@file		ExtractInfo_Delphi.cpp
	@brief		NX}ClassInfo֕Kvȏ̒osNX
				ɂˑ̂镔(Delphip)
	@author		matsumo
	@date		2002/5/28 VK쐬
	$Revision: 1.6 $
 */

#include "stdafx.h"
#include "ExtractInfo_Delphi.h"

/////////////////////////////////////////////////////////////////////////////////
//̃NẌɊւ

//gq
wchar_t* ExtractInfo_Delphi::FileExt = L".pas";
//ꖼ
wchar_t* ExtractInfo_Delphi::LangName = L"Delphi";

/////////////////////////////////////////////////////////////////////////////////
//Ŏgp郁\bh

/*****************************************************************************/
/*!
	@brief	visibility(+,#,-)ɑΉ(public,protected,private)Ԃ
	@param	str			visibility܂ޕ
	@return				
 */
/*****************************************************************************/
wstring ExtractInfo_Delphi::getVisibilityName(const wstring &str)
{
	switch(str[0]){
	case L'+':
		return L"public";
	case L'#':
		return L"protected";
	case L'-':
		return L"private";
	default:
		return L"";
	}
}

/*****************************************************************************/
/*!
	@brief	name, attribute, operation\[X𐶐sourceɊi[
	@param	ci			NX̃NXւ̎Q
	@retval	TRUE		
	@retval	FALSE		s
 */
/*****************************************************************************/
BOOL ExtractInfo_Delphi::makeSource(ClassInfo &ci)
{
#define COMMENT L"//"
#define INDENT  L"  "

	wstring t;
	int i;
	BOOL bInterface = FALSE;
	if(ci.name.stereo_type.find(L"interface") != wstring::npos){
		bInterface = TRUE;
	}

	//\[Xwb_
	for(i=0; i<ci.header.size(); i++){
		t  = COMMENT;
		t += ci.header[i];
		t += L"\n";
		ci.source.push_back(t);
	}

	//pbP[W
	//t = L"\n";
	//ci.package Ή閽߂Ȃ

	//unit
	t = L"\n";
	t += L"unit ";
	t += ci.name.name;
	t += L";\n";
	ci.source.push_back(t);

	//̑
	t = L"\ninterface\n\n";
	t += COMMENT L"uses `;\n\n";
	ci.source.push_back(t);

	//typeJn
	t = L"type\n";
	ci.source.push_back(t);

	//NX
	t = INDENT;
	t += L"T";	//*Ƃ肠
	t += ci.name.name;
	t += L" = class";
	if(ci.generalization.size()){	//p
		t += L"(";
		t += GetClassName(ci.generalization[0]);
		t += L")";
	}
	t += L"\n\n";
	ci.source.push_back(t);

	//
	if(!bInterface){	//C^[tF[X͑
		t  = INDENT COMMENT COMMENT_STR_PROPERTY L"\n";
		ci.source.push_back(t);
		for(i=0; i<ci.attribute.size(); i++){
			t  = INDENT;
			//rWreB
			if(!ci.attribute[i].visibility.empty()){
				t += getVisibilityName(ci.attribute[i].visibility);
				t += L" ";
			}
/*			//static
			if(ci.attribute[i].bStatic){
				t += L"static ";
			}*/
			//
			t += ci.attribute[i].name;
			t += L": ";
			//^
			if(!ci.attribute[i].type.empty()){
				t += ci.attribute[i].type;
			}
			t += L";\n";
			ci.source.push_back(t);
		}
		t = L"\n";
		ci.source.push_back(t);
	}

	//\bh
	t  = INDENT COMMENT COMMENT_STR_METHOD L"\n";
	ci.source.push_back(t);
	for(i=0; i<ci.operation.size(); i++){
		wstring w = getVisibilityName(ci.operation[i].visibility);

		t  = INDENT;
		//rWreB
		if(!w.empty()){
			t += w;
			t += L" ";
		}
/*		//static
		if(ci.operation[i].bStatic){
			t += L"static ";
		}*/
		if(isConstructor(ci.operation[i].name.c_str())){
			//RXgN^
			t += L"constructor ";
		}else if(isDestructor(ci.operation[i].name.c_str())){
			//fXgN^
			t += L"destructor ";
		}else{
			//function or procedure
			if(ci.operation[i].return_type.empty()){
					t += L"procedure ";
			}else{
				t += L"function ";
			}
		}
		//\bh
		t += ci.operation[i].name;
		//
		if(ci.operation[i].param.size()){
			t += L"(";
			for(int j=0; j<ci.operation[i].param.size(); j++){
				t += ci.operation[i].param[j].name;
				t += L": ";
				t += ci.operation[i].param[j].type;
	/*			//̃ftHg
				if(!ci.operation[i].param[j].default_value.empty()){
					t += L" =";
					t += ci.operation[i].param[j].default_value;
				}*/
				if(j<ci.operation[i].param.size()-1) t += L", ";
			}
			t += L")";
		}
		//Al
		if(!ci.operation[i].return_type.empty()){
			t += L": ";
			t += ci.operation[i].return_type;
		}
/*		//Al̃ftHg
		if(!ci.operation[i].default_value.empty()) t += L" =";
		t += ci.operation[i].default_value;*/

		//abstract
		if(ci.operation[i].bAbstract){
			t += L"; virtual; abstract";
		}

		//destructor܂̓I[o[Ch̎
		BOOL met = FALSE;
		if(ci.generalization.size()){
			if(checkExistMethod(ci.generalization[0], ci.operation[i].name)){
				//\bh݂Abstract
				met = TRUE;
			}
		}
		if(isDestructor(ci.operation[i].name.c_str())  || met){
			t += L"; override";
		}

		t += L";\n";
		ci.source.push_back(t);
	}

	//typeI
	t = INDENT L"end;\n\n";
	ci.source.push_back(t);

	//implementationJn
	t = L"implementation\n\n";
	ci.source.push_back(t);

	//\bh̎
	for(i=0; i<ci.operation.size(); i++){
		if(!(bInterface || ci.operation[i].bAbstract)){
			//C^[tF[XAAbstractĂꍇ͕KvȂ
			if(isConstructor(ci.operation[i].name.c_str())){
				//RXgN^
				t = L"constructor ";
			}else if(isDestructor(ci.operation[i].name.c_str())){
				//fXgN^
				t = L"destructor ";
			}else{
				//function or procedure
				if(ci.operation[i].return_type.empty()){
						t = L"procedure ";
				}else{
					t = L"function ";
				}
			}
			t += L"T";	//*Ƃ肠
			t += ci.name.name;
			t += L".";
			//\bh
			t += ci.operation[i].name;
			//
			if(ci.operation[i].param.size()){
				t += L"(";
				for(int j=0; j<ci.operation[i].param.size(); j++){
					t += ci.operation[i].param[j].name;
					t += L": ";
					t += ci.operation[i].param[j].type;
/*					//̃ftHg
					if(!ci.operation[i].param[j].default_value.empty()){
						t += L" =";
						t += ci.operation[i].param[j].default_value;
					}*/
					if(j<ci.operation[i].param.size()-1) t += L", ";
				}
				t += L")";
			}
			//Al
			if(!ci.operation[i].return_type.empty()){
				t += L": ";
				t += ci.operation[i].return_type;
			}
	/*		//Al̃ftHg
			if(!ci.operation[i].default_value.empty()) t += L" =";
			t += ci.operation[i].default_value;*/

			t += L";\n";
			t += COMMENT L"var\n";
			t += COMMENT INDENT L"`;\n";
			t += L"begin\n";
			if(ci.operation[i].return_type.empty()){
				t += INDENT COMMENT L"\n";
			}else{
				t += INDENT L"result := <value>;\n";
			}
			t += L"end;\n";
			if(i<ci.operation.size()-1) t += L"\n";
			ci.source.push_back(t);
		}
	}

	//tb^
	t = L"\nend.\n";
	ci.source.push_back(t);

	return(TRUE);
}

/*****************************************************************************/
/*!
	@brief	\bhRXgN^ǂʂ
	@param	str			ׂ\bhւ̎Q
	@retval	TRUE		RXgN^
	@retval	FALSE		LȊO
 */
/*****************************************************************************/
BOOL ExtractInfo_Delphi::isConstructor(const wstring &str)
{
#define CONSTRUCTOR  L"create"
	return (_wcsicmp(str.c_str(), CONSTRUCTOR) == 0 ? TRUE : FALSE);
}

/*****************************************************************************/
/*!
	@brief	\bhfXgN^ǂʂ
	@param	str			ׂ\bhւ̎Q
	@retval	TRUE		fXgN^
	@retval	FALSE		LȊO
 */
/*****************************************************************************/
BOOL ExtractInfo_Delphi::isDestructor(const wstring &str)
{
#define DESTRUCTOR   L"destroy"
	return (_wcsicmp(str.c_str(), DESTRUCTOR) == 0 ? TRUE : FALSE);
}

//[EOF]
