/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.pager.PagerCondition;
import org.seasar.dao.pager.PagerContext;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class PagerResultSetFactoryLimitOffsetWrapper
implements ResultSetFactory {
    private static final Logger LOGGER = Logger.getLogger((Class)PagerResultSetFactoryLimitOffsetWrapper.class);
    private ResultSetFactory resultSetFactory;
    private Dbms dbms;

    PagerResultSetFactoryLimitOffsetWrapper(ResultSetFactory resultSetFactory, String productName) {
        this.resultSetFactory = resultSetFactory;
        this.dbms = DbmsManager.getDbms(productName);
    }

    public PagerResultSetFactoryLimitOffsetWrapper(ResultSetFactory resultSetFactory, DataSource dataSource) {
        this.resultSetFactory = resultSetFactory;
        this.dbms = DbmsManager.getDbms(dataSource);
    }

    public ResultSet createResultSet(PreparedStatement ps) {
        Object[] args = PagerContext.getContext().peekArgs();
        if (PagerContext.isPagerCondition(args)) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    String nativeSql = ps.toString();
                    LOGGER.debug((Object)("S2Pager native SQL : " + nativeSql));
                }
                String baseSQL = this.dbms.getBaseSql(ps);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("S2Pager base SQL : " + baseSQL));
                }
                PagerCondition dto = PagerContext.getPagerCondition(args);
                dto.setCount(this.getCount(ps, baseSQL));
                if (dto.getLimit() > 0 && dto.getOffset() > -1) {
                    String limitOffsetSql = this.makeLimitOffsetSql(baseSQL, dto.getLimit(), dto.getOffset());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("S2Pager execute SQL : " + limitOffsetSql));
                    }
                    return this.resultSetFactory.createResultSet(ps.getConnection().prepareStatement(limitOffsetSql));
                }
                return this.resultSetFactory.createResultSet(ps);
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
        return this.resultSetFactory.createResultSet(ps);
    }

    String makeLimitOffsetSql(String baseSQL, int limit, int offset) {
        StringBuffer sqlBuf = new StringBuffer(baseSQL);
        sqlBuf.append(" LIMIT ");
        sqlBuf.append(limit);
        sqlBuf.append(" OFFSET ");
        sqlBuf.append(offset);
        return sqlBuf.toString();
    }

    private int getCount(PreparedStatement ps, String baseSQL) throws SQLException {
        block4: {
            int n;
            StringBuffer sqlBuf = new StringBuffer("SELECT count(*) FROM (");
            sqlBuf.append(baseSQL);
            sqlBuf.append(") AS total");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("S2Pager execute SQL : " + sqlBuf.toString()));
            }
            PreparedStatement psCount = null;
            ResultSet rs = null;
            try {
                psCount = ps.getConnection().prepareStatement(sqlBuf.toString());
                rs = this.resultSetFactory.createResultSet(psCount);
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                StatementUtil.close((Statement)psCount);
                throw throwable;
            }
            ResultSetUtil.close((ResultSet)rs);
            StatementUtil.close((Statement)psCount);
            return n;
        }
        throw new SQLException("[S2Pager]Result not found.");
    }
}

