/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.beans.Beans;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataProviderDoesNotSupportException;
import jp.gr.javacons.jim.Manager;
import org.apache.log4j.Logger;

public abstract class AbstractDataProvider
extends Component
implements DataProvider,
Serializable {
    private String dataProviderName = "";
    protected final Map dataHolders;
    private transient Manager manager;
    protected String iconName;
    private transient Image icon;
    private Map parameters;
    private static Logger logger = Logger.getLogger(AbstractDataProvider.class);

    public AbstractDataProvider() {
        this(32);
    }

    public AbstractDataProvider(int holderSize) {
        this.dataHolders = new ConcurrentHashMap(holderSize);
    }

    public boolean addDataHolder(DataHolder dh) throws DataProviderDoesNotSupportException {
        if (this.hasDataHolder(dh)) {
            throw new IllegalArgumentException("\u3053\u306e\u30db\u30eb\u30c0\u540d\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30db\u30eb\u30c0\u540d\u91cd\u8907\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002 : " + this.getDataProviderName() + "_" + dh.getDataHolderName());
        }
        if (this.hasDataHolderNamed(dh.getDataHolderName())) {
            throw new IllegalArgumentException("\"" + dh.getDataHolderName() + "\" already exists");
        }
        if (!this.isProvidableDataHolderType(dh)) {
            throw new IllegalArgumentException("Illegal DataHolder Type");
        }
        this.dataHolders.put(dh.getDataHolderName(), dh);
        dh.setDataProvider(this);
        if (this.manager != null) {
            this.manager.notifyDataHolderAvailable(this, new DataHolder[]{dh});
        }
        return true;
    }

    public void addedAsDataProvider() {
        this.manager = Manager.getInstance();
    }

    public void addNotify() {
        super.addNotify();
        int count = 1;
        if (this.dataProviderName == null || "".equals(this.dataProviderName)) {
            this.dataProviderName = this.getBaseName() + count++;
        }
        Manager man = Manager.getInstance();
        while (man.getDataProvider(this.dataProviderName) != null) {
            this.dataProviderName = this.getBaseName() + count++;
        }
        man.addDataProvider(this);
    }

    public boolean canAddDataHolderByUser() {
        return true;
    }

    public boolean canEditDataHolderByUser(DataHolder dh) {
        return this.dataHolders.containsKey(dh.getDataHolderName());
    }

    public boolean canRemoveDataHolderByUser(DataHolder dh) {
        return this.dataHolders.containsKey(dh.getDataHolderName());
    }

    public boolean canSetDataHolderName(DataHolder dh, String name) {
        if (!this.hasDataHolder(dh)) {
            throw new IllegalArgumentException("Not owned by dataProvider");
        }
        if (Manager.containsInvalidCharacter(name)) {
            return false;
        }
        return !this.hasDataHolderNamed(name);
    }

    protected String getBaseName() {
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(".");
        return className.substring(dot + 1);
    }

    public DataHolder getDataHolder(String dhName) {
        return (DataHolder)this.dataHolders.get(dhName);
    }

    public DataHolder[] getDataHolders() {
        return this.dataHolders.values().toArray(new DataHolder[0]);
    }

    public int getDataHolderCount() {
        return this.dataHolders.size();
    }

    public Collection getDataHolderValues() {
        return this.dataHolders.values();
    }

    public String getDataHolderTypeString(Class dataHolerClass, Class valueClass) {
        return null;
    }

    public String getDataProviderName() {
        return this.dataProviderName;
    }

    private Image getIcon() {
        if (this.icon == null && this.iconName != null) {
            try {
                URL url = this.getClass().getResource(this.iconName);
                Toolkit tk = Toolkit.getDefaultToolkit();
                this.icon = tk.createImage((ImageProducer)url.getContent());
            }
            catch (Exception ex) {
                this.icon = null;
            }
        }
        return this.icon;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(32, 32);
    }

    public abstract Class[][] getProvidableDataHolderTypeInfo();

    public Class[][] getProvidableDataHolderTypeInfoByUser() {
        return this.getProvidableDataHolderTypeInfo();
    }

    protected boolean hasDataHolder(DataHolder dh) {
        return this.dataHolders.containsKey(dh.getDataHolderName());
    }

    protected boolean hasDataHolderNamed(String name) {
        return this.dataHolders.containsKey(name);
    }

    protected boolean isProvidableDataHolderType(DataHolder dh) {
        Class[][] dhInfos = this.getProvidableDataHolderTypeInfo();
        for (int i = 0; i < dhInfos.length; ++i) {
            Class[] dhInfo = dhInfos[i];
            if (!dhInfo[0].equals(dh.getClass())) continue;
            if (dhInfo.length > 1) {
                for (int j = 1; j < dhInfo.length; ++j) {
                    if (!dhInfo[j].equals(dh.getValueClass())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        Image icon;
        super.paint(g);
        if (Beans.isDesignTime() && (icon = this.getIcon()) != null) {
            g.drawImage(icon, 0, 0, this);
        }
    }

    public void removedAsDataProvider() {
        this.manager = null;
    }

    public boolean removeDataHolder(DataHolder dh) throws DataProviderDoesNotSupportException {
        this.dataHolders.remove(dh.getDataHolderName());
        dh.setDataProvider(null);
        if (this.manager != null) {
            this.manager.notifyDataHolderRevoked(this, new DataHolder[]{dh});
        }
        return true;
    }

    public void removeNotify() {
        Manager.getInstance().removeDataProvider(this);
        super.removeNotify();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, 32, 32);
    }

    public void setDataProviderName(String name) {
        if (name == this.dataProviderName) {
            return;
        }
        if (name != null && name.equals(this.dataProviderName)) {
            return;
        }
        if (this.manager == null) {
            if (!Manager.getInstance().canSetDataProviderName(this, name)) {
                throw new IllegalArgumentException("invalid name");
            }
            this.dataProviderName = name;
        } else {
            if (!this.manager.canSetDataProviderName(this, name)) {
                throw new IllegalArgumentException("invalid name");
            }
            String oldName = this.dataProviderName;
            this.dataProviderName = name;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("old : " + oldName + " new : " + name));
            }
            this.manager.notifyDataProviderRenamed(this, name, oldName);
        }
    }

    public Object getParameter(Object key) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(key);
    }

    public void setParameter(Object key, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(key, value);
    }
}

