/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine;

import dori.jasper.engine.JRScriptletException;
import dori.jasper.engine.fill.JRFillField;
import dori.jasper.engine.fill.JRFillGroup;
import dori.jasper.engine.fill.JRFillParameter;
import dori.jasper.engine.fill.JRFillVariable;
import java.util.Map;

public abstract class JRAbstractScriptlet {
    protected Map parametersMap = null;
    protected Map fieldsMap = null;
    protected Map variablesMap = null;
    protected JRFillGroup[] groups = null;

    public void setData(Map parsm, Map fldsm, Map varsm, JRFillGroup[] grps) {
        this.parametersMap = parsm;
        this.fieldsMap = fldsm;
        this.variablesMap = varsm;
        this.groups = grps;
    }

    public Object getParameterValue(String parameterName) throws JRScriptletException {
        JRFillParameter parameter = (JRFillParameter)this.parametersMap.get(parameterName);
        if (parameter == null) {
            throw new JRScriptletException("Parameter not found : " + parameterName);
        }
        return parameter.getValue();
    }

    public Object getFieldValue(String fieldName) throws JRScriptletException {
        JRFillField field = (JRFillField)this.fieldsMap.get(fieldName);
        if (field == null) {
            throw new JRScriptletException("Field not found : " + fieldName);
        }
        return field.getValue();
    }

    public Object getVariableValue(String variableName) throws JRScriptletException {
        JRFillVariable variable = (JRFillVariable)this.variablesMap.get(variableName);
        if (variable == null) {
            throw new JRScriptletException("Variable not found : " + variableName);
        }
        return variable.getValue();
    }

    public void setVariableValue(String variableName, Object value) throws JRScriptletException {
        JRFillVariable variable = (JRFillVariable)this.variablesMap.get(variableName);
        if (variable == null) {
            throw new JRScriptletException("Variable not found : " + variableName);
        }
        if (value != null && !variable.getValueClass().isInstance(value)) {
            throw new JRScriptletException("Incompatible value assigned to variable " + variableName + ". Expected " + variable.getValueClassName() + ".");
        }
        variable.setValue(value);
    }

    public void callBeforeReportInit() throws JRScriptletException {
        this.beforeReportInit();
        this.beforePageInit();
        this.beforeColumnInit();
        if (this.groups != null && this.groups.length > 0) {
            int i = 0;
            while (i < this.groups.length) {
                this.beforeGroupInit(this.groups[i].getName());
                ++i;
            }
        }
    }

    public void callAfterReportInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            int i = this.groups.length - 1;
            while (i >= 0) {
                this.afterGroupInit(this.groups[i].getName());
                --i;
            }
        }
        this.afterColumnInit();
        this.afterPageInit();
        this.afterReportInit();
    }

    public void callBeforePageInit() throws JRScriptletException {
        this.beforePageInit();
        this.beforeColumnInit();
    }

    public void callAfterPageInit() throws JRScriptletException {
        this.afterColumnInit();
        this.afterPageInit();
    }

    public void callBeforeColumnInit() throws JRScriptletException {
        this.beforeColumnInit();
    }

    public void callAfterColumnInit() throws JRScriptletException {
        this.afterColumnInit();
    }

    public void callBeforeGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group = null;
            int i = 0;
            while (i < this.groups.length) {
                group = this.groups[i];
                if (group.hasChanged()) {
                    this.beforeGroupInit(group.getName());
                }
                ++i;
            }
        }
    }

    public void callAfterGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group = null;
            int i = this.groups.length - 1;
            while (i >= 0) {
                group = this.groups[i];
                if (group.hasChanged()) {
                    this.afterGroupInit(group.getName());
                }
                --i;
            }
        }
    }

    public void callBeforeDetailEval() throws JRScriptletException {
        this.beforeDetailEval();
    }

    public void callAfterDetailEval() throws JRScriptletException {
        this.afterDetailEval();
    }

    public abstract void beforeReportInit() throws JRScriptletException;

    public abstract void afterReportInit() throws JRScriptletException;

    public abstract void beforePageInit() throws JRScriptletException;

    public abstract void afterPageInit() throws JRScriptletException;

    public abstract void beforeColumnInit() throws JRScriptletException;

    public abstract void afterColumnInit() throws JRScriptletException;

    public abstract void beforeGroupInit(String var1) throws JRScriptletException;

    public abstract void afterGroupInit(String var1) throws JRScriptletException;

    public abstract void beforeDetailEval() throws JRScriptletException;

    public abstract void afterDetailEval() throws JRScriptletException;
}

