/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRTextField;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillObjectFactory;
import dori.jasper.engine.fill.JRFillTextElement;
import dori.jasper.engine.fill.JRTemplatePrintText;
import dori.jasper.engine.fill.JRTemplateText;
import dori.jasper.engine.util.JRStringUtil;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Map;

public class JRFillTextField
extends JRFillTextElement
implements JRTextField {
    private JRGroup evaluationGroup = null;
    private TextChopper textChopper = null;
    private Format format = null;
    private boolean isValueRepeating = false;
    private String oldRawText = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private static TextChopper simpleTextChopper = new TextChopper(){

        public String chop(JRFillTextField textField, int startIndex, int endIndex) {
            return textField.getStyledText().getText().substring(startIndex, endIndex);
        }
    };
    private static TextChopper styledTextChopper = new TextChopper(){

        public String chop(JRFillTextField textField, int startIndex, int endIndex) {
            return textField.filler.getStyledTextParser().write(textField.getStyledTextAttributes(), new AttributedString(textField.getStyledText().getAttributedString().getIterator(), startIndex, endIndex).getIterator(), textField.getText().substring(startIndex, endIndex));
        }
    };
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;

    protected JRFillTextField(JRBaseFiller filler, JRTextField textField, JRFillObjectFactory factory) {
        super(filler, textField, factory);
        this.evaluationGroup = factory.getGroup(textField.getEvaluationGroup());
        JRExpression expression = textField.getExpression();
        String pattern = textField.getPattern();
        if (expression != null && pattern != null && pattern.length() > 0) {
            Class expressionClass;
            if ((class$java$util$Date == null ? (class$java$util$Date = JRFillTextField.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(expressionClass = expression.getValueClass())) {
                this.format = new SimpleDateFormat(pattern);
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = JRFillTextField.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(expressionClass)) {
                this.format = new DecimalFormat(pattern);
            }
        }
        this.textChopper = textField.isStyledText() ? styledTextChopper : simpleTextChopper;
    }

    public boolean isStretchWithOverflow() {
        return ((JRTextField)this.parent).isStretchWithOverflow();
    }

    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
    }

    public byte getEvaluationTime() {
        return ((JRTextField)this.parent).getEvaluationTime();
    }

    public String getPattern() {
        return ((JRTextField)this.parent).getPattern();
    }

    public void setPattern(String pattern) {
    }

    public boolean isBlankWhenNull() {
        return ((JRTextField)this.parent).isBlankWhenNull();
    }

    public void setBlankWhenNull(boolean isBlank) {
    }

    public byte getHyperlinkType() {
        return ((JRTextField)this.parent).getHyperlinkType();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return ((JRTextField)this.parent).getExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRTextField)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRTextField)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRTextField)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRTextField)this.parent).getHyperlinkPageExpression();
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected JRTemplateText getJRTemplateText() {
        if (this.template == null) {
            this.template = new JRTemplateText((JRTextField)this.parent, this.getFont());
        }
        return (JRTemplateText)this.template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateText(evaluation);
        }
    }

    protected void evaluateText(byte evaluation) throws JRException {
        String oldRawText;
        Object textFieldValue = this.filler.calculator.evaluate(this.getExpression(), evaluation);
        if (textFieldValue == null) {
            if (this.isBlankWhenNull()) {
                textFieldValue = "";
            }
        } else if (this.format != null) {
            textFieldValue = this.format.format(textFieldValue);
        }
        String newRawText = JRStringUtil.treatNewLineChars(String.valueOf(textFieldValue));
        this.oldRawText = oldRawText = this.getRawText();
        this.setRawText(newRawText);
        this.setTextStart(0);
        this.setTextEnd(0);
        this.isValueRepeating = oldRawText == null && newRawText == null || oldRawText != null && oldRawText.equals(newRawText);
        this.anchorName = (String)this.filler.calculator.evaluate(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.filler.calculator.evaluate(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.filler.calculator.evaluate(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.filler.calculator.evaluate(this.getHyperlinkPageExpression(), evaluation);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == 1) {
            if (isOverflow) {
                if (this.getPositionType() == 3) {
                    this.setTextStart(0);
                    this.setTextEnd(0);
                }
                if ((this.getTextEnd() >= this.getText().length() || !this.isStretchWithOverflow() || this.getRotation() != 0) && this.isAlreadyPrinted()) {
                    if (this.isPrintWhenDetailOverflows()) {
                        this.setTextStart(0);
                        this.setTextEnd(0);
                        isReprinted = true;
                    } else {
                        isToPrint = false;
                    }
                }
                if (isToPrint && this.isPrintWhenExpressionNull() && !this.isPrintRepeatedValues() && this.isValueRepeating) {
                    isToPrint = false;
                }
            } else if (!(!this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating || this.isPrintInFirstWholeBand() && this.getBand().isNewPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()))) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableStretchHeight >= this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                    if (this.getTextEnd() < this.getText().length() || this.getTextEnd() == 0) {
                        if (this.isStretchWithOverflow() && this.getRotation() == 0) {
                            this.chopTextElement(availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY());
                            if (this.getTextEnd() < this.getText().length()) {
                                willOverflow = true;
                            }
                        } else {
                            this.chopTextElement(0);
                        }
                    } else {
                        isToPrint = false;
                    }
                } else {
                    isToPrint = false;
                    willOverflow = true;
                }
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getText().substring(this.getTextStart(), this.getTextEnd()).trim().length() == 0) {
                isToPrint = false;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintText text = null;
        text = new JRTemplatePrintText(this.getJRTemplateText());
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        if (this.getRotation() == 0) {
            text.setHeight(this.getStretchHeight());
        } else {
            text.setHeight(this.getHeight());
        }
        switch (this.getEvaluationTime()) {
            case 2: {
                this.filler.reportBoundTexts.put(text, this);
                break;
            }
            case 3: {
                this.filler.pageBoundTexts.put(text, this);
                break;
            }
            case 4: {
                this.filler.columnBoundTexts.put(text, this);
                break;
            }
            case 5: {
                Map specificGroupBoundTexts = (Map)this.filler.groupBoundTexts.get(this.getEvaluationGroup().getName());
                specificGroupBoundTexts.put(text, this);
                break;
            }
            default: {
                this.copy(text);
            }
        }
        return text;
    }

    protected void copy(JRPrintText text) throws JRException {
        text.setLineSpacingFactor(this.getLineSpacingFactor());
        text.setLeadingOffset(this.getLeadingOffset());
        text.setTextHeight(this.getTextHeight());
        text.setText(this.textChopper.chop(this, this.getTextStart(), this.getTextEnd()));
        text.setAnchorName(this.getAnchorName());
        text.setHyperlinkReference(this.getHyperlinkReference());
        text.setHyperlinkAnchor(this.getHyperlinkAnchor());
        text.setHyperlinkPage(this.getHyperlinkPage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface TextChopper {
        public String chop(JRFillTextField var1, int var2, int var3);
    }
}

