/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.fill.JRComparableIncrementerFactory;
import dori.jasper.engine.fill.JRDefaultIncrementerFactory;
import dori.jasper.engine.fill.JRIncrementer;
import dori.jasper.engine.fill.JRIncrementerFactory;
import dori.jasper.engine.fill.JRIntegerAverageIncrementer;
import dori.jasper.engine.fill.JRIntegerCountIncrementer;
import dori.jasper.engine.fill.JRIntegerStandardDeviationIncrementer;
import dori.jasper.engine.fill.JRIntegerSumIncrementer;
import dori.jasper.engine.fill.JRIntegerVarianceIncrementer;

public class JRIntegerIncrementerFactory
implements JRIncrementerFactory {
    protected static final Integer ZERO = new Integer(0);
    private static JRIntegerIncrementerFactory mainInstance = new JRIntegerIncrementerFactory();

    private JRIntegerIncrementerFactory() {
    }

    public static JRIntegerIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRIntegerCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRIntegerSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRIntegerAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRIntegerStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRIntegerVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

