/*
 * Decompiled with CFR 0.152.
 */
package application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;

public class AbstractBean {
    private final PropertyChangeSupport pcs = new EDTPropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        this.pcs.firePropertyChange(e);
    }

    private static class EDTPropertyChangeSupport
    extends PropertyChangeSupport {
        EDTPropertyChangeSupport(Object source) {
            super(source);
        }

        public void firePropertyChange(final PropertyChangeEvent e) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(e);
            } else {
                Runnable doFirePropertyChange = new Runnable(){

                    public void run() {
                        EDTPropertyChangeSupport.this.firePropertyChange(e);
                    }
                };
                SwingUtilities.invokeLater(doFirePropertyChange);
            }
        }
    }
}

