/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jimx.compdh;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataReferencer;
import jp.gr.javacons.jim.DataReferencerOwner;
import jp.gr.javacons.jim.QualityFlag;
import jp.gr.javacons.jim.SimpleQualityFlag;

public class DataReferencerContainer
extends DataHolder
implements Serializable {
    private static final long serialVersionUID = -8442946269251187573L;
    private Hashtable referencerTable = new Hashtable();

    public QualityFlag getQualityFlag() {
        boolean badFlag = false;
        boolean uncertainFlag = false;
        SimpleQualityFlag qf = null;
        Enumeration e = this.referencerTable.keys();
        while (e.hasMoreElements()) {
            DataHolder dh = (DataHolder)e.nextElement();
            QualityFlag qflag = dh.getQualityFlag();
            if (qflag == null) {
                uncertainFlag = true;
                continue;
            }
            if (qflag.getQuality() == 0) {
                badFlag = true;
            }
            if (qflag.getQuality() != 1) continue;
            uncertainFlag = true;
        }
        qf = badFlag ? new SimpleQualityFlag(0) : (uncertainFlag ? new SimpleQualityFlag(1) : new SimpleQualityFlag(3));
        return qf;
    }

    public void addMember(DataHolder dataHolder) {
        DataReferencer ref = (DataReferencer)this.referencerTable.get(dataHolder);
        if (ref == null) {
            ref = new DataReferencer(dataHolder.getDataProvider().getDataProviderName(), dataHolder.getDataHolderName());
            this.referencerTable.put(dataHolder, ref);
        }
    }

    public void removeMember(DataHolder dataHolder) {
        if (this.referencerTable.remove(dataHolder) == null) {
            System.out.println("fail : DataReferencerContainer.removeMember");
        }
    }

    public DataReferencer getMember(DataHolder dataHolder) {
        return (DataReferencer)this.referencerTable.get(dataHolder);
    }

    public Enumeration getMembers() {
        return this.referencerTable.elements();
    }

    public Enumeration getDataHolders() {
        return this.referencerTable.keys();
    }

    public void connectAll(DataReferencerOwner owner) {
        Enumeration e = this.referencerTable.elements();
        while (e.hasMoreElements()) {
            DataReferencer ref = (DataReferencer)e.nextElement();
            ref.connect(owner);
        }
    }

    public void disconnectAll(DataReferencerOwner owner) {
        Enumeration e = this.referencerTable.elements();
        while (e.hasMoreElements()) {
            DataReferencer ref = (DataReferencer)e.nextElement();
            ref.disconnect(owner);
        }
    }

    public void memberConnected(DataHolder holder, DataReferencer ref) {
        this.referencerTable.put(holder, ref);
    }

    public void memberDisconnected(DataHolder holder, DataReferencer ref) {
        this.referencerTable.remove(holder);
    }
}

