/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jimx.cyclicread;

import java.text.CollationKey;
import java.text.Collator;

final class Utility {
    private Utility() {
    }

    public static void sort(Object[] src, Object[] dest, int low, int high, Comparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Utility.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Utility.sort(dest, src, low, mid, c);
        Utility.sort(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    public static void sort(Object[] a, Comparator c) {
        Object[] aux = (Object[])a.clone();
        Utility.sort(aux, a, 0, a.length, c);
    }

    public static String[] sort(String[] src) {
        int size = src.length;
        Collator col = Collator.getInstance();
        Object[] keys = new CollationKey[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = col.getCollationKey(src[i]);
        }
        Object[] target = new CollationKey[size];
        System.arraycopy(keys, 0, target, 0, size);
        Utility.sort(keys, target, 0, size, new Comparator(){

            int compare(Object o1, Object o2) {
                CollationKey k1 = (CollationKey)o1;
                CollationKey k2 = (CollationKey)o2;
                return k1.compareTo(k2);
            }
        });
        String[] str = new String[size];
        for (int i = 0; i < size; ++i) {
            str[i] = ((CollationKey)target[i]).getSourceString();
        }
        return str;
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    static abstract class Comparator {
        Comparator() {
        }

        abstract int compare(Object var1, Object var2);
    }
}

