/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import jp.co.frdm.Vamp.PlcTable;
import jp.co.frdm.Vamp.emulator.AbstractPlc;
import jp.co.frdm.Vamp.receiver.AbstractReceiver;
import jp.co.frdm.Vamp.receiver.ReceiverFactory;

public class Util {
    static final String hexString = "0123456789ABCDEF0123456789abcdef";

    private Util() {
    }

    public static byte[] toByteArrey(String srcData) throws IllegalArgumentException {
        if (srcData == null) {
            return null;
        }
        if (srcData.length() % 2 != 0) {
            throw new IllegalArgumentException("length % 2 != 0");
        }
        byte[] retData = new byte[srcData.length() / 2];
        String data = srcData.toUpperCase();
        int srcPos = 0;
        int retPos = 0;
        while (retPos < retData.length) {
            int l;
            int h;
            if ((h = hexString.indexOf(data.charAt(srcPos++))) < 0) {
                throw new IllegalArgumentException("0~9 or A~F " + h);
            }
            retData[retPos] = (byte)((h & 0xFF) << 4);
            if ((l = hexString.indexOf(data.charAt(srcPos++))) < 0) {
                throw new IllegalArgumentException("0~9 or A~F " + l);
            }
            int n = retPos++;
            retData[n] = (byte)(retData[n] | (byte)(l & 0xFF));
        }
        return retData;
    }

    public static String toString(byte[] srcData) {
        if (srcData == null) {
            return null;
        }
        StringBuffer retData = new StringBuffer();
        for (int i = 0; i < srcData.length; ++i) {
            retData.append(hexString.charAt(srcData[i] >> 4 & 0xF));
            retData.append(hexString.charAt(srcData[i] & 0xF));
        }
        return retData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlcTable(File vmpFile, PlcTable plcTable) {
        ReceiverFactory.allClear();
        plcTable.removeAllPlc();
        ObjectInputStream in = null;
        try {
            AbstractPlc plc;
            in = new ObjectInputStream(new FileInputStream(vmpFile));
            while ((plc = (AbstractPlc)in.readObject()) != null) {
                plc.startPlc();
                plcTable.addPlc(plc);
                AbstractReceiver receiver = ReceiverFactory.getReceiver(plc.getPortNo());
                receiver.addRecvListener(plc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static byte[] toByteArray(byte[] chars, int spos) {
        if (chars == null) {
            return null;
        }
        return Util.toByteArray(chars, spos, chars.length - spos);
    }

    public static byte[] toByteArray(byte[] chars, int spos, int clen) {
        if (chars == null) {
            return null;
        }
        if (clen % 2 != 0) {
            throw new IllegalArgumentException("clen % 2 != 0");
        }
        if (chars.length < spos + clen) {
            throw new IllegalArgumentException("chars.length < spos + clen");
        }
        byte[] retData = new byte[clen / 2];
        int retPos = 0;
        while (retPos < clen / 2) {
            int l;
            int h;
            if ((h = hexString.indexOf(chars[spos++])) < 0) {
                throw new IllegalArgumentException("0~9 or A~F " + h);
            }
            retData[retPos] = (byte)((h & 0xFF) << 4);
            if ((l = hexString.indexOf(chars[spos++])) < 0) {
                throw new IllegalArgumentException("0~9 or A~F " + l);
            }
            int n = retPos++;
            retData[n] = (byte)(retData[n] | (byte)(l & 0xFF));
        }
        return retData;
    }
}

