/*
 * Decompiled with CFR 0.152.
 */
package program;

import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.frdm.Vamp.Util;
import jp.co.frdm.Vamp.emulator.PlcControl;
import program.PlcRunnable;

public class BitOnOff
implements PlcRunnable {
    private final Timer timer = new Timer();

    public void startUpCall(PlcControl plc) throws Exception {
        this.timer.schedule((TimerTask)new AnalogTask(plc), 0L, 1000L);
        this.timer.schedule((TimerTask)new DemandTask(plc), 0L, 30000L);
    }

    public void cycleCall(PlcControl plc) throws Exception {
    }

    static class DemandTask
    extends TimerTask {
        private final PlcControl plc;
        private int count;
        private int mokuhyouti;
        private int zenkaiti;
        private int genzaiti;
        private int nokoriti;
        private int heikinti;
        private int yosouti;
        private int saidaiti;

        DemandTask(PlcControl plc) {
            this.plc = plc;
            this.mokuhyouti = this.readPlc("DM", 3301, 1);
        }

        public void run() {
            this.incCount();
            this.calc();
        }

        private int readPlc(String mem, int address, int length) {
            return Integer.parseInt(Util.toString(this.plc.readPlcMem(mem, address, length)));
        }

        private void writePlc(String mem, int address, int value) {
            DecimalFormat f = new DecimalFormat("0000");
            this.plc.writePlcMem(mem, address, Util.toByteArrey(String.valueOf(f.format(value))));
        }

        private void calc() {
            this.genzaiti = Integer.parseInt(Util.toString(Randamizer.get(100)));
            if (this.saidaiti < this.genzaiti) {
                this.saidaiti = this.genzaiti;
            }
            this.nokoriti = this.regularization(this.mokuhyouti - this.genzaiti);
            this.heikinti = this.regularization((this.genzaiti - this.zenkaiti) * 1800 / 30);
            this.yosouti = this.regularization((this.genzaiti - this.zenkaiti) * (60 - this.count) + this.genzaiti);
            System.out.println(this.genzaiti);
            System.out.println(this.saidaiti);
            System.out.println(this.nokoriti);
            System.out.println(this.heikinti);
            System.out.println(this.yosouti);
            this.writePlc("DM", 3307, this.genzaiti);
            this.writePlc("DM", 3318, this.saidaiti);
            this.writePlc("DM", 3308, this.nokoriti);
            this.writePlc("DM", 3309, this.heikinti);
            this.writePlc("DM", 3310, this.yosouti);
        }

        private void incCount() {
            ++this.count;
            if (this.count >= 30) {
                this.count = 0;
                this.zenkaiti = this.genzaiti;
            }
            this.writePlc("DM", 3316, this.count);
        }

        private int regularization(int value) {
            return value < 0 ? 0 : (value > 9999 ? 9999 : value);
        }
    }

    static class AnalogTask
    extends TimerTask {
        private final PlcControl plc;

        AnalogTask(PlcControl plc) {
            this.plc = plc;
        }

        public void run() {
            for (int i = 500; i < 600; ++i) {
                this.plc.writePlcMem("DM", i, this.randomNumber());
            }
        }

        private byte[] randomNumber() {
            return Randamizer.get(1000);
        }
    }

    static class Randamizer {
        Randamizer() {
        }

        static byte[] get(int base) {
            DecimalFormat f = new DecimalFormat("0000");
            int random = (int)(Math.random() * 1000.0 + (double)base);
            if (random > 4000) {
                random = 4000;
            }
            return Util.toByteArrey(f.format(random));
        }
    }
}

