/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.expr.DefaultExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.UnaryExpr;
import org.jaxen.function.NumberFunction;

class DefaultUnaryExpr
extends DefaultExpr
implements UnaryExpr {
    private Expr expr;

    public DefaultUnaryExpr(Expr expr) {
        this.expr = expr;
    }

    public Object evaluate(Context context) throws JaxenException {
        Number number = NumberFunction.evaluate(this.getExpr().evaluate(context), context.getNavigator());
        if (number instanceof Integer) {
            return new Integer(number.intValue() * -1);
        }
        return new Double(number.doubleValue() * -1.0);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public String getText() {
        return "-(" + this.getExpr().getText() + ")";
    }

    public Expr simplify() {
        this.expr = this.expr.simplify();
        return this;
    }

    public String toString() {
        return "[(DefaultUnaryExpr): " + this.getExpr() + "]";
    }
}

