/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv.handlers;

import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.AbstractPipelineComponent;
import org.dbunit.dataset.csv.handlers.Helper;
import org.dbunit.dataset.csv.handlers.PipelineComponent;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.csv.handlers.SeparatorHandler;
import org.dbunit.dataset.csv.handlers.WhitespacesHandler;

public class IsAlnumHandler
extends AbstractPipelineComponent {
    private IsAlnumHandler() {
    }

    public static final PipelineComponent ACCEPT() {
        return IsAlnumHandler.createPipelineComponent(new IsAlnumHandler(), new AbstractPipelineComponent.ACCEPT());
    }

    public static final PipelineComponent IGNORE() {
        return IsAlnumHandler.createPipelineComponent(new IsAlnumHandler(), new AbstractPipelineComponent.IGNORE());
    }

    public static final PipelineComponent QUOTE() {
        return IsAlnumHandler.createPipelineComponent(new IsAlnumHandler(), new QUOTE());
    }

    public boolean canHandle(char c) throws IllegalInputCharacterException {
        return c != ',' && !Character.isWhitespace(c) && c != '\\';
    }

    protected static class UNQUOTE
    extends Helper {
        protected UNQUOTE() {
        }

        public void helpWith(char c) {
            try {
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
            }
            catch (PipelineException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    protected static class QUOTE
    extends Helper {
        private boolean add = true;

        protected QUOTE() {
        }

        public void helpWith(char c) {
            this.getHandler().getPipeline().putFront(SeparatorHandler.ENDPIECE());
            this.getHandler().getPipeline().putFront(IsAlnumHandler.ACCEPT());
            this.getHandler().getPipeline().putFront(WhitespacesHandler.ACCEPT());
            this.getHandler().accept(c);
        }
    }
}

