/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class ErrorsTool
implements ViewTool {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpSession session;
    protected MessageResources resources;
    protected Locale locale;
    protected ActionErrors errors;

    public void init(Object obj) {
        if (!(obj instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext context = (ViewContext)obj;
        this.request = context.getRequest();
        this.session = this.request.getSession(false);
        this.application = context.getServletContext();
        this.resources = StrutsUtils.getMessageResources(this.application);
        this.locale = StrutsUtils.getLocale(this.request, this.session);
        this.errors = StrutsUtils.getActionErrors(this.request);
    }

    public boolean exist() {
        if (this.errors == null) {
            return false;
        }
        return !this.errors.empty();
    }

    public boolean exist(String property) {
        if (this.errors == null) {
            return false;
        }
        return this.errors.size(property) > 0;
    }

    public int getSize() {
        if (this.errors == null) {
            return 0;
        }
        return this.errors.size();
    }

    public int getSize(String property) {
        if (this.errors == null) {
            return 0;
        }
        return this.errors.size(property);
    }

    public ArrayList getGlobal() {
        return this.get(this.getGlobalName());
    }

    public ArrayList getAll() {
        return this.get(null);
    }

    public ArrayList get(String property) {
        if (this.errors == null || this.errors.empty()) {
            return null;
        }
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return null;
        }
        Iterator errormsgs = property == null ? this.errors.get() : this.errors.get(property);
        if (!errormsgs.hasNext()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (errormsgs.hasNext()) {
            ActionError errormsg = (ActionError)errormsgs.next();
            String message = this.resources.getMessage(this.locale, errormsg.getKey(), errormsg.getValues());
            if (message != null) {
                list.add(message);
                continue;
            }
            Velocity.warn((Object)("Message for key \"" + errormsg.getKey() + "\" could not be found."));
            list.add(errormsg.getKey());
        }
        return list;
    }

    public String getMsgs() {
        return StrutsUtils.errorMarkup(null, this.request, this.session, this.application);
    }

    public String getMsgs(String property) {
        return StrutsUtils.errorMarkup(property, this.request, this.session, this.application);
    }

    public String getGlobalName() {
        return StrutsUtils.getGlobalErrorName();
    }
}

