/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.tools.view.servlet.VelocityViewServlet;

public class VelocityLayoutServlet
extends VelocityViewServlet {
    public static final String PROPERTY_ERROR_TEMPLATE = "tools.view.servlet.error.template";
    public static final String PROPERTY_LAYOUT_DIR = "tools.view.servlet.layout.directory";
    public static final String PROPERTY_DEFAULT_LAYOUT = "tools.view.servlet.layout.default.template";
    public static String DEFAULT_ERROR_TEMPLATE = "Error.vm";
    public static String DEFAULT_LAYOUT_DIR = "layout/";
    public static String DEFAULT_DEFAULT_LAYOUT = "Default.vm";
    public static String KEY_SCREEN_CONTENT = "screen_content";
    public static String KEY_LAYOUT = "layout";
    public static String KEY_ERROR_CAUSE = "error_cause";
    public static String KEY_ERROR_STACKTRACE = "stack_trace";
    public static String KEY_ERROR_INVOCATION_EXCEPTION = "invocation_exception";
    private String errorTemplate;
    private String layoutDir;
    private String defaultLayout;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.errorTemplate = RuntimeSingleton.getString((String)PROPERTY_ERROR_TEMPLATE, (String)DEFAULT_ERROR_TEMPLATE);
        this.layoutDir = RuntimeSingleton.getString((String)PROPERTY_LAYOUT_DIR, (String)DEFAULT_LAYOUT_DIR);
        this.defaultLayout = RuntimeSingleton.getString((String)PROPERTY_DEFAULT_LAYOUT, (String)DEFAULT_DEFAULT_LAYOUT);
        if (!this.layoutDir.endsWith("/")) {
            this.layoutDir = this.layoutDir + '/';
        }
        Velocity.info((Object)("VelocityLayoutServlet: Error screen is '" + this.errorTemplate + "'"));
        Velocity.info((Object)("VelocityLayoutServlet: Layout directory is '" + this.layoutDir + "'"));
        Velocity.info((Object)("VelocityLayoutServlet: Default layout template is '" + this.defaultLayout + "'"));
        this.defaultLayout = this.layoutDir + this.defaultLayout;
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        Context ctx = super.createContext(request, response);
        String layout = request.getParameter(KEY_LAYOUT);
        if (layout != null) {
            ctx.put(KEY_LAYOUT, (Object)layout);
        }
        return ctx;
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        block2: {
            StringWriter sw = new StringWriter();
            template.merge(context, (Writer)sw);
            context.put(KEY_SCREEN_CONTENT, (Object)sw.toString());
            Object obj = context.get(KEY_LAYOUT);
            String layout = obj == null ? null : obj.toString();
            layout = layout == null ? this.defaultLayout : this.layoutDir + layout;
            try {
                template = this.getTemplate(layout);
            }
            catch (Exception e) {
                Velocity.error((Object)("Can't load layout \"" + layout + "\": " + e));
                if (layout.equals(this.defaultLayout)) break block2;
                template = this.getTemplate(this.defaultLayout);
            }
        }
        super.mergeTemplate(template, context, response);
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException, IOException {
        try {
            Context ctx = this.createContext(request, response);
            Throwable cause = e;
            if (cause instanceof MethodInvocationException) {
                ctx.put(KEY_ERROR_INVOCATION_EXCEPTION, (Object)e);
                cause = ((MethodInvocationException)e).getWrappedThrowable();
            }
            ctx.put(KEY_ERROR_CAUSE, (Object)cause);
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            ctx.put(KEY_ERROR_STACKTRACE, (Object)sw.toString());
            Template et = this.getTemplate(this.errorTemplate);
            this.mergeTemplate(et, ctx, response);
            this.requestCleanup(request, response, ctx);
        }
        catch (Exception e2) {
            super.error(request, response, e);
        }
    }
}

