SELECT
        a.convert_min verticalMinimum
        ,a.convert_max verticalMaximum
        ,a.input_min verticalInputMinimum
        ,a.input_max verticalInputMaximum
        ,p.point pointNo
        ,p.unit pointUnit
        ,p.name pointName
        ,p.unit_mark pointUnitMark
        ,i.provider || '_' || i.holder dataHolderName
    FROM
        item_table i JOIN analog_type_table a
            ON i.analog_type_id = a.analog_type_id JOIN point_table p
            ON i.point = p.point
    WHERE
        i.provider IN /*condition.providers*/('P1', 'P2')
        AND i.holder IN /*condition.holders*/('D_500_BcdSingle', 'D_501_BcdSingle', 'D_502_BcdSingle')
        /*IF condition.unit != null*/AND p.unit like /*condition.unit*/'%AHU%'  /*END*/
        /*IF condition.name != null*/AND p.name like /*condition.name*/'%1F%'  /*END*/
        /*IF condition.unitMark != null*/AND p.unit_mark like /*condition.unitMark*/'%mark%'  /*END*/
    ORDER BY i.point, i.provider, i.holder
