/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class SolrParamResourceLoader
extends ResourceLoader {
    private Map<String, String> templates = new HashMap<String, String>();

    public SolrParamResourceLoader(SolrQueryRequest request) {
        SolrParams params = request.getParams();
        Iterator names = params.getParameterNamesIterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (!name.startsWith("v.template.")) continue;
            this.templates.put(name.substring(11) + ".vm", params.get(name));
        }
    }

    public void init(ExtendedProperties extendedProperties) {
    }

    public InputStream getResourceStream(String s) throws ResourceNotFoundException {
        String template = this.templates.get(s);
        return template == null ? null : new ByteArrayInputStream(template.getBytes(StandardCharsets.UTF_8));
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

