/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LangIdParams;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageIdentifierUpdateProcessor
extends UpdateRequestProcessor
implements LangIdParams {
    protected static final Logger log = LoggerFactory.getLogger(LanguageIdentifierUpdateProcessor.class);
    protected boolean enabled;
    protected String[] inputFields = new String[0];
    protected String[] mapFields = new String[0];
    protected Pattern mapPattern;
    protected String mapReplaceStr;
    protected String langField;
    protected String langsField;
    protected String docIdField;
    protected String fallbackValue;
    protected String[] fallbackFields = new String[0];
    protected boolean enableMapping;
    protected boolean mapKeepOrig;
    protected boolean overwrite;
    protected boolean mapOverwrite;
    protected boolean mapIndividual;
    protected boolean enforceSchema;
    protected double threshold;
    protected HashSet<String> langWhitelist;
    protected HashSet<String> mapIndividualFieldsSet;
    protected HashSet<String> allMapFieldsSet;
    protected HashMap<String, String> lcMap;
    protected HashMap<String, String> mapLcMap;
    protected IndexSchema schema;
    protected int maxFieldValueChars;
    protected int maxTotalChars;
    protected final Pattern tikaSimilarityPattern = Pattern.compile(".*\\((.*?)\\)");
    protected final Pattern langPattern = Pattern.compile("\\{lang\\}");

    public LanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(next);
        this.schema = req.getSchema();
        this.initParams(req.getParams());
    }

    private void initParams(SolrParams params) {
        if (params != null) {
            String[] keyVal;
            this.setEnabled(params.getBool("langid", true));
            if (params.get("langid.fl", "").length() > 0) {
                this.inputFields = params.get("langid.fl", "").split(",");
            }
            this.langField = params.get("langid.langField", DOCID_LANGFIELD_DEFAULT);
            this.langsField = params.get("langid.langsField", DOCID_LANGSFIELD_DEFAULT);
            SchemaField uniqueKeyField = this.schema.getUniqueKeyField();
            this.docIdField = params.get("langid.idField", uniqueKeyField == null ? "id" : uniqueKeyField.getName());
            this.fallbackValue = params.get("langid.fallback");
            if (params.get("langid.fallbackFields", "").length() > 0) {
                this.fallbackFields = params.get("langid.fallbackFields").split(",");
            }
            this.overwrite = params.getBool("langid.overwrite", false);
            this.langWhitelist = new HashSet();
            this.threshold = params.getDouble("langid.threshold", DOCID_THRESHOLD_DEFAULT.doubleValue());
            if (params.get("langid.whitelist", "").length() > 0) {
                for (String lang : params.get("langid.whitelist", "").split(",")) {
                    this.langWhitelist.add(lang);
                }
            }
            this.enableMapping = params.getBool("langid.map", false);
            this.mapFields = params.get("langid.map.fl", "").length() > 0 ? params.get("langid.map.fl", "").split(",") : this.inputFields;
            this.mapKeepOrig = params.getBool("langid.map.keepOrig", false);
            this.mapOverwrite = params.getBool("langid.map.overwrite", false);
            this.mapIndividual = params.getBool("langid.map.individual", false);
            Object[] mapIndividualFields = new String[]{};
            mapIndividualFields = params.get("langid.map.individual.fl", "").length() > 0 ? params.get("langid.map.individual.fl", "").split(",") : this.mapFields;
            this.mapIndividualFieldsSet = new HashSet<String>(Arrays.asList(mapIndividualFields));
            this.allMapFieldsSet = new HashSet<String>(Arrays.asList(this.mapFields));
            if (Arrays.equals(this.mapFields, mapIndividualFields)) {
                this.allMapFieldsSet.addAll(this.mapIndividualFieldsSet);
            }
            this.lcMap = new HashMap();
            if (params.get("langid.lcmap") != null) {
                for (String mapping : params.get("langid.lcmap").split("[, ]")) {
                    keyVal = mapping.split(":");
                    if (keyVal.length == 2) {
                        this.lcMap.put(keyVal[0], keyVal[1]);
                        continue;
                    }
                    log.error("Unsupported format for langid.lcmap: " + mapping + ". Skipping this mapping.");
                }
            }
            this.mapLcMap = new HashMap();
            if (params.get("langid.map.lcmap") != null) {
                for (String mapping : params.get("langid.map.lcmap").split("[, ]")) {
                    keyVal = mapping.split(":");
                    if (keyVal.length == 2) {
                        this.mapLcMap.put(keyVal[0], keyVal[1]);
                        continue;
                    }
                    log.error("Unsupported format for langid.map.lcmap: " + mapping + ". Skipping this mapping.");
                }
            }
            this.enforceSchema = params.getBool("langid.enforceSchema", true);
            this.mapPattern = Pattern.compile(params.get("langid.map.pattern", "(.*)"));
            this.mapReplaceStr = params.get("langid.map.replace", "$1_{lang}");
            this.maxFieldValueChars = params.getInt("langid.maxFieldValueChars", 10000);
            this.maxTotalChars = params.getInt("langid.maxTotalChars", 20000);
            if (this.maxFieldValueChars > this.maxTotalChars) {
                if (this.maxTotalChars == 20000) {
                    log.warn("langid.maxFieldValueChars (" + this.maxFieldValueChars + ") is less than " + "langid.maxTotalChars" + " (" + this.maxTotalChars + ").  Setting " + "langid.maxTotalChars" + " to " + this.maxFieldValueChars + ".");
                    this.maxTotalChars = this.maxFieldValueChars;
                } else {
                    log.warn("langid.maxFieldValueChars (" + this.maxFieldValueChars + ") is less than " + "langid.maxTotalChars" + " (" + this.maxTotalChars + ").  Setting " + "langid.maxFieldValueChars" + " to " + this.maxTotalChars + ".");
                    this.maxFieldValueChars = this.maxTotalChars;
                }
            }
        }
        log.debug("LangId configured");
        if (this.inputFields.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing or faulty configuration of LanguageIdentifierUpdateProcessor. Input fields must be specified as a comma separated list");
        }
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        if (this.isEnabled()) {
            this.process(cmd.getSolrInputDocument());
        } else {
            log.debug("Processor not enabled, not running");
        }
        super.processAdd(cmd);
    }

    protected SolrInputDocument process(SolrInputDocument doc) {
        String docLang = null;
        HashSet<String> docLangs = new HashSet<String>();
        String fallbackLang = this.getFallbackLang(doc, this.fallbackFields, this.fallbackValue);
        if (this.langField == null || !doc.containsKey((Object)this.langField) || doc.containsKey((Object)this.langField) && this.overwrite) {
            List<DetectedLanguage> languagelist = this.detectLanguage(doc);
            docLang = this.resolveLanguage(languagelist, fallbackLang);
            docLangs.add(docLang);
            log.debug("Detected main document language from fields " + Arrays.toString(this.inputFields) + ": " + docLang);
            if (doc.containsKey((Object)this.langField) && this.overwrite) {
                log.debug("Overwritten old value " + doc.getFieldValue(this.langField));
            }
            if (this.langField != null && this.langField.length() != 0) {
                doc.setField(this.langField, (Object)docLang);
            }
        } else {
            docLang = this.resolveLanguage((String)doc.getFieldValue(this.langField), fallbackLang);
            docLangs.add(docLang);
            log.debug("Field " + this.langField + " already contained value " + docLang + ", not overwriting.");
        }
        if (this.enableMapping) {
            for (String fieldName : this.allMapFieldsSet) {
                String fieldLang;
                if (!doc.containsKey((Object)fieldName)) continue;
                if (this.mapIndividual && this.mapIndividualFieldsSet.contains(fieldName)) {
                    List<DetectedLanguage> languagelist = this.detectLanguage(doc);
                    fieldLang = this.resolveLanguage(languagelist, docLang);
                    docLangs.add(fieldLang);
                    log.debug("Mapping field " + fieldName + " using individually detected language " + fieldLang);
                } else {
                    fieldLang = docLang;
                    log.debug("Mapping field " + fieldName + " using document global language " + fieldLang);
                }
                String mappedOutputField = this.getMappedField(fieldName, fieldLang);
                if (mappedOutputField != null) {
                    log.debug("Mapping field {} to {}", doc.getFieldValue(this.docIdField), (Object)fieldLang);
                    SolrInputField inField = doc.getField(fieldName);
                    doc.setField(mappedOutputField, inField.getValue(), inField.getBoost());
                    if (this.mapKeepOrig) continue;
                    log.debug("Removing old field {}", (Object)fieldName);
                    doc.removeField(fieldName);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid output field mapping for " + fieldName + " field and language: " + fieldLang);
            }
        }
        if (this.langsField != null && this.langsField.length() != 0) {
            doc.setField(this.langsField, (Object)docLangs.toArray());
        }
        return doc;
    }

    private String getFallbackLang(SolrInputDocument doc, String[] fallbackFields, String fallbackValue) {
        String lang = null;
        for (String field : fallbackFields) {
            if (!doc.containsKey((Object)field)) continue;
            lang = (String)doc.getFieldValue(field);
            log.debug("Language fallback to field " + field);
            break;
        }
        if (lang == null) {
            log.debug("Language fallback to value " + fallbackValue);
            lang = fallbackValue;
        }
        return lang;
    }

    protected abstract List<DetectedLanguage> detectLanguage(SolrInputDocument var1);

    protected String resolveLanguage(String language, String fallbackLang) {
        ArrayList<DetectedLanguage> l = new ArrayList<DetectedLanguage>();
        l.add(new DetectedLanguage(language, 1.0));
        return this.resolveLanguage(l, fallbackLang);
    }

    protected String resolveLanguage(List<DetectedLanguage> languages, String fallbackLang) {
        String langStr;
        if (languages.size() == 0) {
            log.debug("No language detected, using fallback {}", (Object)fallbackLang);
            langStr = fallbackLang;
        } else {
            DetectedLanguage lang = languages.get(0);
            String normalizedLang = this.normalizeLangCode(lang.getLangCode());
            if (this.langWhitelist.isEmpty() || this.langWhitelist.contains(normalizedLang)) {
                log.debug("Language detected {} with certainty {}", (Object)normalizedLang, (Object)lang.getCertainty());
                if (lang.getCertainty() >= this.threshold) {
                    langStr = normalizedLang;
                } else {
                    log.debug("Detected language below threshold {}, using fallback {}", (Object)this.threshold, (Object)fallbackLang);
                    langStr = fallbackLang;
                }
            } else {
                log.debug("Detected a language not in whitelist ({}), using fallback {}", (Object)lang.getLangCode(), (Object)fallbackLang);
                langStr = fallbackLang;
            }
        }
        if (langStr == null || langStr.length() == 0) {
            log.warn("Language resolved to null or empty string. Fallback not configured?");
            langStr = "";
        }
        return langStr;
    }

    protected String normalizeLangCode(String langCode) {
        if (this.lcMap.containsKey(langCode)) {
            String lc = this.lcMap.get(langCode);
            log.debug("Doing langcode normalization mapping from " + langCode + " to " + lc);
            return lc;
        }
        return langCode;
    }

    protected String getMappedField(String currentField, String language) {
        String lc = this.mapLcMap.containsKey(language) ? this.mapLcMap.get(language) : language;
        String newFieldName = this.langPattern.matcher(this.mapPattern.matcher(currentField).replaceFirst(this.mapReplaceStr)).replaceFirst(lc);
        if (this.enforceSchema && this.schema.getFieldOrNull(newFieldName) == null) {
            log.warn("Unsuccessful field name mapping from {} to {}, field does not exist and enforceSchema=true; skipping mapping.", (Object)currentField, (Object)newFieldName);
            return null;
        }
        log.debug("Doing mapping from " + currentField + " with language " + language + " to field " + newFieldName);
        return newFieldName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

