/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockCommand
extends DatanodeCommand {
    public static final long NO_ACK = Long.MAX_VALUE;
    String poolId;
    Block[] blocks;
    DatanodeInfo[][] targets;
    private static final DatanodeInfo[][] EMPTY_TARGET = new DatanodeInfo[0][];

    public BlockCommand(int action, String poolId, List<DatanodeDescriptor.BlockTargetPair> blocktargetlist) {
        super(action);
        this.poolId = poolId;
        this.blocks = new Block[blocktargetlist.size()];
        this.targets = new DatanodeInfo[this.blocks.length][];
        for (int i = 0; i < this.blocks.length; ++i) {
            DatanodeDescriptor.BlockTargetPair p = blocktargetlist.get(i);
            this.blocks[i] = p.block;
            this.targets[i] = p.targets;
        }
    }

    public BlockCommand(int action, String poolId, Block[] blocks) {
        this(action, poolId, blocks, EMPTY_TARGET);
    }

    public BlockCommand(int action, String poolId, Block[] blocks, DatanodeInfo[][] targets) {
        super(action);
        this.poolId = poolId;
        this.blocks = blocks;
        this.targets = targets;
    }

    public String getBlockPoolId() {
        return this.poolId;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public DatanodeInfo[][] getTargets() {
        return this.targets;
    }
}

